/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.EnumSqlContext=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),postgres_array_1=require("postgres-array"),schema_sql_context_1=require("./schema-sql-context");class EnumSqlContext extends schema_sql_context_1.SchemaSqlContext{async createEnumTypes(e){const t=e.map(e=>this.createEnumTypeSql(e)).join(" ");if(t)await this.executeSqlStatement({sql:t})}createEnumTypeSql(e){return`\n                DO $$\n                    BEGIN\n                        IF NOT EXISTS (\n                        SELECT 1 FROM pg_type t\n                        LEFT JOIN pg_namespace p ON t.typnamespace=p.oid\n                        WHERE t.typname='${e.name}' AND p.nspname='${this.schemaName}'\n                        ) THEN\n                            CREATE TYPE ${this.schemaName}.${e.name} AS ENUM(${Object.keys(e.values).map(e=>`'${e}'`).join(",")});\n                        END IF;\n                    END\n                $$;\n                `}async listAllEnumTypes(){const e=`SELECT t.typname AS udt_name,\n                                string_agg(e.enumlabel, ', ' ORDER BY e.enumsortorder) AS enum_values\n                            FROM pg_type t \n                            JOIN pg_enum e \n                                ON t.oid = e.enumtypid  \n                            JOIN pg_catalog.pg_namespace n \n                                ON n.oid = t.typnamespace\n                            WHERE n.nspname = '${this.schemaName}'\n                            GROUP BY udt_name\n                            ORDER BY udt_name;`;return(await this.executeSqlStatement({sql:e})||[]).map(e=>({enumTypeName:e.udt_name,enumValues:`{${e.enum_values}}`}))}async listEnumTypesUsage(e){const t=e?`AND col.udt_name = '${e}'`:"",n=`SELECT \n                                col.table_name,\n                                col.column_name,\n                                col.udt_name\n                            FROM information_schema.columns col\n                            INNER JOIN information_schema.tables tab\n                                ON tab.table_schema = col.table_schema\n                                AND tab.table_name = col.table_name\n                                AND tab.table_type = 'BASE TABLE'\n                            INNER JOIN pg_type typ\n                                ON col.udt_name = typ.typname\n                            INNER JOIN pg_namespace ns\n                                ON typ.typnamespace = ns.oid \n                                AND ns.nspname = col.table_schema\n                            WHERE col.table_schema = '${this.schemaName}'\n                                AND typ.typtype in ('e', 'b')  \n                                ${t}\n                            ORDER BY col.table_name,\n                                col.ordinal_position;`;return(await this.executeSqlStatement({sql:n})||[]).map(e=>({tableName:e.table_name,columnName:e.column_name,enumTypeName:e.udt_name.startsWith("_")?e.udt_name.substring(1):e.udt_name}))}enumTypeExists(e){const t="SELECT 1 FROM pg_type t LEFT JOIN pg_namespace p ON t.typnamespace=p.oid WHERE t.typname=$1 AND p.nspname=$2";return this.connectionPool.withConnection(async n=>(await this.connectionPool.execute(n,t,[e,this.schemaName],{logLevel:"debug"})).length>0)}async dropEnum(e,t){if(t?.cascade&&t.restrict)throw new Error("drop can only be cascade or restrict and not both");const n=`DROP TYPE IF EXISTS ${this.schemaName}.${e} ${t?.cascade?"CASCADE":""} ${t?.restrict?"RESTRICT":""};`;await this.executeSqlStatement({sql:n})}async renameEnumAttributes(e,t){const n=`ALTER TYPE ${this.schemaName}.${e} RENAME VALUE '${t.oldValue}' TO '${t.newValue}';`;await this.executeSqlStatement({sql:n})}async addAttributesToEnum(e,t){const n=`ALTER TYPE ${this.schemaName}.${e} ADD VALUE IF NOT EXISTS '${t.newValue}' ${t?.position?.after?`AFTER '${t.position.after}'`:""} ${t?.position?.before?`BEFORE '${t.position.before}'`:""} ;`;await this.executeSqlStatement({sql:n})}async renameEnumType(e,t){const n=`ALTER TYPE ${this.schemaName}.${e} RENAME TO ${t}`;await this.executeSqlStatement({sql:n})}async dropEnumAttributes(e,t){const quoteValue=e=>{if(e)return`'${e}'`;return"NULL"},n=t.map(e=>e.memberName),a=(0,postgres_array_1.parse)(await this.getEnumAttributes(e),e=>e).filter(e=>!n.includes(e)),s=await this.listEnumTypesUsage(e);let m="";if(t.length>0){const e=t.map(e=>`WHEN ${quoteValue(e.memberName)} THEN ${quoteValue(e.replacement)}`).join(" "),n=t.map(e=>quoteValue(e.memberName));await(0,xtrem_async_helper_1.asyncArray)(s).forEach(async t=>{m=`UPDATE ${this.schemaName}.${t.tableName} SET ${t.columnName} = CASE ${t.columnName}::TEXT ${e} ELSE  ${t.columnName} END WHERE ${t.columnName}::TEXT IN (${n.join()});`,await this.executeSqlStatement({sql:m})})}const c=`${e}__old`;if(await this.renameEnumType(e,c),m=this.createEnumTypeSql({name:e,values:a.reduce((e,t,n)=>(e[t]=n+1,e),{})}),await this.executeSqlStatement({sql:m}),await(0,xtrem_async_helper_1.asyncArray)(s).forEach(async t=>{m=`ALTER TABLE ${this.schemaName}.${t.tableName} ALTER COLUMN ${t.columnName} TYPE ${this.schemaName}.${e} USING ${t.columnName}::TEXT::${this.schemaName}.${e};`,await this.executeSqlStatement({sql:m})}),await this.doesEnumCoalesceFunctionExist(this.schemaName,e))m=EnumSqlContext.getSqlToCreateEnumCoalesceFunction(this.schemaName,e),await this.executeSqlStatement({sql:m}),m=EnumSqlContext.getSqlToDropEnumCoalesceFunction(this.schemaName,e,c),await this.executeSqlStatement({sql:m});await this.dropEnum(c)}async getEnumAttributes(e){const t=`SELECT enum_range(NULL::${this.schemaName}.${e})`;return(await this.executeSqlStatement({sql:t}))[0].enum_range}static getEnumCoalesceFunctionName(e){return`${e}_coalesce`}async doesEnumCoalesceFunctionExist(e,t){const n=`SELECT p.oid::regprocedure,n.nspname\n                        FROM pg_proc p \n                            JOIN pg_namespace n \n                            ON p.pronamespace = n.oid \n                    WHERE n.nspname ='${e}' AND p.oid::regprocedure::text LIKE '%${EnumSqlContext.getEnumCoalesceFunctionName(t)}%';`;return(await this.executeSqlStatement({sql:n})||[]).length>0}static getSqlToCreateEnumCoalesceFunction(e,t,n){return`CREATE OR REPLACE FUNCTION ${e}.${this.getEnumCoalesceFunctionName(t)}(${e}.${n||t})\n            RETURNS text\n            LANGUAGE sql\n            IMMUTABLE\n          AS $function$select coalesce($1::text,'');$function$\n       ;`}static getSqlToDropEnumCoalesceFunction(e,t,n){return`DROP FUNCTION IF EXISTS ${e}.${this.getEnumCoalesceFunctionName(t)}(${e}.${n||t});`}}exports.EnumSqlContext=EnumSqlContext;
//# sourceMappingURL=enum-sql-context.js.map