/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.DatabaseSqlContext=void 0;const loggers_1=require("../../runtime/loggers"),extensions_1=require("../statements/extensions"),functions_1=require("../statements/functions"),database_manager_1=require("./database-manager"),sql_context_1=require("./sql-context"),logger=loggers_1.loggers.sql;class DatabaseSqlContext extends sql_context_1.SqlContext{constructor(){super(5771350283228132,"sys"),this.databaseService=database_manager_1.DatabaseManager.getDatabaseService(this.config)}async dropDatabaseIfExists(){await this.databaseService.dropDatabaseIfExists()}async createDatabaseIfNotExists(){await this.databaseService.createDatabaseIfNotExists()}async renameSchema(e,t){await this.databaseService.renameSchema(e,t)}async createSchemaIfNotExists(e){await this.createDatabaseIfNotExists();const{user:t,password:s,sysUser:a,sysPassword:i}=this.config;let n=false;if(await this.withConnection(async r=>{await this.databaseService.createUsers(r,t,s,a,i);const c=await this.execute(r,"SELECT schema_name FROM information_schema.schemata WHERE schema_name = $1",[e]);if(n=c.length>0,n)return void logger.verbose(()=>`Schema ${e} already exists`);logger.info(`Creating SQL schema ${e}`),await this.execute(r,`CREATE SCHEMA ${e};`),await(0,extensions_1.createExtensions)(e=>this.execute(r,e)),await(0,functions_1.createFunctions)(e,e=>this.execute(r,e))}),!n&&this.config.user!==this.config.sysUser)await this.setUserDefaultPrivileges(e)}async dropSchemaIfExists(e){await this.withAdvisoryLock(t=>this.execute(t,`DROP SCHEMA IF EXISTS ${e} CASCADE;`,[],{logLevel:"debug"}))}async setUserDefaultPrivileges(e){const t=this.config.user;await this.withConnection(async s=>{await this.execute(s,`GRANT USAGE ON SCHEMA ${e} TO ${t};`),await this.execute(s,`ALTER DEFAULT PRIVILEGES IN SCHEMA ${e} GRANT SELECT, INSERT, UPDATE, DELETE ON TABLES TO ${t}`),await this.execute(s,`ALTER DEFAULT PRIVILEGES IN SCHEMA ${e} GRANT USAGE, SELECT ON SEQUENCES TO ${t}`)})}async setUserPrivileges(e){const t=this.config.user;await this.withConnection(async s=>{await this.execute(s,`GRANT SELECT, INSERT, UPDATE, DELETE ON ALL TABLES IN SCHEMA ${e} TO ${t};`),await this.execute(s,`GRANT USAGE, SELECT ON ALL SEQUENCES IN SCHEMA ${e} TO ${t};`)})}}exports.DatabaseSqlContext=DatabaseSqlContext;
//# sourceMappingURL=database-sql-context.js.map