import { SqlContext } from './sql-context';
export declare class DatabaseSqlContext extends SqlContext {
    private databaseService;
    /**
     * @param force force reset database user and schema if they exist
     */
    constructor();
    /**
     * Drops the database if it exists
     * Note: it won't drop the database if it is the sys database (we should never drop the sys database)
     */
    dropDatabaseIfExists(): Promise<void>;
    /**
     * Create database
     * @param force force reset database user and schema if they exist
     */
    createDatabaseIfNotExists(): Promise<void>;
    /**
     * Rename a schema
     */
    renameSchema(oldName: string, newName: string): Promise<void>;
    /**
     * Create schema
     */
    createSchemaIfNotExists(schemaName: string): Promise<void>;
    /**
     * Create schema
     * @param schemaName
     */
    dropSchemaIfExists(schemaName: string): Promise<void>;
}
//# sourceMappingURL=database-sql-context.d.ts.map