import { IndexColumn } from '@sage/xtrem-postgres';
export type DataDiagnosisSeverity = 'info' | 'warn' | 'error';
export type DataDiagnosisCategory = 'autofix';
export interface DataDiagnosis {
    severity: DataDiagnosisSeverity;
    category: DataDiagnosisCategory;
    message: string;
}
/**
 * @disabled_internal
 *
 * Note: indexDefinition is sth like
 *  CREATE INDEX delete_columns_node__tenant_id_idx ON xtrem_core_test.delete_columns_node USING btree (_tenant_id, name_1 DESC, name_2, name_3 DESC)
 *  or
 *  CREATE UNIQUE INDEX table_1_ind0 ON xtrem.table_1 USING btree (name, xtrem.col_1_enum_coalesce(col_1))
 *  or
 *  CREATE UNIQUE INDEX table_1_ind1 ON xtrem.table_1 USING btree (name, coalesce(col_ref_1, (0)::bigint)))
 */
export declare function parseIndexDefinition(indexName: string, indexDefinition: string): IndexColumn[];
//# sourceMappingURL=utils.d.ts.map