/** @ignore */ /** */
import { AnyRecord } from '@sage/xtrem-async-helper';
import { ColumnDefinition, ForeignKeyDefinition, ForeignKeyOptions, IndexDefinition, SqlCreateTableOptions, TableDefinition, TableJsonComment, TriggerDefinition } from '@sage/xtrem-postgres';
import { Dict } from '@sage/xtrem-shared';
import { Application } from '../../application';
import { Context, ContextOptions, NodeFactory, NodeIndex } from '../../runtime';
import { EnumType } from '../../types';
import { SqlInsertOptions } from '../mapper/sql-insert';
import { RecordUpdateOptions } from '../mapper/sql-update';
import { ColumnInconsistency, DropTableOptions, SqlAddColumnsOptions } from '../sql-context/types';
import { Column } from './column';
import { ForeignKey } from './foreign-key';
import { PrimaryKey } from './primary-key';
export declare enum TestStatus {
    loaded = 0,
    modified = 1
}
/**
 * The result of a call to fixForeignKeys
 */
export type FixForeignKeysResult = {
    /** The number of created FKs */
    createdFks: number;
    /** The number of renamed FKs */
    renamedFks: number;
    /** The number of re-created FKs */
    recreatedFks: number;
};
/** @disabled_internal */
export declare class Table {
    #private;
    factory: NodeFactory;
    columns: Column[];
    foreignKeys: ForeignKey[];
    columnsByPropertyName: Dict<Column>;
    columnsByColumnName: Dict<Column>;
    verified: boolean;
    isSharedByAllTenants: boolean;
    testStatus: TestStatus;
    testLayers: string[];
    testNowMock: string;
    testDir: string;
    constructor(decorators: TableDecorators);
    /** The name of the table, provided by its factory */
    get name(): string;
    /** The name of the SQL table */
    get sqlTableName(): string;
    getFullTableName(context: Context, alias?: string): string;
    /**
     * Returns the table of the baseClass (if any)
     */
    get baseTable(): Table | undefined;
    /**
     * Returns the table of the rootClass
     * The rootClass is the lowest level subNode
     * cat->mammal->animal
     * mammal will be the base table of cat
     * animal will be the root table of cat
     */
    get rootTable(): Table;
    get primaryKey(): PrimaryKey;
    get uniqueIndexes(): PrimaryKey[];
    get databaseComputedColumnNames(): readonly string[];
    getColumns(options?: {
        inherit?: boolean;
        includeSystemColumns?: boolean;
        skipLazyLoadableColumns?: boolean;
    }): Column[];
    /**
     * Returns the JSON comment that must be put on the table (in the database)
     */
    getJsonComment(): TableJsonComment;
    /**
     * Returns the tableDefinition that matches the metadata of this table.
     * WARNING: it may not return the same result as the SQL metadata if the table in the database
     * is not in sync with the definition of the table.
     * @param context
     */
    getTableDefinition(context: Context): TableDefinition;
    private getNotifyOptions;
    private getSqlExpressionTemplateForPayloadValue;
    dropTable(context: Context, options?: DropTableOptions): Promise<void>;
    createTable(context: Context, options?: SqlCreateTableOptions): Promise<void>;
    private getModifyTableSqlContext;
    /**
     * Create a bunch of triggers from their definition
     */
    createTriggers(context: Context, triggers: TriggerDefinition[]): Promise<void>;
    /**
     * Drop a bunch of triggers from their definition
     */
    dropTriggers(context: Context, triggers: TriggerDefinition[]): Promise<void>;
    /** Creates the SQL insert function */
    createSqlInsertFunction(context: Context): Promise<void>;
    /** Drops the SQL insert function if it exists */
    static dropSqlInsertFunction(context: Context, tableName: string): Promise<void>;
    ensureTableExists(context: Context, options?: SqlCreateTableOptions): Promise<void>;
    ensureAllTableColumnsExists(context: Context): Promise<void>;
    getColumnDefinition(column: Column): ColumnDefinition;
    /**
     * Maps a ForeignKey to an ForeignKeyDefinition
     */
    static getForeignKeyDefinition(foreignKey: ForeignKey): ForeignKeyDefinition;
    /**
     * Maps a NodeIndex to an IndexDefinition
     */
    getIndexDefinition(schemaName: string, index: NodeIndex, tenantIdColumn: Column): IndexDefinition;
    private static setCoalesceExpressionForNullableInUniqueIndex;
    /** @disabled_internal */
    createIndex(context: Context, index: IndexDefinition): Promise<void>;
    /** @disabled_internal */
    dropIndex(context: Context, indexName: string): Promise<void>;
    /**
     * @disabled_internal
     *
     * Adds some columns from their column definition
     */
    addColumns(context: Context, colDefs: ColumnDefinition[], options?: SqlAddColumnsOptions): Promise<void>;
    /**
     * @disabled_internal
     *
     * Alters some columns from their new column definition
     */
    alterColumns(context: Context, columns: {
        definition: ColumnDefinition;
        inconsistencies: ColumnInconsistency[];
    }[]): Promise<void>;
    /**
     * @disabled_internal
     */
    dropColumns(context: Context, columnNames: string[]): Promise<void>;
    /**
     * Returns the existing foreignKeyDefinition that matches the fk provided as a parameter.
     * This function will return either the existing fkDef with the same name or the existing fkDef with the same columns.
     *
     * @param currentTableDef The current table schema (the one that matches the current state of the db)
     */
    getMatchingForeignKeyDefinition(context: Context, foreignKey: ForeignKey, currentTableDef?: TableDefinition): Promise<ForeignKeyDefinition | undefined>;
    /** @disabled_internal */
    dropForeignKey(context: Context, foreignKeyName: string): Promise<void>;
    /**
     * Renames (in DB) a foreign key
     */
    renameForeignKey(context: Context, oldFkName: string, newFkName: string): Promise<void>;
    /**
     * Make sure all the foreign keys defined in the model exist and that they have the right name
     *
     * @param currentTableDef The current table schema (the one that matches the current state of the db)
     */
    fixForeignKeys(context: Context, currentTableDef: TableDefinition, options: ForeignKeyOptions): Promise<FixForeignKeysResult>;
    /**
     * Creates (in DB) a foreign key
     *
     * @param context
     * @param foreignKey
     * @param options
     * @param currentTableSchema The (optional) current table schema (for optimization purpose: reading the schema is very expensive)
     */
    addForeignKey(context: Context, foreignKey: ForeignKey, currentTableSchema?: TableDefinition, options?: ForeignKeyOptions): Promise<void>;
    getForeignKeyByName(name: string): ForeignKey | undefined;
    dropAllForeignKeys(context: Context): Promise<void>;
    tableExists(context: Context): Promise<boolean>;
    createEnumTypes(context: Context, enumTypes: EnumType[]): Promise<void>;
    getColumnValues(data: AnyRecord): AnyRecord;
    private getSqlColumnByPropertyName;
    getSqlColumnNameByPropertyName(propertyName: string): string;
    private getSqlColumnByColumnName;
    getSqlColumnNameByColumnName(columnName: string): string;
    insert(context: Context, initialData: AnyRecord, options?: SqlInsertOptions): Promise<AnyRecord & {
        _id?: number;
    }>;
    insertFromSqlFile(context: Context, initialData: AnyRecord, options?: SqlInsertOptions): Promise<AnyRecord & {
        _id?: number;
    }>;
    static dropUpsertSqlFunction(context: Context): Promise<void>;
    update(context: Context, data: AnyRecord, options?: RecordUpdateOptions): Promise<AnyRecord[]>;
    delete(context: Context, filter: AnyRecord): Promise<number>;
    findColumnByPropertyName(name: string): Column;
    findColumnByColumnName(name: string): Column;
    tableError(message: string): Error;
    markAsLoadedForTests(application: Application, contextOptions: ContextOptions): void;
    markAsModifiedForTests(): void;
    /**
     * Fix the sequences of the table
     */
    fixAutoIncrementSequences(tenantId: string | null): Promise<void>;
}
//# sourceMappingURL=table.d.ts.map