/** @ignore */ /** */
import { ForeignKeyDeleteBehaviour, ForeignKeyJsonComment } from '@sage/xtrem-postgres';
/** @disabled_internal */
export declare class ForeignKey {
    private readonly options;
    constructor(options: {
        name: string;
        /**
         * The name of the target table
         */
        targetTable: string;
        /**
         * The name of the target columns (columns from target table)
         */
        targetColumnNames: string[];
        /**
         * The column names (columns from the current table)
         */
        columnNames: string[];
        /**
         * The behaviour of the foreign key on 'delete' operation
         */
        onDeleteBehaviour: ForeignKeyDeleteBehaviour;
        /**
         * Is the foreignKey deferrable ?
         */
        isDeferrable: boolean;
    });
    get name(): string;
    /**
     * The name of the target table
     */
    get targetTable(): string;
    /**
     * The name of the target columns (columns from target table)
     */
    get targetColumnNames(): string[];
    /**
     * The column names (columns from the curren table)
     */
    get columnNames(): string[];
    /**
     * The behaviour of the foreign key on 'delete' operation
     */
    get onDeleteBehaviour(): ForeignKeyDeleteBehaviour;
    /**
     * Is the foreignKey deferrable ?
     */
    get isDeferrable(): boolean;
    /**
     * Returns the JSON comment that must be put on the foreignKey (in the database)
     */
    getJsonComment(): ForeignKeyJsonComment;
}
//# sourceMappingURL=foreign-key.d.ts.map