/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.Column=void 0;const xtrem_shared_1=require("@sage/xtrem-shared"),types_1=require("../../types"),types_conversion_1=require("../statements/types-conversion");class Column{constructor(e){this.property=e}get isSystem(){return this.property.isSystemProperty}get table(){return this.property.factory.table}get propertyName(){return this.property.name}get columnName(){if(!this.property.columnName)throw new Error(`${this.property.name}: missing columnName`);return this.property.columnName}get type(){if(this.property.isLocalized)return"json";return this.property.columnType||this.property.type}get shouldLazyLoad(){return this.property.shouldLazyLoad}get isNullable(){return!!this.property.isNullable}get isEncryptedString(){return this.property.isStringProperty()&&this.property.isStoredEncrypted}getColumnType(){const e=this.type;if(!e)throw this.columnError("column type missing!");if((0,xtrem_shared_1.isColumnTypeName)(e))return e;throw this.columnError(`invalid column type: ${e}`)}columnError(e){return new Error(`column ${this.table.name}.${this.propertyName}: ${e}`)}getJsonComment(){const e=this.getColumnType(),t=this.property.dataType,r={type:this.property.isReferenceProperty()?"reference":e,isSystem:this.property.isSystemProperty};if(this.isAutoIncrement)r.isAutoIncrement=true;if(this.property.isReferenceProperty())r.targetTableName=this.property.targetFactory.tableName,r.isSelfReference=this.property.isSelfReference;if(t instanceof types_1.EnumDataType){const e=t;r.enumTypeName=e.getEnumType().name}if("json"===e)if(t instanceof types_1.StringDataType)r.type="string",r.isLocalized=true,r.maxLength=this.property.maxLength;if(this.property.isDecimalProperty())r.precision=this.property.dataType.precision,r.scale=this.property.dataType.scale;if("string"===e){if(this.isEncryptedString)r.isEncrypted=true;r.maxLength=this.property.maxLength}return r}get default(){if(this.property.isReferenceProperty()&&this.property.isSelfReference&&this.property.factory.rootFactory.fullTableName)return(0,types_conversion_1.getSqlCurrvalOfIdSequence)(this.property.factory.rootFactory.fullTableName);return this.property.sqlAttributes?.default}get isAutoIncrement(){return!!this.property.isAutoIncrement}get excludeFromInsertIfNull(){return this.isAutoIncrement||!!this.property.sqlAttributes?.excludeFromInsertIfNull}get isInternalSystemProperty(){return this.isSystem&&!!this.property.factory.properties.find(e=>e.name===this.propertyName)}}exports.Column=Column;
//# sourceMappingURL=column.js.map