/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.BroadcastHandler=void 0;const nanoid_1=require("nanoid"),util_1=require("util"),runtime_1=require("../../runtime"),loggers_1=require("../../runtime/loggers"),container_heartbeat_monitor_1=require("./container-heartbeat-monitor"),pubsub_1=require("./pubsub");class BroadcastHandler{static _makeAckTopic(e){return`${e}-ack`}static async broadcast(e,t,r,o){if(!container_heartbeat_monitor_1.ContainerHeartbeatMonitor.isActive)throw new Error("Heartbeat monitor is not active for this container");await(0,util_1.promisify)(setTimeout)(2*container_heartbeat_monitor_1.ContainerHeartbeatMonitor.heartbeatMillis);const n=o?.timeout||3e4,a=BroadcastHandler._makeAckTopic(t),i=container_heartbeat_monitor_1.ContainerHeartbeatMonitor.aliveContainers;if(0===i.length)return void loggers_1.loggers.pubsub.debug(()=>"Broadcast skipped, no other alive containers");loggers_1.loggers.pubsub.debug(()=>`Broadcast payload ${JSON.stringify(r)}, timeout=${n} ms`);const s=i.reduce((e,t)=>(e[t]=true,e),{});let c;loggers_1.loggers.pubsub.verbose(()=>`Wait replies from ${i.length} containers: ${Object.keys(s)}`);const d=(0,nanoid_1.nanoid)();if(await e.asRoot.withCommittedContext(null,e=>new Promise((o,i)=>{const ackListener=e=>{if(e.$broadcastId!==d)return;if(!s[e.$containerId])throw new Error(`Unexpected acknowledge received from ${e.$containerId}`);if(e.$error)return void i(new Error(`Container ${e.$containerId} replied with error: ${e.$error}`));if(loggers_1.loggers.pubsub.info(()=>`Acknowledge received from ${e.$containerId}`),delete s[e.$containerId],0===Object.keys(s).length)o()};c=global.setTimeout(()=>{if(0===Object.keys(s).length)return;const e=container_heartbeat_monitor_1.ContainerHeartbeatMonitor.aliveContainers,t=Object.keys(s).filter(t=>e.includes(t));if(t.length){const e=`The following containers did not acknowledge in time: \n\t- ${t.join("\n\t- ")}`;i(new Error(e))}},n);const u={...r,$broadcastId:d,$fromContainerId:runtime_1.ContainerManager.containerId};pubsub_1.PubSub.subscribe(a,ackListener).then(()=>pubsub_1.PubSub.publish(e,t,u,{excludeSelf:true})).catch(e=>i(e instanceof Error?e:new Error(String(e))))}),{description:()=>`broadcast(${t})`}),c)clearTimeout(c);await pubsub_1.PubSub.unsubscribe(a)}static async acknowledge(e,t,r){const o=BroadcastHandler._makeAckTopic(t);await e.asRoot.withCommittedContext(null,async e=>{const t={tenantId:e.tenantId,$broadcastId:r.$broadcastId,$containerId:runtime_1.ContainerManager.containerId};await pubsub_1.PubSub.publish(e,o,t,{excludeSelf:true})},{description:()=>`Acknowledge topic ${t}`})}static async acknowledgeWithError(e,t,r,o){const n=BroadcastHandler._makeAckTopic(t);loggers_1.loggers.pubsub.warn(`Send error acknowledge to ${t}, error: ${o}`),await e.asRoot.withCommittedContext(null,async e=>{const t={tenantId:e.tenantId,$broadcastId:r.$broadcastId,$containerId:runtime_1.ContainerManager.containerId,$error:o};await pubsub_1.PubSub.publish(e,n,t,{excludeSelf:true})},{description:()=>`Acknowledge with error on topic ${t}`})}}exports.BroadcastHandler=BroadcastHandler;
//# sourceMappingURL=broadcast-handler.js.map