/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.SqlValueConverter=void 0;const xtrem_date_time_1=require("@sage/xtrem-date-time"),xtrem_decimal_1=require("@sage/xtrem-decimal"),xtrem_postgres_1=require("@sage/xtrem-postgres"),xtrem_shared_1=require("@sage/xtrem-shared"),assert=require("assert"),_=require("lodash"),postgres_array_1=require("postgres-array"),types_1=require("../../types");function fromSqlTypeError(e,r){const t=e.property;return t.systemError(`invalid ${t.type} value: '${r}' of type ${typeof r}, op=${e.aggregationOperator}`)}function toSqlTypeError(e,r){return e.property.inputError(`invalid ${e.type} value: '${r}' of type ${typeof r}`)}class SqlValueConverter{static async fromSql(e,r,t){const a=r.property;if(null==t){if(void 0===t)throw a.systemError(`invalid SQL value: ${t}`);return t}switch(r.type){case"string":if(r.property?.isLocalized&&"object"==typeof t&&e.processLocalizedTextAsJson)return JSON.stringify(t);if("string"!=typeof t)throw fromSqlTypeError(r,t);if(a.isStringProperty()&&a.isStoredEncrypted)return e.vault.recordValue(t);return t;case"boolean":if("boolean"!=typeof t)throw fromSqlTypeError(r,t);return t;case"enum":if("string"!=typeof t)throw fromSqlTypeError(r,t);return t;case"short":case"integer":if(!_.isInteger(t)){if(r.property&&["_createUser","_updateUser"].includes(r.property.name))return null;throw fromSqlTypeError(r,t)}return t;case"float":case"double":if("number"!=typeof t)throw fromSqlTypeError(r,t);return t;case"decimal":if("string"!=typeof t&&"number"!=typeof t)throw fromSqlTypeError(r,t);return xtrem_decimal_1.Decimal.make(t);case"date":if("string"!=typeof t)throw fromSqlTypeError(r,t);return xtrem_date_time_1.DateValue.parse(t);case"time":if("string"!=typeof t)throw fromSqlTypeError(r,t);return xtrem_date_time_1.Time.parse(t);case"datetime":if("string"!=typeof t&&!(t instanceof Date))throw fromSqlTypeError(r,t);if("string"==typeof t)return xtrem_date_time_1.Datetime.parse(t);return xtrem_date_time_1.Datetime.fromJsDate(t);case"reference":return assert(a.isReferenceProperty()),e.convertReference(a.targetFactory,t);case"integerRange":if("string"!=typeof t)throw fromSqlTypeError(r,t);return xtrem_date_time_1.IntegerRange.parse(t);case"enumArray":{if("string"!=typeof t)throw fromSqlTypeError(r,t);const e=(0,postgres_array_1.parse)(t,e=>e);if(!Array.isArray(e))throw fromSqlTypeError(r,t);return Object.freeze(e)}case"integerArray":case"referenceArray":if(!Array.isArray(t))throw fromSqlTypeError(r,t);return Object.freeze(t.map(e=>Number(e)));case"stringArray":if(!Array.isArray(t))throw fromSqlTypeError(r,t);return Object.freeze(t);case"decimalRange":if("string"!=typeof t)throw fromSqlTypeError(r,t);return xtrem_date_time_1.DecimalRange.parse(t);case"dateRange":if("string"!=typeof t)throw fromSqlTypeError(r,t);return xtrem_date_time_1.DateRange.parse(t);case"datetimeRange":if("string"!=typeof t)throw fromSqlTypeError(r,t);return xtrem_date_time_1.DatetimeRange.parse(t);case"uuid":if("string"!=typeof t)throw fromSqlTypeError(r,t);return types_1.Uuid.fromString(t);case"binaryStream":{const e=await xtrem_postgres_1.ConnectionPool.readBlob(t);if(e&&e.length>0)return types_1.BinaryStream.fromBuffer(e);return a.getTypeDefaultValue()}case"textStream":{const e=await xtrem_postgres_1.ConnectionPool.readClob(t);if(e&&e.length>0)return types_1.TextStream.fromString(e);return a.getTypeDefaultValue()}default:return t}}static _checkValue(e,r,t){if(null==t)return;if(!r(e))throw toSqlTypeError(t,e)}static _checkValueType(e,r,t){this._checkValue(e,e=>typeof e===r,t)}static _checkValueIsInstanceOf(e,r,t){this._checkValue(e,e=>e instanceof r,t)}static toSql(e,r,t){const a=SqlValueConverter.getSqlTransformation(e,r);return SqlValueConverter.applyTransformationToValue(e,t,a,r)}static parseIntegerColumnValue(e,r,t){if(r.property.isReferenceProperty())return r.property.targetFactory.resolveReferenceId(e,t);if("_id"===r.property.name)return r.property.factory.resolveReferenceId(e,t);const a=parseInt(String(t),10);if(Number.isNaN(a))throw r.property.inputError(`invalid integer value: '${t}' of type ${typeof t}`);return a}static applyTransformationToValue(e,r,t,a){const n=(()=>{if(null!=r)return r;if(a){if("_tenant_id"===a.columnName)return e.tenantId;return a.property.getTypeDefaultValue()}return null})();if(null==n)return null;switch(t){case null:return null;case"encryptedString":return SqlValueConverter._checkValueType(n,"string",a),e.vault.getValueFromVault(n);case"string":case"enum":return SqlValueConverter._checkValueType(n,"string",a),n;case"boolean":return SqlValueConverter._checkValueType(n,"boolean",a),n;case"integer":if("number"!=typeof n&&a)return this.parseIntegerColumnValue(e,a,n);return SqlValueConverter._checkValueType(n,"number",a),n;case"short":case"float":case"double":return SqlValueConverter._checkValueType(n,"number",a),n;case"decimal":if("string"==typeof n)return n;if("number"!=typeof n&&!xtrem_decimal_1.Decimal.isDecimal(n)){if(a)throw toSqlTypeError(a,n);throw new Error(`Invalid decimal value ${n}, type = ${typeof n}`)}return n.toString();case"date":if("string"==typeof n)return n;return SqlValueConverter._checkValueIsInstanceOf(n,xtrem_date_time_1.DateValue,a),n.toString();case"time":return SqlValueConverter._checkValueIsInstanceOf(n,xtrem_date_time_1.Time,a),n.toString();case"datetime":return SqlValueConverter._checkValueIsInstanceOf(n,xtrem_date_time_1.Datetime,a),n.toString();case"enumArray":case"integerArray":case"stringArray":return SqlValueConverter._checkValue(n,Array.isArray,a),n;case"referenceArray":{SqlValueConverter._checkValue(n,Array.isArray,a);const r=n;return Promise.all(r.map(r=>(a?.property).targetFactory.resolveReferenceId(e,r?._id||r)))}case"integerRange":if("string"==typeof n)return n;return SqlValueConverter._checkValueIsInstanceOf(n,xtrem_date_time_1.IntegerRange,a),n.toString();case"decimalRange":if("string"==typeof n)return n;return SqlValueConverter._checkValueIsInstanceOf(n,xtrem_date_time_1.DecimalRange,a),n.toString();case"dateRange":if("string"==typeof n)return n;return SqlValueConverter._checkValueIsInstanceOf(n,xtrem_date_time_1.DateRange,a),n.toString();case"datetimeRange":if("string"==typeof n)return n;return SqlValueConverter._checkValueIsInstanceOf(n,xtrem_date_time_1.DatetimeRange,a),n.toString();case"uuid":return SqlValueConverter._checkValueIsInstanceOf(n,types_1.Uuid,a),n.toString();case"binaryStream":{SqlValueConverter._checkValueIsInstanceOf(n,types_1.BinaryStream,a);const e=n;return e.value?e.value:""}case"textStream":{SqlValueConverter._checkValueIsInstanceOf(n,types_1.TextStream,a);const e=n;return e.value?e.value:""}case"json":return Array.isArray(n)?JSON.stringify(n):n;default:throw new xtrem_shared_1.LogicError(`invalid SQL transformation : ${t}`)}}static getSqlTransformation(e,r){switch(r.type){case"string":if(!e.inCsvLoading&&r.property.isStringProperty()&&r.property.isStoredEncrypted)return"encryptedString";return"string";case"boolean":case"enum":case"short":case"integer":case"float":case"double":case"decimal":case"date":case"time":case"datetime":case"integerRange":case"enumArray":case"integerArray":case"referenceArray":case"stringArray":case"decimalRange":case"dateRange":case"datetimeRange":case"uuid":case"binaryStream":case"textStream":case"json":return r.type;default:throw new xtrem_shared_1.LogicError(`invalid column type: ${r.type}`)}}}exports.SqlValueConverter=SqlValueConverter;
//# sourceMappingURL=sql-value-converter.js.map