import { AnyValue, AsyncResponse } from '@sage/xtrem-async-helper';
import { TypeName } from '../../decorators/decorator-utils';
import { Context } from '../../runtime';
import { Column } from '../schema/column';
import { OutputColumn } from './sql-converter';
export type TransformationForSqlValue = TypeName | 'encryptedString';
export declare class SqlValueConverter {
    static fromSql(context: Context, outputColumn: OutputColumn, val: AnyValue): Promise<AnyValue>;
    /**
     * Performs a check on a value
     */
    private static _checkValue;
    /**
     * Ensures a value has the right type
     * @param val
     * @param expectedType
     * @param column
     */
    private static _checkValueType;
    /**
     * Ensures a value has the right type
     * @param val
     * @param expectedType
     * @param column
     */
    private static _checkValueIsInstanceOf;
    /**
     * Convert a value to its SQL representation
     */
    static toSql(context: Context, column: Column, value: AnyValue): AsyncResponse<AnyValue>;
    static parseIntegerColumnValue(context: Context, column: Column, val: AnyValue): AsyncResponse<number | null>;
    /**
     * Applies a TransformationForSqlValue to a value
     * @param context
     * @param value the value to transform
     * @param transformation the transformation to apply
     * @param column the (optional) column that will be used to check the consistency of the value
     * @returns
     */
    static applyTransformationToValue(context: Context, value: AnyValue, transformation: TransformationForSqlValue, column?: Column): AsyncResponse<AnyValue>;
    /**
     * Returns the TransformationForSqlValue to apply to a value
     */
    static getSqlTransformation(context: Context, column: Column): TransformationForSqlValue;
}
//# sourceMappingURL=sql-value-converter.d.ts.map