/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.idColumnName=exports.tenantIdColumnName=exports.SqlUtil=void 0;const lazy_loaded_marker_1=require("../../node-state/lazy-loaded-marker"),sql_context_1=require("../sql-context"),sql_value_converter_1=require("./sql-value-converter");class SqlUtil{static pushColumnArg(e,t){return e.addSqlParameter({valuePath:`values.${t.propertyName}`,type:t.type,column:t,factoryName:t.property.targetFactory?.name})}static pushValuesForUpdateOrInsert(e,t,r,a,l,o){if(a===lazy_loaded_marker_1.lazyLoadedMarker)return;if(r.property.isRequired&&null==a)throw new Error(`Cannot insert null value in column ${e.name}.${r.columnName}`);if(void 0===sql_value_converter_1.SqlValueConverter.toSql(t.context,r,a))throw new Error(`Could not insert value in column ${e.name}.${r.columnName}`);l.push(sql_context_1.SqlContext.escape(r.columnName)),o.push(this.pushColumnArg(t,r))}static fixLocalizedValue(e,t,r,a){if("string"!=typeof t)return t;let l={[e.currentLocale]:t};if(e.processLocalizedTextAsJson)if(t.startsWith("{"))try{if(l=JSON.parse(t),"insert"===a){if(!l.base)l.base=l[Object.keys(l)[0]];l=Object.keys(l).reduce((e,t)=>{const r=t.split("-")[0];if(!e[r])e[r]=e[t];return e},l)}}catch{throw new Error(`Localized property '${r}' has an incorrect format: '${t}'. Expecting '{"key": "value"}'`)}else l={base:t};else{if("insert"===a)l.base=t,l[e.defaultLanguage]=t,l[e.currentLocaleLanguage]=t;if(e.isMasterLocale())l[e.currentLocaleLanguage]=t}return l}}exports.SqlUtil=SqlUtil,exports.tenantIdColumnName="_tenant_id",exports.idColumnName="_id";
//# sourceMappingURL=sql-util.js.map