import { AnyValue } from '@sage/xtrem-shared';
import { Table } from '..';
import { Context } from '../../runtime';
import { Column } from '../schema/column';
import { SqlConverter } from './sql-converter';
/** Static utility methods shared by SqlInsert and SqlUpdate */
export declare abstract class SqlUtil {
    static pushColumnArg(sqlConverter: SqlConverter, column: Column): string;
    /**
     * function to build update/insert sql statements
     *
     * @param context the context
     * @param column the column to process
     * @param val the value (TypeScript value, not a sql value)
     * @param columnNames the name of the columns in the statement
     * @param parameterNames the list of sqlParameters ($1, $2, ...)
     * @param parameterValues the values of the sqlParameters (values of $1, $2, ...)
     */
    static pushValuesForUpdateOrInsert(table: Table, sqlConverter: SqlConverter, column: Column, val: AnyValue, columnNames: string[], parameterNames: string[]): void;
    /**
     * Set the localized properties to json format { locale: 'text value', languageCode: 'text value' }
     * The language code will be used as fallback for other locales in the same language
     * For Inserts we also set { defaultLanguage: 'text value' } as fallback value for any other language/locale
     *
     * @param context
     * @param data
     * @param property
     * @param mode
     */
    static fixLocalizedValue(context: Context, value: AnyValue, propertyName: string, mode: 'insert' | 'update'): AnyValue;
}
export declare const tenantIdColumnName = "_tenant_id";
export declare const idColumnName = "_id";
//# sourceMappingURL=sql-util.d.ts.map