/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.SqlUpdate=void 0;const xtrem_metrics_1=require("@sage/xtrem-metrics"),lodash=require("lodash"),utils_1=require("../../runtime/utils"),sql_context_1=require("../sql-context/sql-context"),sql_converter_1=require("./sql-converter"),sql_util_1=require("./sql-util");class SqlUpdate{constructor(e){this.table=e}get factory(){return this.table.factory}getUpdateParameters(e,t,r){const{context:s}=e,a=r.onlyColumns,o=this.table.columns.filter(e=>{if(a?.[e.columnName])return true;return!(a||e.isSystem&&"_custom_data"!==e.columnName&&"_sync_info"!==e.columnName)}),l=[],i=[];return o.filter(e=>"_id"!==e.propertyName&&"_constructor"!==e.propertyName).filter(e=>!t._vendor||t._vendor&&(r.updateFromCsv||e.property.isOwnedByCustomer)).forEach(r=>{if(r.property.isLocalized){const e=r.property.name;t[e]=sql_util_1.SqlUtil.fixLocalizedValue(s,t[e],e,"update")}sql_util_1.SqlUtil.pushValuesForUpdateOrInsert(this.table,e,r,t[r.propertyName],l,i)}),{columnNames:l,valsOrParameters:i}}getForWhereParameters(e,t){const r=[],s=[];return sql_util_1.SqlUtil.pushValuesForUpdateOrInsert(this.table,e,this.table.columnsByPropertyName._id,t._id,r,s),{columnsForWhere:r,valsForWhere:s}}async update(e,t,r={}){e.sqlSpy.incrementCounter(this.factory,"UPDATE");try{const s={...t};let a=[];const o=new sql_converter_1.SqlConverter(e,this.factory);if(this.table.baseTable)a=await new SqlUpdate(this.table.baseTable).update(e,s,r);const{columnNames:l,valsOrParameters:i}=this.getUpdateParameters(o,s,r);if(!l.length){if(!this.table.factory.isAbstract||this.table.factory.baseFactory)return a;l.push("_id"),i.push(String(s._id))}const{columnsForWhere:n,valsForWhere:u}=r.ignoreAllSystemFilters?{columnsForWhere:[],valsForWhere:[]}:this.getForWhereParameters(o,s);let c=[];if(!e.processLocalizedTextAsJson)c=this.table.columns.filter(e=>e.property.isLocalized&&l.includes(sql_context_1.SqlContext.escape(e.columnName))).map(e=>sql_context_1.SqlContext.escape(e.columnName));const m=["_id",...this.table.databaseComputedColumnNames],d=l.map((e,t)=>{if(c.includes(e))return`${e}=${e} || ${i[t]}`;if("_custom_data"===e)return m.push("_custom_data"),`${e}=COALESCE(${e} || ${i[t]}, ${i[t]})`;return`${e}=${i[t]}`}).join(","),p=n.map((e,t)=>`${e}=${u[t]}`);if(r.filter)p.push(o.convertWhere(r.filter));if(e.processLocalizedTextAsJson)m.push(...this.table.columns.filter(e=>e.property.isLocalized&&l.includes(sql_context_1.SqlContext.escape(e.columnName))).map(e=>sql_context_1.SqlContext.escape(e.columnName)));const _=`UPDATE ${this.table.getFullTableName(e)}\nSET ${d}\nWHERE ${(0,utils_1.tenantCondition)(o,this.table,"",p)}\nRETURNING ${lodash.uniq(m).join(",")}`,h=await sql_converter_1.SqlConverter.getParameterValues(e,o.sqlParameters,{values:s,where:r.filter}),q=await xtrem_metrics_1.CustomMetrics.sql.withMetrics({nodeName:this.factory.name,statementKind:"update"},()=>e.executeSql(_,h));if(!Array.isArray(q)){if(0===q.updateCount)return[];throw this.factory.logicError(`Unexpected result from update: updateCount=${q.updateCount}`)}if(q.length>0)sql_context_1.SqlContext.logger.verbose(()=>`Returning values: ${JSON.stringify(q)}`);if(e.testMode)this.table.markAsModifiedForTests();if(q&&a.length)return q.map(e=>({...e,...a.find(t=>t._id===e._id)||{}}));return q||[]}catch(t){if(e.testMode)this.table.markAsModifiedForTests();throw t}}}exports.SqlUpdate=SqlUpdate;
//# sourceMappingURL=sql-update.js.map