import { CachedInsert } from './sql-insert';
import { CachedQuery } from './sql-query';
/** Union of all the statement types that may be cached */
export type CachedStatement = CachedQuery | CachedInsert;
/** The kind of statement that we are caching */
export type SqlStatementKind = 'select' | 'insert' | 'upsert';
/** The data that we use to compute the key */
export interface SqlStatementCacheKeyData {
    /** The kind of statement */
    kind: SqlStatementKind;
    /** The schema name */
    schemaName: string;
    /** The name of the node factory */
    factoryName: string;
    /** Options that are specific to the statement kind */
    options: object;
}
/**
 * Options passed to statementCache.fetch.
 */
export interface SqlStatementCacheFetchOptions<T> {
    /** Returns the key */
    getKeyData: () => SqlStatementCacheKeyData;
    /** Builds the statement. Only called if key is not found in the cache */
    buildStatement: () => T;
}
//# sourceMappingURL=sql-statement-cache.d.ts.map