/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.SqlResolver=void 0;const xtrem_shared_1=require("@sage/xtrem-shared"),lodash_1=require("lodash"),loggers_1=require("../../runtime/loggers"),system_properties_1=require("../../runtime/system-properties"),naming_1=require("../statements/naming"),logger=loggers_1.loggers.sql;class SqlResolver{static checkDateOrDatetimeType(e,r){if(!e)throw new Error(`Type not defined for '${r}'`);if("date"!==e&&"datetime"!==e&&"dateRange"!==e&&"datetimeRange"!==e)throw new Error(`Only date/datetime/dateRange properties can be grouped by '${r}'`)}static{this.dateAggregateFormats={day:"YYYY-MM-DD",month:"YYYY-MM-01",year:"YYYY-01-01"}}static castIfBoolean(e,r){return"boolean"===r?`(CAST(${e} as INTEGER))`:e}static aggregateSql(e,r,t){switch(t){case"min":case"max":if("boolean"===r.type)return`${t}(CAST(${r.sql} as INTEGER))::BOOLEAN`;return`${t.toUpperCase()}(${r.sql})`;case"sum":case"avg":{const e=`${t.toUpperCase()}(${r.sql})`;if("short"===r.type||"integer"===r.type)return`${e}::FLOAT8`;return e}case"value":return r.sql;case"year":case"month":case"day":return SqlResolver.checkDateOrDatetimeType(r.type,t),`TO_CHAR(${r.sql}, ${e.resolveLiteral(SqlResolver.dateAggregateFormats[t])})::DATE`;case"distinctCount":return`COUNT(DISTINCT ${SqlResolver.castIfBoolean(r.sql,r.type)})`;case"hasNull":return`BOOL_OR(${SqlResolver.castIfBoolean(r.sql,r.type)} IS NULL)`;default:throw new xtrem_shared_1.LogicError(`invalid aggregate operator: ${t}`)}}static castFromJson(e,r){switch(r){case"short":case"integer":case"reference":return`(${e}->>0)::INT8`;case"float":case"double":return`(${e}->>0)::FLOAT8`;case"decimal":return`(${e}->>0)::NUMERIC`;case"string":case"enum":return`(${e}->>0)::TEXT`;case"date":return`(${e}->>0)::DATE`;default:return e}}static getNumericAggregateValueType(e,r){switch(e){case"short":case"integer":return"sum"===r?"integer":"double";case"float":case"double":return"double";case"decimal":return"decimal";default:throw new xtrem_shared_1.LogicError(`invalid type for ${r} operator: ${e}`)}}static getAggregateValueType(e,r){switch(r){case"min":case"max":case"year":case"month":case"day":case"value":return e;case"sum":case"avg":return SqlResolver.getNumericAggregateValueType(e,r);case"distinctCount":return"integer";case"hasNull":return"boolean";default:throw new xtrem_shared_1.LogicError(`invalid aggregate operator: ${r}`)}}static resolveAggregate(e,r,t){if(!t)throw new xtrem_shared_1.LogicError(`${r.path}: missing aggregate name`);const s=r.type??r.property?.type;if(!s)throw new xtrem_shared_1.LogicError(`${r.path}: missing type`);return{...r,aggregationOperator:t,type:SqlResolver.getAggregateValueType(s,t),sql:SqlResolver.aggregateSql(e,r,t),columnAlias:SqlResolver.makeColumnAlias(`${r.columnAlias}_${t}`)}}static makeColumnAlias(e){return(0,naming_1.makeName63)(e.replaceAll("__","._").split("._").map(e=>(0,lodash_1.snakeCase)(e)).join("__"))}static resolveCustomData(e,r,t){const s=e.context.customFields[r.factory.fullName].find(e=>e.name===t),a=s?.dataType;if(!s)throw r.factory.logicError(`custom field ${t} not found`);const o=this.castFromJson(`${r.sql}->${e.resolveLiteral(t)}`,a);return{...r,type:a,sql:o,columnAlias:this.makeColumnAlias(o)}}static resolveJson(e,r,t){if("_customData"===r.property?.name&&e.context.customFields[r.factory.fullName])return this.resolveCustomData(e,r,t);const s=`${r.sql}->${e.resolveLiteral(t)}`;return{...r,type:"json",sql:s,columnAlias:this.makeColumnAlias(s)}}static resolveDate(e,r,t){const s=e.convertDatePropertyResult(r,t);return{...s,columnAlias:this.makeColumnAlias(s.sql)}}static resolveRange(e,r,t,s){let a;switch(t){case"start":a=`lower(${r.sql})`;break;case"end":a=`upper(${r.sql})`;break;case"includedEnd":if("date"===s){a=e.cast({...r,type:"string",sql:`CASE WHEN upper_inc(${r.sql}) THEN upper(${r.sql}) ELSE (upper(${r.sql}) - INTERVAL '1 day') END`},s).sql;break}else if("integer"===s){a=`CASE WHEN upper_inc(${r.sql}) THEN upper(${r.sql}) ELSE (upper(${r.sql}) - 1) END`;break}else throw new xtrem_shared_1.LogicError(`${r.path}.${t}: invalid range property for ${s} type`);default:throw new xtrem_shared_1.LogicError(`${r.path}.${t}: invalid range property`)}return{...r,property:void 0,type:s.replace(/Range$/,""),sql:a,columnAlias:this.makeColumnAlias(a)}}static resolveArray(e,r){return{...e,type:r}}static resolveTextStream(e){return e}static resolve(e,r,t,s,a){if("jsonReference"===t.type)return SqlResolver.resolveJson(e,t,s);if("json"===t.property?.type)return SqlResolver.resolveJson(e,t,s);if("date"===t.property?.type)return SqlResolver.resolveDate(e,t,s);if("dateRange"===t.property?.type)return SqlResolver.resolveRange(e,t,s,"date");if("datetimeRange"===t.property?.type)return SqlResolver.resolveRange(e,t,s,"datetime");if("integerRange"===t.property?.type)return SqlResolver.resolveRange(e,t,s,"integer");if("decimalRange"===t.property?.type)return SqlResolver.resolveRange(e,t,s,"decimal");if("integerArray"===t.property?.type)return SqlResolver.resolveArray(t,"integer");if("enumArray"===t.property?.type)return SqlResolver.resolveArray(t,"integer");if("stringArray"===t.property?.type)return SqlResolver.resolveArray(t,"string");if("textStream"===t.property?.type)return SqlResolver.resolveTextStream(t);const o=t.factory;if(!o)throw new Error("internal error: no factory");let l;if("_constructor"===s)l=system_properties_1.SystemProperties.constructorProperty(a),l.isInherited=!!o.baseFactory;else if("_updateTick"===s)l=system_properties_1.SystemProperties.updateTickProperty(o);if(!l)l=o.findProperty(s);if(l.delegatesTo)return e.convertDelegatesTo(t,l);const i=t.path?`${t.path}.${s}`:s;if(r.collectedDependencyPaths)if(!r.collectedDependencyPaths.includes(i))r.collectedDependencyPaths.push(i);let n="",c="";if(!l.isStored){if(l.getValue){const r=l.getValue;try{if(n=e.withThisResultScope(t,()=>e.convertFunction(r)).sql,l.isBooleanProperty()||l.isIntegerProperty()||l.isReferenceProperty()||l.isDecimalProperty())n=e.cast({sql:n,type:"string"},"reference"===l.type?"integer":l.type).sql;c=SqlResolver.makeColumnAlias(i)}catch(e){throw logger.error(e.message),l.systemError(`cannot convert 'getValue' function to SQL: ${e.message}`)}}else if(l.computeValue)throw l.systemError("property cannot by converted to SQL because it is defined by a 'computeValue' rule")}else{const s=`${t.alias}.${l.columnName}`;if(n=s,l?.isLocalized)if(r.processLocalizedTextAsJson)n=`${s}#>>${e.resolveLiteral("{}")}`;else{const{collation:t}=r,a=t?` COLLATE "${t}"`:"";n=`coalesce(${[...r.locales,"base"].map(r=>`${s}->>${e.resolveLiteral(r)}`).join(", ")})${a}`}c=SqlResolver.makeColumnAlias(s)}const p=l.isNullable||"reference"===t.property?.type&&t.property?.isNullable,u={alias:t.alias,path:i,type:l.type,isNullable:p,isInherited:l.isInherited&&l.isStored,property:l,factory:l.isForeignNodeProperty()?l.targetFactory:o,sql:n,columnAlias:c};if(l.isForeignNodeProperty()){if(u.factory=l.targetFactory,l.isCollectionProperty()||l.isVital)u.reverseReferenceName=l.reverseReference;if(l.isReferenceProperty()&&l.isVital)u.parent=t,u.path=`${t.path}.${l.name}`,e.makeAliasAndJoin(u),u.sql=`${u.alias}._id`}return u}}exports.SqlResolver=SqlResolver;
//# sourceMappingURL=sql-resolver.js.map