import { ConversionResultType } from '@sage/xtrem-ts-to-sql';
import { Context, NodeFactory } from '../../runtime';
import { ConversionResult, OutputColumn, SqlConverter } from './sql-converter';
export declare class SqlResolver {
    private static checkDateOrDatetimeType;
    private static dateAggregateFormats;
    private static castIfBoolean;
    private static aggregateSql;
    static castFromJson(sql: string, type: ConversionResultType): string;
    private static getNumericAggregateValueType;
    private static getAggregateValueType;
    static resolveAggregate(sqlConverter: SqlConverter, result: OutputColumn, name: string | undefined): OutputColumn;
    static makeColumnAlias(sql: string): string;
    static resolveCustomData(sqlConverter: SqlConverter, result: ConversionResult, name: string): ConversionResult;
    static resolveJson(sqlConverter: SqlConverter, result: ConversionResult, name: string): ConversionResult;
    static resolveDate(sqlConverter: SqlConverter, result: ConversionResult, name: string): ConversionResult;
    static resolveRange(sqlConverter: SqlConverter, result: ConversionResult, name: string, type: ConversionResultType): ConversionResult;
    static resolveArray(result: ConversionResult, type: ConversionResultType): ConversionResult;
    static resolveTextStream(result: ConversionResult): ConversionResult;
    static resolve(sqlConverter: SqlConverter, context: Context, parent: ConversionResult, name: string, rootFactory: NodeFactory): ConversionResult;
}
//# sourceMappingURL=sql-resolver.d.ts.map