/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.SqlQuery=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_shared_1=require("@sage/xtrem-shared"),lodash=require("lodash"),metrics_1=require("../../metrics"),node_state_1=require("../../node-state"),runtime_1=require("../../runtime"),loggers_1=require("../../runtime/loggers"),ts_api_1=require("../../ts-api"),types_1=require("../../types"),schema_1=require("../schema"),sql_converter_1=require("./sql-converter"),sql_resolver_1=require("./sql-resolver"),sql_value_converter_1=require("./sql-value-converter");class SqlQueryBuilder{constructor(e,t,r){this.factory=e,this.context=t,this.options=r,this.sqlConverter=new sql_converter_1.SqlConverter(t,this.factory)}get table(){return this.factory.table}getGroupsOrderBy(e){return this.sqlConverter.convertAggregateGroups(this.sqlConverter,e).map((t,r)=>({...t,path:e[r].path,direction:1,property:t.property,group:e[r]}))}static getColumn(e){if(e.getValue&&!e.isStored)return new schema_1.Column(e);const t=e.column;if(!t)throw new Error(`No column set for the property ${e.name}.`);return t}cursorWhere(e,t){if(!this.options[t])return"";if(!e)throw new Error(`${this.table.name}: missing 'orderBy' option`);const r=e.map((e,r)=>{const o=SqlQueryBuilder.getColumn(e.property);return this.sqlConverter.addSqlParameter({valuePath:`${t}.${r}.value`,type:o.type,column:o})}),o=e.map((o,s)=>{const a=[];for(let t=0;t<s;t+=1){const o=e[t],s=SqlQueryBuilder.getColumn(o.property);let n=`(${o.sql} = ${r[t]})`;if(s.isNullable)n=`(${n} OR (${o.sql} IS NULL AND ${r[t]} IS NULL))`;a.push(n)}const n="before"===t?o.direction>0?"<":">":o.direction>0?">":"<";{const e=SqlQueryBuilder.getColumn(o.property);let t=`${o.sql} ${n} ${r[s]}`;if(e.isNullable)if("<"===n)t=`(${t} OR (${o.sql} IS NULL AND ${r[s]} IS NOT NULL))`;else if(">"===n)t=`(${t} OR (${o.sql} IS NOT NULL AND ${r[s]} IS NULL))`;a.push(t)}return sql_converter_1.SqlConverter.and(a)});return sql_converter_1.SqlConverter.or(o)}orderBySql(e,t,r,o){if(!e)return"";if(0===e.length)return"";return`ORDER BY ${e.map(e=>{const s=t?1===e.direction?-1:1:e.direction,a=SqlQueryBuilder.getAggregationOperator(e,r,o),n=r&&!e.group?`${e.columnAlias}${a}`:e.columnAlias;return`${"string"===e.property.type&&e.property.isLocalized&&!!this.context.collation?e.sql:n} ${-1===s?"DESC NULLS LAST":"ASC NULLS FIRST"}`}).join(", ")}`}static getAggregationOperator(e,t,r){const o=[...r||[],...t||[]].find(t=>t.columnAlias?.substring(0,t.columnAlias.lastIndexOf(`_${sql_resolver_1.SqlResolver.makeColumnAlias(t.aggregationOperator||"")}`))===`${e.columnAlias}`);return o?.aggregationOperator?`_${sql_resolver_1.SqlResolver.makeColumnAlias(o.aggregationOperator)}`:""}whereClause(e){const t=this.context.processLocalizedTextAsJson;try{this.context.processLocalizedTextAsJson=false;const t=[...this.sqlConverter.convertFilters(this.options.filters),this.cursorWhere(e,"after"),this.cursorWhere(e,"before")];return(0,runtime_1.tenantCondition)(this.sqlConverter,this.table,"t0",t)}finally{this.context.processLocalizedTextAsJson=t}}getGroupByClauses(e,t,r){if(e?.groups?.length){return{groupByClause:`GROUP BY ${e?.groups.map(e=>e.sql).join(", ")}`,groupOrderByClause:` ORDER BY ${e?.groups.map(e=>`${e.columnAlias} ${r?"DESC NULLS LAST":"ASC NULLS FIRST"}`).join(", ")}`}}if(e?.values?.length)return{};return{groupOrderByClause:this.orderBySql(t,r)}}getOutputPaths(e,t,r,o){const s=true===e?{_id:true}:e;return Object.entries(s).forEach(([e,s])=>{const a=[...r,e];if("function"==typeof s)return void o.push({path:a,compute:s});const n=t?.findProperty(e);if(n?.computeValue)throw n.logicError("computed properties are not allowed in selector");const i=n?.isForeignNodeProperty()?n.targetFactory:void 0;if(n?.isCollectionProperty()){const e=true===s?[]:this.getOutputPaths(s,i,[],[]);o.push({path:a,subPaths:e})}else if(true===s)o.push({path:a});else if(s&&"object"==typeof s){if(!s._id)o.push({path:a});this.getOutputPaths(s,i,a,o)}}),o}getTableColumnPaths(){return this.table.getColumns({inherit:true,includeSystemColumns:true,skipLazyLoadableColumns:!this.context.noLazyLoading}).filter(e=>{if("_tenant_id"===e.columnName)return false;return true}).map(e=>({path:[e.property.name]}))}getOutputColumns(){const e=this.options.selector?this.getOutputPaths(this.options.selector,this.factory,[],[]):this.getTableColumnPaths();return this.sqlConverter.convertOutputPaths(e)}static isAggregateQuery(e){return!!e?.groups?.length||!!e?.values?.length}static isSingleResult(e){return!!(e&&e.groups&&0===e.groups.length)}buildQuery(){const e=this.options,t=this.sqlConverter.convertAggregate(this.sqlConverter,e.count&&this.options.aggregate?.values?{groups:this.options.aggregate.groups,values:[]}:this.options.aggregate),r=this.options.aggregate&&!this.options.orderBy?this.getGroupsOrderBy(this.options.aggregate.groups):this.sqlConverter.convertOrderBy(this.options.orderBy??this.factory.defaultOrderBy),o=this.options.count?[]:r,s=!!e.last&&!e.count;let a;if(e.count)a=[];else if(e.onlyProperties)a=this.sqlConverter.convertOutputPaths(e.onlyProperties.map(e=>({path:[e.name]}))),this.checkAbstractReferences(a);else if(SqlQueryBuilder.isAggregateQuery(t)){const{groups:e,values:r}=t;a=[...r||[],...e||[]]}else a=this.getOutputColumns(),this.checkAbstractReferences(a);const{groupByClause:n,groupOrderByClause:i}=this.getGroupByClauses(t,o,s),l=[];if(o.forEach(e=>{if(!a.find(r=>r.columnAlias===e.columnAlias||SqlQueryBuilder.isAggregateQuery(t)&&r.columnAlias===`${e.columnAlias}_${sql_resolver_1.SqlResolver.makeColumnAlias(r.aggregationOperator||"")}`))l.push(e.path.join(".")),a.push({alias:"",...e,path:e.path.join("."),factory:this.factory,property:e.property,type:e.property.type})}),SqlQueryBuilder.isAggregateQuery(t)&&l.length>0)throw new Error(`${l.join(",")} must appear in the GROUP BY clause or be used in an aggregate function`);const u=`WHERE ${this.whereClause(o)}`,c=a.map(e=>`${e.sql} AS ${e.columnAlias}`).join(", "),p=this.sqlConverter.getTableAliases(),h=[e.count?"SELECT COUNT(*) AS `nrows`":`SELECT ${c}`,`FROM ${p}`,u];if(null!=n)h.push(n);if(!e.count){if(!SqlQueryBuilder.isSingleResult(t))h.push(this.orderBySql(o,s,t.groups,t.values)||i||"");if(s){if(e.last)h.push(`LIMIT ${e.last}`)}else if(e.first)h.push(`LIMIT ${e.first}`);if(e.forUpdate&&"high"!==this.context.isolationLevel)h.push("FOR NO KEY UPDATE OF t0 "+(e.skipLocked?"SKIP LOCKED":""))}const g=this.sqlConverter.sqlParameters,y=this.sqlConverter.allTableNames,f=t.groups,m=t.values,d=o.map(e=>e.property);return{sql:h.join("\n"),sqlParameters:g,cursorProperties:d,allTableNames:y,outputColumns:a,groupColumns:f,valueColumns:m}}checkAbstractReferences(e){e.filter(e=>e.property?.isReferenceProperty()&&e.property.targetFactory?.isAbstract).forEach(t=>{e.push(this.sqlConverter.convertOutputPath({path:[`${t.property?.name}`,"_constructor"]}))})}}class SqlQuery{static{this.internalStatistics={queryCount:0}}constructor(e,t,r){if(this.context=e,this.factory=t,this.options=r,"sql"!==this.factory.storage&&"external"!==this.factory.storage)throw new Error(`${t.fullName}: cannot query: bad class storage: ${String(this.factory.storage)}`);this.fixAggregate()}async init(){if(this.options.locale)await this.context.setCurrentLocale(this.options.locale);return this}static create(e,t,r){return new SqlQuery(e,t,r).init()}fixAggregate(){if(!this.options.aggregate)return;this.options.aggregate?.groups.forEach(e=>{if(!e.groupedBy)e.groupedBy="value"})}mapOutputColumnValue(e,t){if(!e.columnAlias)throw new xtrem_shared_1.LogicError("no column alias");const r=t[e.columnAlias];if("collection"!==e.type)return sql_value_converter_1.SqlValueConverter.fromSql(this.context,e,t[e.columnAlias]);return Array.isArray(r)?(0,xtrem_async_helper_1.asyncArray)(r).map(t=>t&&"object"==typeof t?this.mapRecordIn(e.subColumns,t):t).toArray():r}async doMapRecordIn(e,t){if("external"===this.factory.storage)return this.factory.externalStorageManager.mapRecordIn(t);if(!e)throw new xtrem_shared_1.LogicError("missing outputColumns");if(true===this.options.selector){const r=e[0];if(r.columnAlias&&1===r.payloadPath?.length&&"_id"===r.payloadPath[0]){if("_id"!==r.property?.name)throw new xtrem_shared_1.LogicError(`unexpected property: ${r.property?.name}`);return t[r.columnAlias]}}const r={};if(await(0,xtrem_async_helper_1.asyncArray)(e).forEach(async e=>{if(!e.payloadPath)return;const o=await this.mapOutputColumnValue(e,t);let s=r,a=e.payloadPath[e.payloadPath.length-1];for(let t=0;t<e.payloadPath.length-1&&null!=s;t+=1){const r=e.payloadPath[t];if("_constructor"===a&&e.parent?.factory.isAbstract){a=`_${r}_constructor`;break}if("object"!=typeof s[r])s[r]={};if(null===o&&"_id"===a&&t===e.payloadPath.length-2)s[r]=null;s=s[r]}if(s)s[a]=o}),this.factory.baseFactory&&!r._constructor&&!this.options.selector)r._constructor=this.factory.name;return r}mapRecordIn(e,t){if(this.options.returnReferencesAsNaturalKey&&"sql"===this.factory.storage)return this.context.withReferenceAsNaturalKey(()=>this.doMapRecordIn(e,t));return this.doMapRecordIn(e,t)}async mapAggregateRecordIn(e,t,r){if("external"===this.factory.storage)return this.factory.externalStorageManager.mapAggregateRecordIn(r);if(!e)throw new xtrem_shared_1.LogicError("missing groupColumns");if(!t)throw new xtrem_shared_1.LogicError("missing valueColumns");const assign=(e,t,r,o)=>{const s=t.shift();if(t.length>(o?1:0)){if(!e[s])e[s]={};assign(e[s],t,r,o)}else e[s]=r},getAggregatorPath=e=>[...e.path.split(".").slice(1).filter(e=>"_super"!==e),e.aggregationOperator],o={};return await(0,xtrem_async_helper_1.asyncArray)(e).forEach(async e=>{o.group=o.group||{},assign(o.group,getAggregatorPath(e),await sql_value_converter_1.SqlValueConverter.fromSql(this.context,e,r[e.columnAlias]),e.aggregationOperator)}),await(0,xtrem_async_helper_1.asyncArray)(t).forEach(async e=>{o.values=o.values||{},assign(o.values,getAggregatorPath(e),await sql_value_converter_1.SqlValueConverter.fromSql(this.context,e,r[e.columnAlias]))}),o}static stripFilterValues(e,t){if(null==e)return e;if("function"==typeof e)return e.toString();if("_fn"===t)return e;if((0,runtime_1.isScalar)(e))return 0;if(e instanceof ts_api_1.Node)return{_id:0};if(Array.isArray(e))return e.map(SqlQuery.stripFilterValues);if("object"==typeof e)return lodash.mapValues(e,SqlQuery.stripFilterValues);throw new Error(`invalid filter element: ${e} of type ${typeof e}`)}getCacheKey(){return{kind:"select",schemaName:this.context.schemaName,factoryName:this.factory.name,options:{selector:this.options.selector,filters:SqlQuery.stripFilterValues(this.options.filters,""),orderBy:this.options.orderBy,first:this.options.first,last:this.options.last,before:this.options.before?.length,after:this.options.after?.length,aggregate:this.options.aggregate,count:this.options.count,forUpdate:this.options.forUpdate,skipLocked:this.options.skipLocked,locale:this.options.locale||this.context.currentLocale,onlyProperties:this.options.onlyProperties?.map(e=>e.name),singleResultRequest:this.options.singleResultRequest,context:this.context.getSqlCacheKey()}}}buildQuery(){return new SqlQueryBuilder(this.factory,this.context,this.options).buildQuery()}getCachedQuery(){return this.factory.application.sqlStatementCache.fetch({getKeyData:()=>this.getCacheKey(),buildStatement:()=>this.buildQuery()})}getRawReader(){SqlQuery.internalStatistics.queryCount+=1;const{options:e}=this;if("external"===this.factory.storage){if(!this.factory.externalStorageManager?.query)throw new Error(`${this.factory.name} : missing externalStorageManager.query`);return{reader:this.factory.externalStorageManager.query(this.context,e)}}const{sql:t,sqlParameters:r,cursorProperties:o,allTableNames:s,outputColumns:a,groupColumns:n,valueColumns:i}=this.getCachedQuery(),l=this.options.after?(0,types_1.parseCursor)(o,this.options.after):void 0,u=this.options.before?(0,types_1.parseCursor)(o,this.options.before):void 0,c=sql_converter_1.SqlConverter.getParameterValues(this.context,r,{filters:e.filters,before:u,after:l});if(e.count)return this.factory.cache.incrementCountQueryCounter(),{reader:this.context.createSqlReader(t,c).map(e=>e.nrows)};const createReader=()=>(this.context.sqlSpy.incrementCounter(this.factory,"SELECT"),metrics_1.CustomMetrics.sql.wrapReader({nodeName:this.factory.name,statementKind:"select"},this.context.createSqlReader(t,c)));let p=e.doNotCache||e.forUpdate||!this.factory.isCached;if(!p&&s.some(e=>!this.context.application.getFactoryByTableName(e.split(".").pop()??"").isCached)){const e=s.filter(e=>!this.context.application.getFactoryByTableName(e.split(".").pop()??"").isCached);loggers_1.loggers.performance.warn(`Query cannot be cached because of non cached tables ${e} referenced by one of ${s}`),p=true}if(p)return this.factory.cache.incrementIgnoredCounter(),{reader:createReader(),outputColumns:a,groupColumns:n,valueColumns:i};return{reader:new xtrem_async_helper_1.AsyncArrayReader(async()=>{const e=await c;return this.factory.cache.fetch(this.context,{getKey:()=>JSON.stringify({sql:t,args:e}),getValue:async()=>({value:await createReader().readAll(),invalidatingTokens:s}),isolateInContext:this.context.isWritable})}),outputColumns:a,groupColumns:n,valueColumns:i}}getDataReader(){const{reader:e,outputColumns:t}=this.getRawReader();return e.map(e=>this.mapRecordIn(t,e))}async getCount(){const{reader:e}=this.getRawReader(),t=await e.readAll();if(this.options.aggregate)return t.length;if(1!==t.length||"number"!=typeof t[0])throw new xtrem_shared_1.LogicError("Internal error: getCount does not return a single number");return t[0]}async getNodeData(){const e=await this.getDataReader().readAll();if(e.length>1)throw new Error("Internal error: getNodeData returns more than 1 record");return 1===e.length?e[0]:null}getNodeReader(){const e=!!this.options.forUpdate;return this.getDataReader().map(t=>node_state_1.NodeState.newFromQuery(this.context,this.factory,t,e).node)}getSelectReader(){return this.getDataReader()}getAggregateReader(){const{reader:e,groupColumns:t,valueColumns:r}=this.getRawReader();return e.map(e=>this.mapAggregateRecordIn(t,r,e))}}exports.SqlQuery=SqlQuery;
//# sourceMappingURL=sql-query.js.map