import { Property } from '../../properties';
import { Node } from '../../ts-api';
import { OutputColumn, SqlParameter } from './sql-converter';
/**
 * Structure of a cache entry for a generated SELECT statement
 *
 * This structure should be kept reasonably small.
 * It may reference metadata objects (Property instances) because this only costs a pointer
 * but it should not duplicate metadata.
 */
export interface CachedQuery {
    /** SQL statement string */
    sql: string;
    /** Descriptors of the statement parameters */
    sqlParameters: SqlParameter[];
    /** The properties of the paging cursor, if any */
    cursorProperties: Property[];
    /**
     * List of table names that are joined by the query.
     * This information is used to invalidate the cache of query results (NodeFactoryCache)
     */
    allTableNames: string[];
    /**
     * Descriptors of the selected columns (non-aggregate queries).
     * This is used to map column aliases to the property names and to convert the SQL values to property values.
     */
    outputColumns: OutputColumn[] | undefined;
    /** Descriptors of the groups returned by the query (aggregate queries only) */
    groupColumns: OutputColumn[] | undefined;
    /** Descriptors of values returned by the query (aggregate queries only) */
    valueColumns: OutputColumn[] | undefined;
}
/**
 * An output path describes an element which is returned by a query, before it gets processed by the SQL converter.
 * It only contains path information.
 * The SQL converter will transform it into an OutputColumn which contains a SQL expression, an alias, ...
 */
export type OutputPath = {
    /** The path from the root factory of the query or subquery, as an array of property names */
    path: string[];
    /** The output paths of the subquery, if path points to a collection property  */
    subPaths?: OutputPath[];
    /** The function that provides the result (after being converted to SQL) */
    compute?: (this: Node) => any;
};
//# sourceMappingURL=sql-query.d.ts.map