/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.SqlInsert=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_metrics_1=require("@sage/xtrem-metrics"),xtrem_shared_1=require("@sage/xtrem-shared"),lodash=require("lodash"),lazy_loaded_marker_1=require("../../node-state/lazy-loaded-marker"),properties_1=require("../../properties"),runtime_1=require("../../runtime"),core_hooks_1=require("../../runtime/core-hooks"),loggers_1=require("../../runtime/loggers"),sql_context_1=require("../sql-context"),schema_sql_context_1=require("../sql-context/schema-sql-context"),sql_context_2=require("../sql-context/sql-context"),naming_1=require("../statements/naming"),types_conversion_1=require("../statements/types-conversion"),sql_converter_1=require("./sql-converter"),sql_util_1=require("./sql-util"),sql_value_converter_1=require("./sql-value-converter"),sqlLogger=loggers_1.loggers.sql;class SqlInsert{constructor(e){this.table=e}get factory(){return this.table.factory}static{this.auditColumnNames=["_create_user","_create_stamp","_update_user","_update_stamp","_update_tick"]}isColumnSkipped(e,t,r){if(e.excludeFromInsertIfNull&&null===t)return true;if(e.property.isRequired&&null==t)throw new Error(`Cannot insert null value in column ${this.table.name}.${e.columnName}`);if(t===lazy_loaded_marker_1.lazyLoadedMarker)return true;if(e.property instanceof properties_1.ReferenceProperty&&e.property.isSelfReference&&t<0&&t===r.selfId)return true;if(!r.preserveAuditColumns&&this.table.databaseComputedColumnNames.includes(e.columnName))return true;if("_id"===e.propertyName&&t<0)return true;if("_sortValue"===e.propertyName&&!t)return true;return false}static fixColumnValue(e,t,r,s){if(t.property.isLocalized){const s=t.property.name;return sql_util_1.SqlUtil.fixLocalizedValue(e,r,s,"insert")}if(Array.isArray(r)&&!(t.property.isArrayProperty()||t.property.isJsonProperty()))throw t.columnError("unexpected array");if(t.property.isReferenceProperty()&&t.property.isSelfReference&&Number.isFinite(r)&&Number(r)<0)return s.selfId;return r??null}fixAndFilterColumns(e,t,r){return this.table.columns.filter(s=>{const n=s.property.name,a=t[n];return t[n]=SqlInsert.fixColumnValue(e,s,a,r),!this.isColumnSkipped(s,a,r)})}async prepareRow(e,t,r={}){let s={...t};if(null==s._id||0===s._id)s._id=e.allocateTransientId();let n={};if(this.factory.propertiesByName._sortValue&&null==s._sortValue&&"number"==typeof s._id&&s._id>0)s._sortValue=100*s._id;let a=r.constructorName;if(this.factory.isAbstract){if(!a)throw new Error(`'constructor' is missing, cannot insert into '${this.table.name}'`);s._constructor=a}else{if(a)throw new Error(`No 'constructor' should be provided for table '${this.table.name}', constructor was '${a}'`);a=this.factory.name}const o=this.table.baseTable;if(o){const t=this.table.columns.filter(e=>{if("_id"===e.propertyName)return true;return!e.property.isInherited}).reduce((e,t)=>(e[t.propertyName]=true,e),{}),i={},l={};if(Object.keys(s).forEach(e=>{if(t[e])i[e]=s[e];else l[e]=s[e]}),s._id&&"number"==typeof s._id&&s._id>0)l._id=s._id;l._sourceId=i._sourceId,n={...n,...await new SqlInsert(o).insert(e,l,{...r,constructorName:a})},s={...i,...n}}const i=this.fixAndFilterColumns(e,s,{selfId:s._id,preserveAuditColumns:!!r.preserveAuditColumns}),l=s.email===runtime_1.rootUserEmail&&this.factory.name===core_hooks_1.CoreHooks.sysManager.getUserNode().name;return{row:s,allNewKeys:n,isRootUserInsert:l,insertedColumns:i}}getReturningColumnNames(e){return this.table.columns.filter(t=>{if(t.isAutoIncrement)return true;if(e.processLocalizedTextAsJson&&t.property.isLocalized)return true;if("_sort_value"===t.columnName)return true;if("_constructor"===t.columnName)return true;return false}).map(e=>e.columnName)}getInsertInfo(e,t){const r=[],s=[],n=e.context.schemaName,a=this.getReturningColumnNames(e.context),o=[];if(t.insertedColumns.forEach(t=>{s.push(sql_context_2.SqlContext.escape(t.columnName)),r.push(sql_util_1.SqlUtil.pushColumnArg(e,t))}),t.isRootUserInsert)["_create_user","_update_user"].forEach(t=>{s.push(t),r.push((0,sql_context_1.getSqlCurrvalOfIdSequence)(this.table.getFullTableName(e.context)))});const i=o.filter(e=>"autofix"===e.category);if(i.length>0)if(loggers_1.loggers.sql.warn(`${n}.${this.table.name} has autofixed ${i.length} lines`),loggers_1.loggers.sql.isActive("debug"))i.forEach(e=>loggers_1.loggers.sql.debug(()=>e.message));let l;if(t.useUpsert){if(!this.factory.naturalKey)throw new Error(`Upsert mode can only be used on factories with a natural key (factory was ${this.factory.fullName})`);if(l=this.factory.naturalKey.map(e=>this.factory.propertiesByName[e].requiredColumnName),!this.table.isSharedByAllTenants)l.unshift("_tenant_id")}const u=e.sqlParameters;return{schemaName:n,columnNames:s,sqlParameters:u,parameterNames:r,returningColumns:a,upsertKeyColumns:l}}getUpsertFunctionSql(e,t,r){return`CREATE OR REPLACE FUNCTION ${e}.upsert(${t.map(t=>`${e}.${this.table.name}.${t}%TYPE`).join(",")}) RETURNS JSON AS\n        $$\n            DECLARE ret RECORD;\n            err_message TEXT;\n            err_detail TEXT;\n        BEGIN\n        ${r} into ret;\n        RETURN row_to_json(ret);\n        RETURN JSON;\n        EXCEPTION\n            WHEN unique_violation THEN\n                -- duplicate key on another unique index than the one that was used in the ON CONFLICT(...) clause\n\n                -- capture the error message/detail\n                GET STACKED DIAGNOSTICS\n                    err_message = MESSAGE_TEXT,\n                    err_detail = PG_EXCEPTION_DETAIL;\n                SELECT column1 as _err_message, TRUE as _upsert_failed, err_detail as _err_detail FROM (VALUES(err_message)) AS T INTO ret;\n                RETURN row_to_json(ret);\n            WHEN OTHERS THEN RAISE;\n        END $$ LANGUAGE plpgsql;`}getInsertSql(e,t){if(!e.returningColumns)e.returningColumns=[];const r=e.upsertKeyColumns||["_tenant_id","_id"],s=this.table.databaseComputedColumnNames,n=lodash.uniq([...s,...e.returningColumns||[]]),a=[];if(a.push(`INSERT INTO ${e.schemaName}.${this.table.name}\n`),a.push(`(${e.columnNames.join(",")})\n`),a.push(`VALUES (${e.parameterNames.join(",")})`),t.onConflictDoNothing)a.push("\nON CONFLICT DO NOTHING");else if(t.useUpsert){const s=[],n=[],o=[...r,"_create_stamp","_create_user","_update_user",...t.upsertColumnsToIgnore||[]];e.columnNames.forEach((t,r)=>{if(o.includes(t));else s.push(t),n.push(e.parameterNames[r])});const i=r.map(e=>{const t=this.table.columnsByColumnName[e];if(!t)throw new Error(`Table ${this.table.name}: column ${e} does not exist`);if(!t.isNullable)return sql_context_2.SqlContext.escape(e);return`COALESCE (${sql_context_2.SqlContext.escape(e)}, 0)`}).join();a.push(`\nON CONFLICT (${i}) DO UPDATE SET (${s}) = (${n})`)}if(n.length)a.push(`\nRETURNING ${n.join(",")}`);const o=e.schemaName,i=e.columnNames;let l="",u=a.join("");if(t.useUpsert)l=this.getUpsertFunctionSql(o,i,u),u=`SELECT ${o}.upsert(${e.parameterNames.join(",")});`;return{sql:u,sqlParameters:e.sqlParameters,upsertFunctionSql:l}}collectInsertStatements(e,t,r=[]){if(this.table.baseTable)new SqlInsert(this.table.baseTable).collectInsertStatements(e,t,r);const s=["_create_stamp","_update_stamp","_update_tick"],n=new sql_converter_1.SqlConverter(e,this.factory),a=this.getInsertInfo(n,{...t,isRootUserInsert:false,insertedColumns:[...this.table.columns.filter(e=>!s.includes(e.columnName))]});return r.push(this.getInsertSql(a,t)),r}static{this.logged={}}getInsertFunctionParameters(e){const mapPropertyType=t=>{switch(t.type){case"string":return t.isLocalized?"JSONB":"TEXT";case"enum":return`${e}.${t.dataType.getEnumType().name}`;case"enumArray":return`${e}.${t.dataType.getEnumType().name}[]`;case"jsonReference":return"JSONB";default:if(t.type in types_conversion_1.xtremToPostgreSql)return types_conversion_1.xtremToPostgreSql[t.type].type;throw this.factory.logicError(`Unsupported type ${t.type} for property ${t.name}`)}},getColumn=(e,t)=>{const r=e.findProperty(t);if(r.column)return r.column;if(!e.baseFactory)throw this.factory.logicError(`Column not found for property ${r.name}`);return getColumn(e.baseFactory,t)};return this.factory.properties.filter(e=>e.isStored).sort((e,t)=>e.name.localeCompare(t.name)).map(e=>({column:getColumn(this.factory,e.name),name:`p_${e.columnName}`,sqlType:mapPropertyType(e)})).filter(e=>!SqlInsert.auditColumnNames.includes(e.column.columnName))}static getInsertFunctionName(e){return(0,naming_1.makeName63)(`_insert_${e}`)}getInsertFunctionName(){return SqlInsert.getInsertFunctionName(this.table.name)}getCreateSqlInsertFunctionSql(e){const t=this.collectInsertStatements(e,{}),snakeCase=e=>"_"===e[0]?`_${snakeCase(e.substring(1))}`:lodash.snakeCase(e),mapParameterName=e=>{if(!e.valuePath.startsWith("values."))throw this.factory.logicError(`Invalid insert parameter name: ${e.valuePath}`);const t=e.valuePath.substring(7);return"_id"===t?"l_id":`p_${snakeCase(t)}`},r=this.getInsertFunctionParameters(e.schemaName),mapStatementParameters=e=>e.sql.replace(/\$(\d+)/g,(t,r)=>mapParameterName(e.sqlParameters[Number(r)-1])),mapStatement=(e,t)=>{const r=mapStatementParameters(e).replace(/\n/g,nl(2)),[s,n]=r.split(" RETURNING ");return`${`${s} RETURNING ${n??" _id"} INTO ret_${t+1};`}\nRET := RET || to_jsonb(ret_${t+1});`},nl=e=>`\n${"    ".repeat(e)}`,s=`nextval(${(0,types_conversion_1.getSqlSerialSequence)(this.factory.rootFactory.table.getFullTableName(e))})`,n=[r.map(e=>`${nl(1)}${e.name} ${e.sqlType}`).join(","),this.factory.isSharedByAllTenants?"":`,${nl(1)}p__tenant_id TEXT`,this.factory.baseFactory?`,${nl(1)}p__constructor TEXT`:""].join(""),a=null!=this.factory.propertiesByName._sortValue?"\n        IF p__sort_value = 0 OR p__sort_value is NULL THEN p__sort_value := l_id * 100; END IF;":"",o=this.factory.properties.filter(e=>e.isReferenceProperty()&&e.isSelfReference).map(e=>`\n    IF p_${e.columnName} IS NULL OR p_${e.columnName} <= 0 THEN p_${e.columnName} := l_id; END IF;`).join("\n"),i=this.factory.name===core_hooks_1.CoreHooks.sysManager.getUserNode().name?"l_id::TEXT":"NULL";return`CREATE OR REPLACE FUNCTION ${e.schemaName}.${this.getInsertFunctionName()}(${n})\nRETURNS JSONB AS $$\n\nDECLARE l_id INT8;\nDECLARE l_user_id TEXT;\nDECLARE p__create_user INT8;\nDECLARE p__update_user INT8;\n${t.map((e,t)=>`DECLARE ret_${t+1} RECORD;`).join("\n")}\nDECLARE RET JSONB;\n\nBEGIN\n    IF p__id IS NULL OR p__id <= 0 THEN\n        SELECT ${s} into l_id;\n    ELSE\n        l_id := p__id;\n    END IF;${a}\n\n    l_user_id := COALESCE(${e.schemaName}.get_config('xtrem.transaction_user_id'), '');\n    IF l_user_id = '' THEN l_user_id := ${i}; END IF;\n    p__create_user := l_user_id::INT8;\n    p__update_user := l_user_id::INT8;\n    ${o}\n\n    RET := jsonb_build_object('_id', l_id);\n\n    ${t.map(mapStatement).join("\n\n")}\n\n    RETURN RET;\nEND;\n$$ LANGUAGE plpgsql;`}static getDropSqlInsertFunctionSql(e,t){return`DROP FUNCTION IF EXISTS ${e.schemaName}.${this.getInsertFunctionName(t)};`}async insertWithFunction(e,t){if(this.factory.isAbstract)throw this.factory.logicError("Cannot insert with function into abstract factory");const r=this.getInsertFunctionParameters(e.schemaName),s=await(0,xtrem_async_helper_1.asyncArray)(r).map(async r=>SqlInsert.fixColumnValue(e,r.column,await sql_value_converter_1.SqlValueConverter.toSql(e,r.column,t[r.column.property.name]),{selfId:Number(t._id),preserveAuditColumns:false})).toArray();if(!this.factory.isSharedByAllTenants)s.push(e.tenantId);if(this.factory.baseFactory)s.push(this.factory.name);const n=s.map((e,t)=>`$${t+1}`),a=`SELECT ${e.schemaName}.${this.getInsertFunctionName()}(${n.join(",")}) as returned`,o=await e.executeSql(a,s);if(!o||1!==o.length)throw this.factory.logicError(`insert_${this.table.name} returned no result`);const i=o[0].returned;if(e.processLocalizedTextAsJson)r.forEach((e,r)=>{const n=e.column.property;if(n.isLocalized)t[n.name]=JSON.stringify(s[r])});return this.table.setAsDirty(),i}static async dropUpsertSqlFunction(e){await new schema_sql_context_1.SchemaSqlContext(e.application).executeSqlStatement({sql:`DROP FUNCTION IF EXISTS ${e.schemaName}.upsert;`}),e.sqlFunctionCache.queryWithIgnoredErrors=""}static async _createUpsertSqlFunction(e,t){if(e.sqlFunctionCache.queryWithIgnoredErrors===t)return;await SqlInsert.dropUpsertSqlFunction(e),await new schema_sql_context_1.SchemaSqlContext(e.application).executeSqlStatement({sql:t}),e.sqlFunctionCache.queryWithIgnoredErrors=t}async _executeUpsertSqlFunction(e,t,r){try{await SqlInsert._createUpsertSqlFunction(e,t.upsertFunctionSql);const s=await xtrem_metrics_1.CustomMetrics.sql.withMetrics({nodeName:this.factory.name,statementKind:"upsert"},()=>e.executeSql(t.sql,r));return s[0].upsert}catch(e){throw sqlLogger.error(`Upsert failed into table ${this.table.name}.\nSQL: ${t.sql.replace(/\n/g,"\n\t")}\nparameters: ${r}`),e}}upsertConflictErrorMessage(e,t,r,s){return`Could not upsert into ${e.schemaName}.${this.table.name} because of key conflicts\nmessage: ${t._err_message}\ndetails: ${t._err_detail}\nsql: ${r.upsertFunctionSql}\nvalues: \n\t - ${r.sqlParameters.map((e,t)=>`${e.valuePath}: ${s[t]}`).join("\n\t - ")}\n                `}async fetchIdFromNaturalKey(e,t){const r=this.factory.isContentAddressable?["_valuesHash"]:this.factory.naturalKey;if(!r)throw new xtrem_shared_1.LogicError(`${this.factory.name} cannot fetch _id: natural key missing`);const s=new sql_converter_1.SqlConverter(e,this.factory),n=[],a=[],o=[];if(!this.factory.isSharedByAllTenants)n.push(s.addSqlParameter({valuePath:t._tenantId?"values._tenantId":"context.tenantId",type:"string"})),a.push("_tenant_id"),o.push(false);r.forEach(e=>{const t=this.factory.findProperty(e),r=t.isReferenceProperty()?t.targetFactory.name:void 0;n.push(s.addSqlParameter({valuePath:`values.${e}`,type:t.type,factoryName:r})),a.push(t.columnName),o.push(t.isNullable)});const i=a.map((e,t)=>`(${e} = ${n[t]}${o[t]?` OR (${e} IS NULL AND ${n[t]} IS NULL)`:""})`).join(" AND "),l=`SELECT _id FROM ${this.table.getFullTableName(e)} WHERE ${i}`,u=await sql_converter_1.SqlConverter.getParameterValues(e,s.sqlParameters,{values:t}),c=await xtrem_metrics_1.CustomMetrics.sql.withMetrics({nodeName:this.factory.name,statementKind:"select"},()=>e.executeSql(l,u));if(1!==c.length)throw new xtrem_shared_1.LogicError(`${this.factory.name} cannot fetch _id: no match with natural key`);return c[0]._id}async insertValues(e,t,r,s){const{sql:n,sqlParameters:a}=r;let o;const i=await sql_converter_1.SqlConverter.getParameterValues(e,a,{values:t});if(s.useUpsert){if(o=await this._executeUpsertSqlFunction(e,r,i),o._upsert_failed){const t=this.upsertConflictErrorMessage(e,o,r,i);if(s.ignoreUpsertErrors)return sqlLogger.error(t),{};throw new Error(t)}if(o._create_stamp)o._create_stamp=new Date(`${o._create_stamp}Z`);if(o._update_stamp)o._update_stamp=new Date(`${o._update_stamp}Z`)}else{const r=e.transaction.connection;try{o=await xtrem_metrics_1.CustomMetrics.sql.withMetrics({nodeName:this.factory.name,statementKind:"insert"},()=>e.sqlPool.execute(r,n,i))}catch(e){throw sqlLogger.error(`Insert failed into table ${this.table.name}.\nSQL: ${n.replace(/\n/g,"\n\t")}\nparameters: ${i}`),e}if(0===o.updateCount){if(!n.includes("ON CONFLICT DO NOTHING"))throw new xtrem_shared_1.LogicError("unexpected updateCount 0");o._id=await this.fetchIdFromNaturalKey(e,t)}}if(delete o.updateCount,o&&Object.keys(o).length)sql_context_2.SqlContext.logger.verbose(()=>`Returning values: ${JSON.stringify(o)}`);return o}getCacheKey(e,t){return{kind:t.useUpsert?"upsert":"insert",schemaName:e.schemaName,factoryName:this.factory.name,options:{...t,insertedColumns:t.insertedColumns.map(e=>e.columnName),locale:e.currentLocale,locales:e.locales,processLocalizedTextAsJson:e.processLocalizedTextAsJson}}}async insert(e,t,r={}){e.sqlSpy.incrementCounter(this.factory,"INSERT");try{if(this.factory.hasSqlInsertFunction&&0===Object.keys(r).length)return await this.insertWithFunction(e,t);const{row:s,allNewKeys:n,isRootUserInsert:a,insertedColumns:o}=await this.prepareRow(e,t,r),i={...r,isRootUserInsert:a,insertedColumns:o},l=this.factory.application.sqlStatementCache.fetch({getKeyData:()=>this.getCacheKey(e,i),buildStatement:()=>{const t=new sql_converter_1.SqlConverter(e,this.factory),s=this.getInsertInfo(t,i);return this.getInsertSql(s,r)}}),u=await this.insertValues(e,s,l,{useUpsert:!!r.useUpsert,ignoreUpsertErrors:!!r.ignoreUpsertErrors});return{...n,...u}}finally{if(e.testMode)this.table.markAsModifiedForTests()}}getMetadataInsertInfo(e,t,r){const s=[],n=[],a={};if(t.columns.forEach(t=>{let o=lodash.camelCase(t.name);if(t.name.startsWith("_"))o=`_${o}`;a[o]=true,r[o]=r[o]??null,n.push(sql_context_2.SqlContext.escape(t.name)),s.push(e.addSqlParameter({valuePath:`values.${o}`,type:t.isEncrypted?"encryptedString":t.type}))}),!a._updateTick)if(n.push(sql_context_2.SqlContext.escape("_update_tick")),s.push(e.addSqlParameter({valuePath:"values._updateTick",type:"integer"})),!r._updateTick)r._updateTick=1;if(r._tenantId&&!a._tenantId)n.push(sql_context_2.SqlContext.escape("_tenant_id")),s.push(e.addSqlParameter({valuePath:"values._tenantId",type:"string"}));const o=this.getReturningColumnNames(e.context),i=e.context.schemaName,l=e.sqlParameters,u=t.naturalKeyColumns;return{schemaName:i,columnNames:n,sqlParameters:l,parameterNames:s,returningColumns:o,upsertKeyColumns:u}}insertWithMetadata(e,t,r,s){const n=this.factory.application.sqlStatementCache.fetch({getKeyData:()=>this.getCacheKey(e,s),buildStatement:()=>{const n=new sql_converter_1.SqlConverter(e,this.factory),a=this.getMetadataInsertInfo(n,t,r);return this.getInsertSql(a,s)}});return this.insertValues(e,r,n,{useUpsert:!!s.useUpsert,ignoreUpsertErrors:!!s.ignoreUpsertErrors})}async insertFromSqlFile(e,t,r={}){const{row:s,allNewKeys:n,isRootUserInsert:a,insertedColumns:o}=await this.prepareRow(e,t,r);if(r.metadata)return{...n,...await this.insertWithMetadata(e,r.metadata,s,{...r,isRootUserInsert:a,insertedColumns:o})};return this.insert(e,t,r)}}exports.SqlInsert=SqlInsert;
//# sourceMappingURL=sql-insert.js.map