/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.SqlDelete=void 0;const xtrem_metrics_1=require("@sage/xtrem-metrics"),runtime_1=require("../../runtime"),sql_converter_1=require("./sql-converter");class SqlDelete{constructor(e){this.table=e}get factory(){return this.table.factory}async delete(e,t){if(this.factory.isAbstract)throw new Error(`${this.table.name} : Deletions can't be done on abstract factories`);e.sqlSpy.incrementCounter(this.factory,"DELETE");const r=new sql_converter_1.SqlConverter(e,this.factory);if(this.table.baseTable&&Object.keys(t).length>0){const deleteFromTables=async(a,s)=>{const i=`DELETE FROM ${a.getFullTableName(e)} WHERE ${(0,runtime_1.tenantCondition)(r,this.table,"",s?[s]:[])}`,n=await sql_converter_1.SqlConverter.getParameterValues(e,r.sqlParameters,{where:t});return(await xtrem_metrics_1.CustomMetrics.sql.withMetrics({nodeName:this.factory.name,statementKind:"delete"},()=>e.executeSql(i,n))).updateCount};if(t._id&&(0,runtime_1.isScalar)(t._id))return deleteFromTables(this.table,`_id = ${t._id}`);const a=r.convertWhere(t),s=r.convertOutputPaths([{path:["_id"]}]).map(e=>e.sql),i=r.getTableAliases(),n=(0,runtime_1.tenantCondition)(r,this.table,"t0",[a]);return deleteFromTables(this.table,`_id IN (SELECT ${s} FROM ${i} WHERE ${n})`)}const a=r.convertWhere(t),s=`DELETE FROM ${this.table.getFullTableName(e)} t0 WHERE ${(0,runtime_1.tenantCondition)(r,this.table,"",a?[a]:[])}`,i=await sql_converter_1.SqlConverter.getParameterValues(e,r.sqlParameters,{where:t});return(await xtrem_metrics_1.CustomMetrics.sql.withMetrics({nodeName:this.factory.name,statementKind:"delete"},()=>e.executeSql(s,i))).updateCount}async deleteAll(e){await this.delete(e,{})}}exports.SqlDelete=SqlDelete;
//# sourceMappingURL=sql-delete.js.map