/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.SqlConverter=void 0;const xtrem_postgres_1=require("@sage/xtrem-postgres"),xtrem_shared_1=require("@sage/xtrem-shared"),xtrem_ts_to_sql_1=require("@sage/xtrem-ts-to-sql"),_=require("lodash"),__1=require(".."),__2=require("../.."),context_1=require("../../runtime/context"),loggers_1=require("../../runtime/loggers"),system_properties_1=require("../../runtime/system-properties"),utils_1=require("../../runtime/utils"),ts_api_1=require("../../ts-api"),arrays_1=require("../../types/arrays"),sql_resolver_1=require("./sql-resolver"),sql_value_converter_1=require("./sql-value-converter");function cast(e,t){if(!e)throw new xtrem_shared_1.LogicError("cannot cast: missing sql");const{type:r,property:n}=t;if(!r)return e;const addCast=t=>e.toLowerCase().endsWith(`::${t.toLowerCase()}`)?e:`${e}::${t}`;switch(r){case"integerRange":return addCast("INT8");case"decimalRange":return addCast("DECIMAL");case"date":case"dateRange":return addCast("DATE");case"datetime":case"datetimeRange":return addCast("TIMESTAMPTZ(3)");case"enum":if(!n?.isEnumProperty())throw new Error("cannot cast enum: invalid property");return addCast(`${n.factory.application.schemaName}.${n.dataType.getEnumType().name}`);default:return e}}(0,xtrem_ts_to_sql_1.setLogger)(loggers_1.loggers.sqlMapper);const orIsNull=(e,t)=>e.isNullable?`OR (${t} IS NULL)`:"",andIsNotNull=(e,t)=>e.isNullable?`AND (${t} IS NOT NULL)`:"",collate=e=>e.property?.isLocalized&&e.collation?`COLLATE "${e.collation}"`:"",binaryOps={_eq:(e,t,r)=>`(${t} ${collate(e)} = ${r} ${andIsNotNull(e,t)})`,_ne:(e,t,r)=>`(${t} ${collate(e)} != ${r} ${orIsNull(e,t)})`,_gt:(e,t,r)=>`(${t} ${collate(e)} > ${r} ${andIsNotNull(e,t)})`,_gte:(e,t,r)=>`(${t} ${collate(e)} >= ${r} ${andIsNotNull(e,t)})`,_lt:(e,t,r)=>`(${t} ${collate(e)} < ${r} ${orIsNull(e,t)})`,_lte:(e,t,r)=>`(${t} ${collate(e)} <= ${r} ${orIsNull(e,t)})`,_contains:(e,t,r)=>{switch(e.property?.type){case"integerArray":case"enumArray":case"referenceArray":case"stringArray":return`(${t} = ANY (${r}))`;case"json":return`(${t} ? ${r})`;default:return`(${t} @> ${cast(r,e)})`}},_containsRange:(e,t,r)=>`(${t} @> ${r})`,_containedBy:(e,t,r)=>`(${t} <@ ${r})`};function isFilterObject(e){return!!e&&(0,utils_1.isCompound)(e)}function logWrongType(e,t,r){let n=typeof r;if(n===e)return;if("object"===n)n=null==r?"null":r.constructor.name;loggers_1.loggers.sql.warn(`'${t}': expected a 'string', got type='${n}', value=${JSON.stringify(r)}`)}class SqlConverter extends xtrem_ts_to_sql_1.Converter{#e;constructor(e,t,r){super(e,t,{resolveColumnName:(e,r,n)=>sql_resolver_1.SqlResolver.resolve(this,e,r,n,t),resolveTableName:t=>`${e.schemaName}.${t.tableName||_.snakeCase(t.name)}`,resolveLiteral:e=>this.resolveLiteral(e)},{dialect:"postgres",maxSubQueryDepth:__2.ConfigManager.current.storage?.sql?.maxSubQueryDepth,...r}),this.context=e,this.rootFactory=t,this.sqlParameters=[],this.#e={}}convertTemplateElementString(e){return`${this.resolveLiteral(e)}::TEXT`}addSqlParameter(e){const getCastTo=()=>{const t=e.literalValue;if("boolean"==typeof t)return"boolean";if(Number.isFinite(t)&&!Number.isInteger(t))return"decimal";return"integer"};let t=__1.SqlContext.param(this.sqlParameters.length);if(["boolean","number"].includes(typeof e.literalValue)){const e={sql:t,type:"string"},r=getCastTo();t=this.cast(e,r).sql}return this.sqlParameters.push(e),t}hasArgDescriptor(e){return this.sqlParameters.some(t=>t.valuePath===e)}resolveLiteral(e){if(null==e)return"NULL";if("string"==typeof e&&e.includes(xtrem_postgres_1.dbCommandMarker))return e;const t=`${typeof e}/${e.toString()}`;if(!this.#e[t])this.#e[t]=this.addSqlParameter({valuePath:"",type:"string",literalValue:e});return this.#e[t]}getUpdateSetCommand(e){const convertValue=(e,t)=>{const r=this.rootFactory.propertiesByName[e];if("function"==typeof t){let e=this.convertFunction(t).sql;if(r?.isEnumProperty())e=`(${e})::${this.context.schemaName}.${r.dataType.getEnumType().name}`;if(r?.isLocalized&&this.context.processLocalizedTextAsJson)e=`json_build_object('base', ${e})`;return e}if("string"==typeof t&&t.endsWith("/*%%DB_COMMAND%%*/"))return console.warn(`POTENTIAL SQL INJECTION: ${t}`),t;return this.addSqlParameter({valuePath:`values.${r.name}`,type:r.type||"string",column:r.column,factoryName:r.isReferenceProperty()||r.isReferenceArrayProperty()?r.targetFactory.name:void 0})},t=Object.keys(e.set).map(t=>{const r=e.set[t];return`${(0,xtrem_ts_to_sql_1.getColumnName)(t)}=${convertValue(t,r)}`});let r=e.where?this.convertWhere(e.where):"TRUE";const n=this.aliases[0];if(this.context.tenantId){if(!this.rootFactory.isSharedByAllTenants)r=`${r} AND ${n.alias}._tenant_id = ${this.resolveLiteral(this.context.tenantId)}`}else if(!this.context.unsafeApplyToAllTenants)loggers_1.loggers.sql.warn("Operation not permitted: unsafeApplyToAllTenants is not set (update)");const a=[r];if(1===this.aliases.length)return`UPDATE ${n.tableName} AS ${n.alias} SET ${t.join(",")} WHERE (${r})`;if(!this.rootFactory.isSharedByAllTenants)a.unshift("t00._tenant_id = t0._tenant_id");return a.unshift("t0._id = t00._id"),`UPDATE ${n.tableName} AS t00 SET ${t.join(",")} FROM ${this.getTableAliases()} WHERE (${a.join(") AND (")})`}getDeleteFromCommand(e){let t=e.where?this.convertWhere(e.where):"TRUE";const r=this.aliases[0];if(this.context.tenantId)t=`${t} AND ${r.alias}._tenant_id = ${this.addSqlParameter({valuePath:"context.tenantId",type:"string"})}`;else if(!this.context.unsafeApplyToAllTenants)loggers_1.loggers.sql.warn("Operation not permitted: unsafeApplyToAllTenants is not set (delete)");const n=[t];if(1===this.aliases.length)return`DELETE FROM ${r.tableName} AS ${r.alias} WHERE (${t})`;return`DELETE FROM ${r.tableName} AS t0 USING ${this.aliases.slice(1).map(e=>`${e.tableName} AS ${e.alias}`).join(",")} WHERE (${this.aliases.slice(1).map(e=>e.join?.condition)}) AND (${n.join(") AND (")})`}static hasQuantifier(e){return Object.keys(e).filter(e=>/^_(atMost|atLeast|every|none)$/.test(e)).length>0}static getQuantifier(e,t){if(!t||"object"!=typeof t)throw new Error(`${e.path}: invalid collection filter - not an object`);if(!this.hasQuantifier(t))throw new Error(`${e.path}: missing _atLeast/_atMost/_every/_none quantifier on nested filter ${Object.keys(t)}`);const r=Object.keys(t).filter(e=>/^_(atMost|atLeast|every|none)$/.test(e));if(r.length>1)throw new Error(`${e.path}: only ONE _atLeast/_atMost/_every/_none quantifier on nested filter can be defined but found ${r}`);return r[0]}static checkQuantifierValue(e,t,r){if("_atMost"===r||"_atLeast"===r){if(!Number.isFinite(Number(t[r])))throw new Error(`${e.path}.${r}: value must be a number.`)}else if(true!==t[r])throw new Error(`${e.path}.${r}: value must be true`)}convertSubqueryFilter(e,t,r,n){return super.withSubQueryScope(()=>{const a=!!t.skipJoin;let s;if("collection"===t.property?.type&&!t.property?.reverseReference&&t.property?.join){if(Object.values(t.property.join).some(e=>"string"==typeof e))throw new Error(`Invalid join ${JSON.stringify(t.property.join)} with string value. Please use function instead or new JoinLiteralValue(value) syntax.`);s=t.property.join,t.skipJoin=true}let o=this.convertFilterObject(e,t,r);if(s){const r=this.convertFilterObject(e,t,s);o=xtrem_ts_to_sql_1.Converter.and([o,r])}if(t.skipJoin=a,!n&&t.property&&t.property.isForeignNodeProperty()&&!t.property.targetFactory.isSharedByAllTenants)o=xtrem_ts_to_sql_1.Converter.and([o,`${this.scopeAlias?.alias}._tenant_id = ${this.addSqlParameter({valuePath:"context.tenantId",type:"string"})}`]);return{innerFilterSql:o}},n)}getNestedFilterSubquery(e,t,r,n){const a=SqlConverter.getQuantifier(t,r);SqlConverter.checkQuantifierValue(t,r,a);const s=_.omit(r,[a]),o=this.convertSubqueryFilter(e,t,s,n),i="_every"===a?`NOT(${o.innerFilterSql})`:o.innerFilterSql,l=`(SELECT COUNT(*) FROM ${o.aliases} WHERE ${SqlConverter.and([o.joinCondition,i])})`;switch(a){case"_atLeast":return`(${l} >= ${this.addSqlParameter({valuePath:e,subPath:"_atLeast",type:"integer"})})`;case"_atMost":return`(${l} <= ${this.addSqlParameter({valuePath:e,subPath:"_atMost",type:"integer"})})`;case"_none":case"_every":return`(${l} = 0)`;default:throw new Error(`invalid quantifier: ${a}`)}}convertCollectionFilter(e,t,r){return this.getNestedFilterSubquery(e,t,r)}convertReferenceArrayFilter(e,t,r){if(!SqlConverter.hasQuantifier(r))return this.convertAnyFilter(e,t,r);const getJoinCondition=()=>`${this.scopeAlias?.alias}._id in (select unnest(${t.sql})) AND ${this.scopeAlias?.alias}._tenant_id = ${this.addSqlParameter({valuePath:"context.tenantId",type:"string"})}`;return this.getNestedFilterSubquery(e,t,r,getJoinCondition)}convertArrayFilter(e,t,r){if("object"==typeof r&&!Array.isArray(r)){if("referenceArray"===t.type)return this.convertReferenceArrayFilter(e,t,r);return this.convertAnyFilter(e,t,r)}return`${t.sql} = ${this.convertArg(e,t)}`}convertPropertyFilter(e,t,r,n){const a={...super.walk(t,n),collation:this.context.collation},s=`${e}.${n}`,o=r[n];if("collection"===a.type)return this.convertCollectionFilter(s,a,o);if(arrays_1.arrayTypes.includes(a.type))return this.convertArrayFilter(s,a,o);return this.convertAnyFilter(s,a,o)}static convertNumber(e,t){const r="number"==typeof t?t:parseFloat(String(t));if(!Number.isFinite(r))throw new xtrem_shared_1.DataInputError(`${e.valuePath}: invalid numeric value: '${t}'`);return r}static convertBinary(e,t){if(Buffer.isBuffer(t.value))return t.value;throw new Error(`${e.valuePath}: cannot convert value ${t} of type ${typeof t} to ${e.type} to SQL`)}static getParameterSubValue(e,t){switch(e.subPath){case"_regex":return t instanceof RegExp?t.source:String(t._regex);case"_options":return t instanceof RegExp?t.flags:String(t._options||"");case"_atLeast":case"_atMost":{const r=t?.[e.subPath];if("number"!=typeof r)throw new Error(`${e.valuePath}.${e.subPath}: invalid value: ${r}`);return r}default:throw new xtrem_shared_1.LogicError(`${e.valuePath}: invalid subPath: ${e.subPath}`)}}static getParameterValue(e,t,r){if(void 0===r&&!t.column)throw new Error(`${t.valuePath}: SQL arg is undefined`);if(t.isArray&&Array.isArray(r))return Promise.all(r.map(r=>this.getParameterValue(e,{...t,isArray:false},r)));if(t.column)return sql_value_converter_1.SqlValueConverter.toSql(e,t.column,r);if(null==r)return null;if(t.subPath)return this.getParameterSubValue(t,r);switch(t.type){case"boolean":case"enum":case"json":case"jsonReference":return r;case"encryptedString":if("string"!=typeof r)throw new Error(`Invalid value for ${t.type}: ${r} of type ${typeof r}`);return e.vault.getValueFromVault(r);case"string":if("string"!=typeof r)logWrongType(t.type,t.valuePath||"",r);return String(r);case"decimal":case"integerRange":case"decimalRange":case"dateRange":case"datetimeRange":case"date":case"time":case"datetime":case"textStream":return String(r);case"short":case"float":case"double":case"integer":return this.convertNumber(t,r);case"enumArray":if(!Array.isArray(r))throw new Error(`Invalid array value for ${t.type}: ${r}`);return r;case"integerArray":case"referenceArray":if(!Array.isArray(r))throw new Error(`Invalid array value for ${t.type}: ${r}`);return r.map(e=>this.convertNumber(t,e));case"stringArray":if(!Array.isArray(r))throw new Error(`Invalid value for ${t.type}: ${r}`);return r;case"reference":if(!t.factoryName)throw new Error(`${t.valuePath}: no targetFactory`);return e.application.getFactoryByName(t.factoryName).resolveReferenceId(e,r);case"uuid":case"binaryStream":return this.convertBinary(t,r);default:throw new Error(`${t.valuePath}: cannot convert type ${t.type} to SQL`)}}static getParameterValues(e,t,r){const n=e.tenantId?{...r,context:{tenantId:e.tenantId}}:r;return Promise.all(t.map(t=>void 0!==t.literalValue?t.literalValue:this.getParameterValue(e,t,_.get(n,t.valuePath))))}convertArg(e,t){if(!t.type)throw new Error(`${e}: cannot convert arg: type is missing`);return this.addSqlParameter({valuePath:e,type:t.type,column:t.property?.column,factoryName:t.factory?.name})}static convertDefaultValue(e){if(null==e)return"NULL";if("number"==typeof e)return String(e);if("boolean"==typeof e)return e?"TRUE":"FALSE";return(0,xtrem_ts_to_sql_1.quote)(String(e))}static jsonCast(e,t){if(Array.isArray(t))return`COALESCE((select array_agg(x) from jsonb_array_elements_text(${e}) x),ARRAY[]::text[])`;switch(typeof t){case"boolean":return`(${e})::TEXT::BOOLEAN`;case"number":return`(${e})::TEXT::NUMERIC`;case"string":return e.endsWith("->>0)::TEXT")?e:`((${e})->>0)::TEXT`;default:throw new Error("invalid JSON value type: "+typeof t)}}convertRegExpOps(e,t){const r=this.addSqlParameter({valuePath:e,subPath:"_regex",type:"string"}),n=this.addSqlParameter({valuePath:e,subPath:"_options",type:"string"});return this.regexConverter.convertRegex(r,n,t,{isParam:true}).sql}convertValue(e,t){const r=this.convertArg(e,t),n="json"===t.type||"jsonReference"===t.type?SqlConverter.jsonCast(t.sql,r):t.sql,a=`${n} = ${r}`;return t.isNullable?`(${a} OR (${n} IS NULL AND ${r} is NULL))`:a}static checkArray(e,t){if(!Array.isArray(t))throw new Error(`${e.path}: values is not an array`)}convertXinFilter(e,t,r,n){if(t.type?.endsWith("Array"))throw new Error(`${t.path}: _in and _nin operators not supported on array types (checking if inside an array of arrays)`);SqlConverter.checkArray(t,r[n]);const a=this.addSqlParameter({valuePath:`${e}.${n}`,type:t.type||"string",column:t.property?.column,isArray:true,factoryName:t.factory?.name}),s=`(${`(${t.sql} = ANY(${a}))`} ${` OR (${t.sql} IS NULL AND (TRUE = ANY (SELECT unnest(${a}) IS NULL))) `})`;return"_in"===n?s:`NOT COALESCE(${s}, FALSE)`}convertAndFilter(e,t,r){SqlConverter.checkArray(t,r);const n=r.map((r,n)=>this.convertFilterObject(`${e}._and.${n}`,t,r));return SqlConverter.and(n)}convertOrFilter(e,t,r){SqlConverter.checkArray(t,r);const n=r.map((r,n)=>this.convertAnyFilter(`${e}._or.${n}`,t,r));return SqlConverter.or(n)}convertNorFilter(e,t,r){SqlConverter.checkArray(t,r);const n=r.map((r,n)=>this.convertAnyFilter(`${e}._nor.${n}`,t,r));return SqlConverter.and(n.map(e=>`(NOT (${e}))`))}convertModFilter(e,t){const r=this.convertArg(`${e}._mod.0`,t),n=this.convertArg(`${e}._mod.1`,t);return`(${t.sql} % ${r} = ${n})`}convertNotFilter(e,t,r){return`NOT (${this.convertFilterObject(`${e}._not`,t,r)})`}convertBinaryOpFilter(e,t,r,n){const a=binaryOps[n];if(null==r[n]){if("_eq"===n)return`${t.sql} IS NULL`;if("_ne"===n)return`${t.sql} IS NOT NULL`;if("_gt"===n)return`${t.sql} IS NOT NULL`;if("_gte"===n)return"TRUE";if("_lt"===n)return"FALSE";if("_lte"===n)return`${t.sql} IS NULL`}let s,o;switch(t.type){case"integerArray":case"enumArray":case"referenceArray":case"stringArray":if("_contains"===n)s=this.addSqlParameter({valuePath:`${e}.${n}`,type:t.type.replace("Array",""),factoryName:t.factory?.name}),o=t.sql;else s=t.sql,o=this.convertArg(`${e}.${n}`,t);break;case"integerRange":case"decimalRange":case"dateRange":case"datetimeRange":if("_contains"===n)s=t.sql,o=this.addSqlParameter({valuePath:`${e}.${n}`,type:t.type.replace("Range","")});else s=t.sql,o=this.convertArg(`${e}.${n}`,t);break;case"json":case"jsonReference":s="_contains"===n?t.sql:SqlConverter.jsonCast(t.sql,r[n]),o=this.convertArg(`${e}.${n}`,t);break;default:s=t.sql,o=this.convertArg(`${e}.${n}`,t)}return a(t,s,o)}convertOperatorFilter(e,t,r,n){if(binaryOps[n])return this.convertBinaryOpFilter(e,t,r,n);const a=r[n];switch(n){case"_in":case"_nin":return this.convertXinFilter(e,t,r,n);case"_and":return this.convertAndFilter(e,t,a);case"_or":return this.convertOrFilter(e,t,a);case"_nor":return this.convertNorFilter(e,t,a);case"_mod":return this.convertModFilter(e,t);case"_not":return this.convertNotFilter(e,t,a);case"_regex":return!a?"":this.convertRegExpOps(e,t);case"_options":if(r._options&&!r._regex)throw new Error(`${t.path}: _options without _regex`);return"";case"_fn":if("string"!=typeof a)throw new Error(`${t.path}: _fn value is not a string`);return this.convertFunctionBody(t,a).sql;default:throw new xtrem_shared_1.DataInputError(`${t.path}: invalid operator: ${n}`)}}convertFilterObject(e,t,r){const n=Object.keys(r);if(0===n.length){if(t.parent)this.makeAliasAndJoin(t);return"TRUE"}const a=n.filter(e=>void 0!==r[e]).map(n=>{if("_"===n[0]&&!system_properties_1.SystemProperties.isSystemOrTechnicalProperty(n))return this.convertOperatorFilter(e,t,r,n);return this.convertPropertyFilter(e,t,r,n)}).filter(e=>!!e);return SqlConverter.and(a)}convertFunctionValue(e,t){const r=this.convertFunction(t).sql,n="json"===e.type||"jsonReference"===e.type?SqlConverter.jsonCast(e.sql,r):e.sql,a=`${n} = ${r}`;return e.isNullable?`(${a} OR (${n} IS NULL AND ${r} is NULL))`:a}convertJoinLiteralValue(e,t){const r=this.convertLiteral(t.value).sql,n="json"===e.type||"jsonReference"===e.type?SqlConverter.jsonCast(e.sql,r):e.sql,a=`${n} = ${r}`;return e.isNullable?`(${a} OR (${n} IS NULL AND ${r} is NULL))`:a}convertAnyFilter(e,t,r){if(r instanceof RegExp)return this.convertAnyFilter(e,t,{_regex:r.source,_options:r.flags});if(r instanceof ts_api_1.Node)return this.convertFilterObject(e,t,{_id:r._id});if("function"==typeof r)return this.convertFunctionValue(t,r);if(r instanceof ts_api_1.JoinLiteralValue)return this.convertJoinLiteralValue(t,r);if(isFilterObject(r))return this.convertFilterObject(e,t,r);return this.convertValue(e,t)}convertFilter(e,t,r){if("string"==typeof t)return t;if("function"==typeof t){const e=super.convertFunction(t);if(r&&"json"===e.type)return sql_resolver_1.SqlResolver.castFromJson(e.sql,r.type);if("reference"===e.type&&e.property&&!e.property.isStored)return this.walk(e,"_id").sql;return e.sql}if(t instanceof ts_api_1.JoinLiteralValue)return this.convertLiteral(t.value).sql;if(!(t&&"object"==typeof t))throw new Error(`filter is not an object: ${t&&typeof t}`);const n={factory:this.rootFactory,type:"reference",sql:"t0",path:"this",alias:"t0",collation:this?.context?.collation};return this.convertFilterObject(e,n,t)}convertWhere(e){return this.convertFilter("where",e)}convertFilters(e){return e.map((e,t)=>this.convertFilter(`filters.${t}`,e))}convertOrderBy(e){const t=[],convertOne=(e,r,n)=>{Object.keys(n).forEach(a=>{const s=[...r,a],o=this.withThisResultScope(e,()=>super.walk(e,a)),i=n[a];if(i&&"object"==typeof i)convertOne(o,s,i);else if(-1===i||1===i){if(!o.property)throw new Error(`${s}: 'Missing property in result.`);t.push({property:o.property,path:s,direction:i,sql:o.sql,columnAlias:sql_resolver_1.SqlResolver.makeColumnAlias(o.columnAlias??"")})}else throw new Error(`${s}: invalid value: ${i}`)})},r=super.convertThisExpression();return convertOne(r,[],e),t}getJsonAggSql(e,t){if(0===e.length)return`json_agg(${t}._id)`;return`json_agg(json_build_object(${e.map(e=>`${this.addSqlParameter({valuePath:"",type:"string",literalValue:e.columnAlias})}::TEXT, ${e.sql}`).join(", ")}))`}convertCollectionSubPaths(e,t){if("collection"!==e.property?.type)throw new xtrem_shared_1.LogicError(`parent property is not a collection: ${e.property?.type}`);const r={...e};r.columnAlias=sql_resolver_1.SqlResolver.makeColumnAlias(`${e.parent?.alias}.${e.property?.name}`);const n=this.withSubQueryScope(()=>{if(this.makeAliasAndJoin(r),!r.alias)throw new xtrem_shared_1.LogicError("no alias");const e=this.convertOutputPaths(t,{...r,type:"reference"});return{jsonAggSql:this.getJsonAggSql(e,r.alias),subColumns:e}},void 0),a=this.addSqlParameter({valuePath:"",type:"string",literalValue:"[]"});return r.sql=`COALESCE(\n                (SELECT ${n.jsonAggSql}\n                    FROM  ${n.aliases}\n                    WHERE ${n.joinCondition}),\n                ${a}::json)`,r.subColumns=n.subColumns,r}convertOutputPath(e,t=this.convertThisExpression()){let r=t;const n=e.compute;if((n?e.path.slice(0,-1):e.path).forEach(e=>{r=super.walk(r,e)}),n)r=this.withThisResultScope(r,()=>this.convertFunction(n));else if(e.subPaths)r=this.convertCollectionSubPaths(r,e.subPaths);else if(!r.sql&&r.property?.isReferenceProperty())super.walk(r,"_id"),r.columnAlias=sql_resolver_1.SqlResolver.makeColumnAlias(r.sql);return{...r,payloadPath:e.path}}convertOutputPaths(e,t=this.convertThisExpression()){return e.map(e=>this.convertOutputPath(e,t))}convertAggregateGroups(e,t){return t.map(t=>sql_resolver_1.SqlResolver.resolveAggregate(e,this.convertOutputPath({path:t.path}),t.groupedBy))}convertAggregate(e,t){if(!t)return{};return{groups:t.groups.map(t=>sql_resolver_1.SqlResolver.resolveAggregate(e,this.convertOutputPath({path:t.path}),t.groupedBy)),values:t.values.map(t=>sql_resolver_1.SqlResolver.resolveAggregate(e,this.convertOutputPath({path:t.path}),t.operator))}}getConfigurationValue(e){return context_1.Context.getConfigurationValue(e)}convertDelegatesTo(e,t){const{reference:r,childProperty:n}=t.getDelegatingInfo(),a=this.walk(e,r.name);return this.walk(a,n.name)}convertJoin(e,t,r){const n=e.parent;if(!n)throw new xtrem_shared_1.LogicError("no parent");const a=[],s=[];Object.keys(r).forEach(o=>{const i=r[o],l=typeof r[o],c=this.walk(e,o);if("object"===l&&!(i instanceof ts_api_1.JoinLiteralValue))throw new Error("NYI: nested join");else if(s.push(c.sql),"string"==typeof i)a.push(this.walk(n,i).sql);else a.push(this.withThisResultScope(n,()=>this.convertFilter(t,i,c)))}),e.sql=`${e.alias}._id`,e.join=xtrem_ts_to_sql_1.Walker.createJoin({alias:n.alias,sqls:a},{alias:e.alias,sqls:s},{withTenantId:!e.factory?.isSharedByAllTenants,isNullable:!!e.property?.isNullable||!!n.join?.isNullable})}createReferenceJoin(e,t){const r=e.property?.isReferenceProperty()&&e.property.decorator.join;if(!r){if(super.createReferenceJoin(e,t),t?.parent?.factory.isAbstract&&e?.join?.condition){const r=this.resolveLiteral(e.factory.name);e.join.condition=SqlConverter.and([e.join.condition,`${t.parent.alias}._constructor=${r}`])}return}this.convertJoin(e,e.path,r)}createCollectionJoin(e,t){const r=e.property?.isCollectionProperty()&&e.property.decorator.join;if(!r)return void super.createCollectionJoin(e,t);if(e.skipJoin)return void(this.scopeAlias={tableName:this.resolver.resolveTableName(e.factory),alias:e.alias});this.convertJoin(e,e.path,r),this.scopeAlias={tableName:this.resolver.resolveTableName(e.factory),alias:e.alias,join:e.join}}}exports.SqlConverter=SqlConverter;
//# sourceMappingURL=sql-converter.js.map