import { AnyValue } from '@sage/xtrem-shared';
import { ConversionResultType, GenericConversionResult } from '@sage/xtrem-ts-to-sql';
import { Column } from '..';
import { Property } from '../../properties';
import { NodeFactory } from '../../runtime/node-factory';
export type ConversionResult = GenericConversionResult<NodeFactory, Property>;
/**
 * OutputColumn is a conversion result for an element which is returned by a SQL query.
 * It may be an element of the select list, or a group or value returned by an aggregate query.
 */
export interface OutputColumn extends ConversionResult {
    /** Path (array of property names) in the result payload */
    payloadPath?: string[];
    /** Output columns of this column's value (only if this is a collection output column) */
    subColumns?: OutputColumn[];
}
export interface AggregateResult {
    groups?: OutputColumn[];
    values?: OutputColumn[];
}
/**
 * Describes a SQL statement parameter
 */
export interface SqlParameter {
    /** The path to the parameter's value */
    valuePath: string;
    /** The type of the parameter's value */
    type: ConversionResultType | 'encryptedString';
    /** Optional factory name, if the value is a reference */
    factoryName?: string;
    /** The column, if the value is a column value */
    column?: Column;
    /** Sub-path for composite value like regex */
    subPath?: string;
    /** Is the value an array ? */
    isArray?: boolean;
    /** Value, only for literals */
    literalValue?: AnyValue;
}
export interface SqlConverterOptions {
    quiet?: boolean;
}
//# sourceMappingURL=sql-converter.d.ts.map