/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.garbageCollectContentAddressableTable=garbageCollectContentAddressableTable,exports.garbageCollectContentAddressableTables=garbageCollectContentAddressableTables;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),loggers_1=require("../../runtime/loggers");function getGcFunctionName(e){return`pg_temp.gc_${e}`}function getTenantIdCondition(e,n){const t="string"==typeof n&&""!==n;if(e)return t?`WHERE _tenant_id = '${n}'`:"";return t?`AND _tenant_id = '${n}'`:""}function getCreateGcFunctionSql(e,n,t){return`\n    CREATE OR REPLACE FUNCTION ${getGcFunctionName(n)}() RETURNS INT8 AS $$\n    DECLARE\n        r RECORD;\n        deleted INT8;\n        total INT8;\n        done INT8;\n    BEGIN\n        total = (SELECT COUNT(*) FROM ${e}.${n} ${getTenantIdCondition(true,t)});\n        deleted = 0;\n        done = 0;\n        FOR r IN\n            SELECT _id FROM ${e}.${n} ${getTenantIdCondition(true,t)}\n        LOOP\n            BEGIN\n                DELETE FROM ${e}.${n} WHERE _id = r._id ${getTenantIdCondition(false,t)};\n                deleted = deleted + 1;\n                RAISE NOTICE '${n} table gc: deleted %', r._id;\n            EXCEPTION WHEN foreign_key_violation THEN NULL;\n            done = done + 1;\n            IF MOD(done, 1000) = 0 OR done = total THEN\n                RAISE INFO '${n} table gc: % processed % out of %', CONCAT(ROUND(100 * done / total), '%'), done, total;\n            END IF;\n            END;\n        END LOOP;\n        return deleted;\n    END $$ LANGUAGE plpgsql;\n    `}async function garbageCollectContentAddressableTable(e,n,t){const a=n.tableName;if(!a)throw n.logicError("no table name");const o=getCreateGcFunctionSql(e.application.schemaName,a,t);await e.executeSql(o,[],{allowUnsafe:true});const r=getGcFunctionName(a);return e.executeSql(`SELECT * FROM ${r}()`,[])}async function garbageCollectContentAddressableTables(e,n){await(0,xtrem_async_helper_1.asyncArray)(e.application.getAllSortedFactories().filter(e=>e.isContentAddressable)).forEach(async t=>{const a=await e.runInWritableContext(e=>garbageCollectContentAddressableTable(e,t,n));loggers_1.loggers.application.info(`${t.tableName}: ${JSON.stringify(a)} records purged by GC`)})}
//# sourceMappingURL=gc-content-addressable-tables.js.map