export interface HtmlSanitizerOptions {
    changes?: {
        records?: MutationRecord[];
        removed?: any[];
    };
    throwIfModified?: boolean;
    ignoreTemplating?: boolean;
}
export interface SanitizeResult {
    html?: string;
    error?: string;
    details?: string[];
}
/**
 * Async function to sanitize an html content.
 * The underlying code is not async so the function use a worker thread to make it async
 * @param html
 * @param options
 * @returns
 */
export declare function htmlSanitizer(html: string, options?: HtmlSanitizerOptions): Promise<string>;
//# sourceMappingURL=xss.d.ts.map