export type HtmlSanitizerOptions = import("./xss.ts").HtmlSanitizerOptions;
export type SanitizeResult = import("./xss.ts").SanitizeResult;
export type TransformedData = {
    html: string;
    firstTag?: string | undefined;
    templates: Record<string, string>;
};
export type ChildNames = {
    removed: string[];
    added: string[];
};
/**
 * Sanitiezs the content of an html to prevent from XSS attacks
 * @param {string} htmlContent
 * @param {HtmlSanitizerOptions} [options]
 * @returns {SanitizeResult}
 */
export function sanitizeHtml(htmlContent: string, options?: HtmlSanitizerOptions): SanitizeResult;
//# sourceMappingURL=xss-worker.d.ts.map