/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.TlsHelper=void 0;const xtrem_config_1=require("@sage/xtrem-config"),fs=require("fs/promises"),_=require("lodash"),https=require("node:https"),fsp=require("path/posix"),tls=require("tls"),loggers_1=require("./loggers");class TlsHelper{static{this.initialized=false}static{this.extraCaPem=[]}static{this.interopHttpsAgent=null}static{this.deviceHttpsAgent=null}static initTlsLayer(){if(this.initialized)return;const e=tls.createSecureContext;tls.createSecureContext=t=>{const r=e(t);return this.extraCaPem.forEach(e=>{r.context.addCACert(e.trim())}),r},this.initialized=true}static addCaFile(e,t){if(e.startsWith("-----BEGIN "))return void loggers_1.logger.warn(`Ignoring CA file '${e}': it seems to be a PEM content`);if(t.includes(e))return void loggers_1.logger.warn(`Ignoring CA file '${e}': it has already been added`);t.push(e)}static async loadExtraConfig(){await TlsHelper.loadExtraCaCert(),TlsHelper.setHttpsAgent(),TlsHelper.setDeviceHttpsAgent()}static getTlsConfig(){const e=xtrem_config_1.ConfigManager.current.server;if(!e?.ssl)return{};return{ca:e.ssl.ca,cert:e.ssl.cert,key:e.ssl.key}}static async loadExtraCaCert(){const e=xtrem_config_1.ConfigManager.current.security?.tls,t=xtrem_config_1.ConfigManager.current.server,r=t?.sslShallowCopy,s=[];if(e?.extraCaFiles){const t=Array.isArray(e.extraCaFiles)?e.extraCaFiles:[e.extraCaFiles];s.push(...t)}if(r){if("string"==typeof r.ca)this.addCaFile(r.ca,s);if("string"==typeof r.cert){const e=fsp.dirname(r.cert),t=fsp.join(e,"ca.crt");this.addCaFile(t,s)}}const i=[];if(s.length>0)await Promise.all(s.map(async e=>{i.push(...await this.loadPemFromFile(e))}));xtrem_config_1.ConfigManager.emitter.emit("extraCa",s);const a=s.map(e=>`'${e}'`);loggers_1.logger.info(`loading ${i.length} extra CA from: [${a}]`),this.extraCaPem=i}static async loadPemFromFile(e){try{return((await fs.readFile(e,{encoding:"ascii"})).replace(/\r\n/g,"\n").match(/-----BEGIN CERTIFICATE-----[A-Za-z0-9+/=\r\n]*-----END CERTIFICATE-----/g)||[]).map(e=>e.trim())}catch(t){return loggers_1.logger.error(`Cannot load CA '${e}': ${t.message}]`),[]}}static registerTlsChangeListener(e,t,r){const s=`Replacing secure context of the ${r} server`;xtrem_config_1.ConfigManager.emitter.addListener("tlsChange",r=>{const i=_.property(t)(xtrem_config_1.ConfigManager.current);if(i&&r===t)setTimeout(()=>{loggers_1.logger.info(s);try{e.setSecureContext(i),TlsHelper.loadExtraConfig().catch(e=>{loggers_1.logger.error(`[FAILED] reloading TLS extra config, ${s}: ${e.message}`)}),xtrem_config_1.ConfigManager.emitter.emit("tlsApply",t,i)}catch(e){loggers_1.logger.error(`[FAILED] ${s}: ${e.message}`)}},500)})}static getInteropHttpsAgent(){return this.interopHttpsAgent}static setHttpsAgent(){const e=this.getTlsConfig();if(this.interopHttpsAgent=null,e.ca&&e.cert&&e.key)this.interopHttpsAgent=new https.Agent(e)}static getDeviceHttpsAgent(){return this.deviceHttpsAgent}static setDeviceHttpsAgent(){const e=this.getDeviceTlsConfig();if(this.deviceHttpsAgent=null,e.ca&&e.cert&&e.key)this.deviceHttpsAgent=new https.Agent(e)}static getDeviceTlsConfig(){const e=xtrem_config_1.ConfigManager.current.authentication;if(!e?.ssl)return{};return{key:e.ssl.key,cert:e.ssl.cert,ca:e.ssl.ca}}static isTlsSocket(e){return void 0!==e.getPeerCertificate}static getPeerCertificate(e){if(!this.isTlsSocket(e.socket))return null;return e.socket.getPeerCertificate()}}exports.TlsHelper=TlsHelper;
//# sourceMappingURL=tls.js.map