import { ServerConfig } from '@sage/xtrem-shared';
import { Request } from 'express';
import * as https from 'node:https';
import * as tls from 'tls';
export interface InternalServerConfig extends ServerConfig {
    sslShallowCopy?: tls.TlsOptions;
}
export declare class TlsHelper {
    private static initialized;
    private static extraCaPem;
    private static interopHttpsAgent;
    private static deviceHttpsAgent;
    static initTlsLayer(): void;
    private static addCaFile;
    static loadExtraConfig(): Promise<void>;
    private static getTlsConfig;
    private static loadExtraCaCert;
    private static loadPemFromFile;
    static registerTlsChangeListener(server: tls.Server, configPath: string, name: string): void;
    static getInteropHttpsAgent(): https.Agent | null;
    private static setHttpsAgent;
    static getDeviceHttpsAgent(): https.Agent | null;
    private static setDeviceHttpsAgent;
    private static getDeviceTlsConfig;
    private static isTlsSocket;
    static getPeerCertificate(req: Request): tls.PeerCertificate | null;
}
//# sourceMappingURL=tls.d.ts.map