/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.SageIdClient=void 0;const xtrem_log_1=require("@sage/xtrem-log"),axios_1=require("axios"),logger=xtrem_log_1.Logger.getLogger(__filename,"sage-id");class SageIdClient{static errorResponseInterceptor(e){if(logger.error(`Sage ID error: ${e}`),e.response?.data)logger.debug(()=>`Sage ID Error response interceptor${JSON.stringify(e.response?.data,null,4)}`);return e}static successResponseInterceptor(e){if(logger.debug(()=>`Sage ID response: ${e.config.method} ${e.config.baseURL}${e.config.url} ${e.status}`),logger.debug(()=>`Sage ID Headers:\n${JSON.stringify(e.headers,null,4)}`),e?.data)logger.debug(()=>JSON.stringify(e?.data,null,4));return e}static requestInterceptor(e){if(logger.debug(()=>`Sage ID request: ${e.method} ${e.baseURL}${e.url}`),logger.debug(()=>`Sage ID Headers:\n${JSON.stringify(e.headers,null,4)}`),e?.data)logger.debug(()=>`Sage ID Body:\n${JSON.stringify(e?.data,null,4)}`);return e}static async getToken(e){const t=axios_1.default.create({baseURL:e.url,headers:{"Content-Type":"application/json",Accept:"application/json"}});t.interceptors.response.use(this.successResponseInterceptor,this.errorResponseInterceptor),t.interceptors.request.use(this.requestInterceptor);const r=await t.post("/oauth/token",new URLSearchParams({client_secret:e.clientSecret,client_id:e.clientId,grant_type:"client_credentials",audience:e.audience}).toString(),{headers:{"content-type":"application/x-www-form-urlencoded"}});if(200!==r.status)throw new Error(`Sage ID: Unexpected status code ${r.status}`);if(!r.data?.access_token)throw new Error("Sage ID: No access token found in auth response");return{accessToken:r.data.access_token,expiresIn:r.data.expires_in??0}}static formatBearerAuthorization(e){return`Bearer ${e}`}}exports.SageIdClient=SageIdClient;
//# sourceMappingURL=sage-id-client.js.map