/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.setup=setup;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_config_1=require("@sage/xtrem-config"),_=require("lodash"),context_vault_1=require("../runtime/context-vault"),loggers_1=require("./loggers"),tls_1=require("./tls");let initialized=false;async function setup(){if(null==xtrem_config_1.ConfigManager.current)throw new Error("Config must be loaded first");if(initialized)return;initialized=true,await asyncLoadSecret(xtrem_config_1.ConfigManager.current),await tls_1.TlsHelper.loadExtraConfig(),loggers_1.logger.info("Initializing security layer..."),xtrem_config_1.ConfigManager.emitter.addListener("loaded",()=>{asyncLoadSecret(xtrem_config_1.ConfigManager.current).then(()=>tls_1.TlsHelper.loadExtraConfig()).catch(e=>loggers_1.logger.error(e))}),tls_1.TlsHelper.initTlsLayer(),loggers_1.logger.info("Security layer initialized")}function collectSecrets(e,r,t){_.forIn(e,(i,o)=>{if("string"==typeof i){if(i.startsWith("@secret/"))r.push({obj:e,key:o,placeholder:i,path:[...t,o]})}else if(_.isArray(i))i.forEach((e,i)=>{if(_.isObject(e))collectSecrets(e,r,[...t,o,`[${i}]`])});else if(_.isObject(i))collectSecrets(i,r,[...t,o])})}async function asyncLoadSecret(e){const r=[];collectSecrets(e,r,[]),await(0,xtrem_async_helper_1.asyncArray)(r).forEach(async e=>{const{obj:r,key:t,placeholder:i,path:o}=e;loggers_1.logger.info(`Loading secret for '${o.join(".")}' with placeholder '${i}'`),r[t]=await context_vault_1.ContextVault.getConfigSecretValue(i)})}
//# sourceMappingURL=loader.js.map