/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.CopilotClient=void 0;const xtrem_config_1=require("@sage/xtrem-config"),xtrem_log_1=require("@sage/xtrem-log"),axios_1=require("axios"),core_hooks_1=require("../runtime/core-hooks"),sage_id_client_1=require("./sage-id-client"),logger=xtrem_log_1.Logger.getLogger(__filename,"copilot");class CopilotClient{#e;#t=0;#o={};#s={};#r=null;static errorResponseInterceptor(e){if(logger.error(`Copilot error: ${e}`),e.response?.data)logger.debug(()=>`Copilot Error response interceptor${JSON.stringify(e.response?.data,null,4)}`);return e}static successResponseInterceptor(e){if(logger.debug(()=>`Copilot response: ${e.config.method} ${e.config.baseURL}${e.config.url} ${e.status}`),logger.debug(()=>`Headers:\n${JSON.stringify(e.headers,null,4)}`),e?.data)logger.debug(()=>JSON.stringify(e?.data,null,4));return e}static requestInterceptor(e){if(logger.debug(()=>`Copilot request: ${e.method} ${e.baseURL}${e.url}`),logger.debug(()=>`Copilot Headers:\n${JSON.stringify(e.headers,null,4)}`),e?.data)logger.debug(()=>`Copilot Body:\n${JSON.stringify(e?.data,null,4)}`);return e}async getSageIdAccessToken(e){if(Date.now()-3e5>this.#t){const t=await sage_id_client_1.SageIdClient.getToken({url:e.oauthEndpointUrl,clientId:e.clientId,clientSecret:e.clientSecret,audience:e.audience});this.#e=t.accessToken,this.#t=Date.now()+1e3*t.expiresIn}return this.#e}async getGmsToken(e){if(!this.#r)this.#r=setInterval(()=>{const e=Date.now()-12e4;if(Object.keys(this.#s).forEach(t=>{if(e>this.#s[t])delete this.#o[t],delete this.#s[t]}),this.#r&&0===Object.keys(this.#s).length)clearInterval(this.#r),this.#r=null},36e5);const t=Date.now()-12e4,o=xtrem_config_1.ConfigManager.current.copilot;if(!o)throw new Error("copilot config not found");const s=(await e.loginUser)?.userName??(await e.loginUser)?.email,r=(await e.user)?.userName??(await e.user)?.email,n=s??r,{tenantId:i}=e;if(!n&&!i)throw new Error("No user or tenant id found");const a=`${n??""}${i?"@":""}${i??""}`;if(t>(this.#s[a]??0)){const e=axios_1.default.create({baseURL:o.serviceUrl,headers:{"Content-Type":"application/json",Accept:"application/json"}});e.interceptors.response.use(CopilotClient.successResponseInterceptor,CopilotClient.errorResponseInterceptor),e.interceptors.request.use(CopilotClient.requestInterceptor);const t=await this.getSageIdAccessToken(o),s=await e.post("/token",{user_id:a},{headers:{"Content-Type":"application/json",Authorization:sage_id_client_1.SageIdClient.formatBearerAuthorization(t)}});if(200!==s.status)throw new Error(`Copilot: Unexpected status code ${s.status}`);if(!s.data?.access_token)throw new Error("Copilot: No access token found in auth response");this.#o[a]=s.data.access_token,this.#s[a]=Date.now()+1e3*(s.data.expires_in??0)}return{token:this.#o[a],expiration:this.#s[a]}}static getToken(e){if(!CopilotClient.client)CopilotClient.client=new CopilotClient;return CopilotClient.client.getGmsToken(e)}static async isEnabled(e){const t=core_hooks_1.CoreHooks.getSageAiManager();return await t.isSageAiEnabled(e)&&!!xtrem_config_1.ConfigManager.current.copilot?.serviceUrl}}exports.CopilotClient=CopilotClient;
//# sourceMappingURL=copilot-client.js.map