/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.NodeFactory=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_i18n_1=require("@sage/xtrem-i18n"),xtrem_shared_1=require("@sage/xtrem-shared"),xtrem_toposort_1=require("@sage/xtrem-toposort"),crypto=require("crypto"),_=require("lodash"),decorator_utils_1=require("../decorators/decorator-utils"),node_state_1=require("../node-state"),state_get_value_1=require("../node-state/state-get-value"),state_intern_1=require("../node-state/state-intern"),properties_1=require("../properties"),create_property_1=require("../properties/create-property"),mapper_1=require("../sql/mapper"),schema_1=require("../sql/schema"),read_table_sql_context_1=require("../sql/sql-context/read-table-sql-context"),naming_1=require("../sql/statements/naming"),ts_api_1=require("../ts-api"),types_1=require("../types"),utils_1=require("../utils"),context_1=require("./context"),core_hooks_1=require("./core-hooks"),loaded_once_1=require("./loaded-once"),loggers_1=require("./loggers"),node_factory_cache_1=require("./node-factory-cache"),node_factory_utils_1=require("./node-factory-utils"),system_properties_1=require("./system-properties"),utils_2=require("./utils");(0,loaded_once_1.loadedOnce)("node-factory");const logger=loggers_1.loggers.nodeFactory,loggerApplication=loggers_1.loggers.application;class NodeFactory{#e;#t;#r;#s;constructor(e,t,r){if(this._naturalKey=null,this.decoratorWarnings={},this.properties=[],this.lazyLoadedProperties=[],this.storedEncryptedProperties=[],this.mutableProperties=[],this.propertiesByName={},this.keyProperties=[],this.mutations=[],this.queries=[],this.notificationListeners=[],this.messageListeners=[],this.events={},this.publishedSystemProperties={},this.publishedInputSystemProperties=[],this.referringProperties=[],this.impactingServiceOptions=[],this._taggedProperties={},this._subFactories=[],this.staticMethods={},this.nonStaticMethods={},this.systemPropertyDefiningPackage={},this.#e=[],this.#t=[],this.#r=[],this.#s=[],this.#i=null,logger.verbose(()=>`${e.name}.${t.name}: creating node factory`),this._package=e,this.nodeConstructor=t,!r.properties)r.properties=[];this.decorators=r,Object.assign(this.decorators,this.decorators.node),this.nodeDecorator=r.node,core_hooks_1.CoreHooks.communicationManager.extendClassDecorator(this),this.cloneDecoratorsAttributes(),this.cache=new node_factory_cache_1.NodeFactoryCache(this)}registerEvents(){Object.keys(this.nodeDecorator).forEach(e=>{switch(e){case"prepare":case"prepareBegin":case"prepareEnd":case"createEnd":case"controlBegin":case"controlEnd":case"controlDelete":case"saveBegin":case"saveEnd":case"deleteBegin":case"deleteEnd":{const t=this.nodeDecorator[e];if(!t)return;if("function"!=typeof t)throw this.systemError(`${e}: event is not a function`);this.events[e]=async function chained(...e){await t.apply(this,e)};break}case"getFilters":this.events[e]=this.nodeDecorator[e]}})}cloneDecoratorsAttributes(){if(this.mutations=this.decorators.mutations?[...this.decorators.mutations]:[],this.queries=this.decorators.queries?[...this.decorators.queries]:[],this.notificationListeners=this.decorators.notificationListeners?[...this.decorators.notificationListeners]:[],this.messageListeners=this.decorators.messageListeners?[...this.decorators.messageListeners]:[],this.nodeDecorator.indexes)this.indexes=[...this.nodeDecorator.indexes];this.storage=this.nodeDecorator.storage,this.registerEvents()}verifyNaturalKey(e){if(!e.isNaturalKey)return;if(!e.isUnique)throw new xtrem_shared_1.SystemError(`${this.name}.${e.name} natural key must be a unique index.`);const t=Object.keys(e.orderBy).map(e=>this.propertiesByName[e]).filter(e=>!e?.isPublished&&void 0===e.defaultValue);if(t.length)throw new xtrem_shared_1.SystemError(`Natural key index ${this.name}.${e.name} must have these properties published or assigned a defaultValue [${t.map(e=>e.name)}]`)}ensureNoMultipleUniqueIndexes(){(0,node_factory_utils_1.ensureNoMultipleUniqueIndexes)(this)}verifyIndex(e){if(e.isVerified)return;if(e.isVerified=true,"external"===this.storage)return;this.verifyNaturalKey(e);const t=Object.keys(e.orderBy).map(e=>this.propertiesByName[e]),r=t.filter(e=>e.invalidForIndexReason);if(r.length>0)throw new xtrem_shared_1.SystemError(`${this.name}.${e.name} contains properties with types not allowed in an index [${r.map(e=>`${e.name} (${e.invalidForIndexReason})`)}]`);const s=t.filter(e=>e?.isNullable&&!e?.allowedInUniqueIndex);if(s.length>0)throw new xtrem_shared_1.SystemError(`${this.name}.${e.name} contains nullable properties not allowed in this unique index. Please consider using 'allowedInUniqueIndex: true' decorator attribute for properties [${s.map(e=>e.name)}] among [${Object.keys(e.orderBy)}]`);const i=t.filter(e=>e.isInherited);if(i.length>0)throw new xtrem_shared_1.SystemError(`${this.name}.${e.name} contains the following properties from an inherited node: ${i.map(e=>e.name).join(",")}`)}invalidateCache(e){return this.cache.invalidate(e)}get defaultOrderByClauses(){return[{path:["_id"],direction:1,property:system_properties_1.SystemProperties.idProperty(this),sql:"t0._id"}]}get table(){return this._table}set table(e){this._table=e}get externalStorageManager(){return this.nodeDecorator.externalStorageManager}get serviceOptions(){return this.nodeDecorator.serviceOptions?.()||[]}get isAbstract(){return!!this.nodeDecorator.isAbstract}get isRootAbstractFactory(){return this.isAbstract&&!this.baseFactory}get isVitalReferenceChild(){return!!this.nodeDecorator.isVitalReferenceChild||!!this.baseFactory?.isVitalReferenceChild}get isVitalCollectionChild(){return!!this.nodeDecorator.isVitalCollectionChild||!!this.baseFactory?.isVitalCollectionChild}get isAssociationCollectionChild(){return!!this.nodeDecorator.isAssociationCollectionChild||!!this.baseFactory?.isAssociationCollectionChild}get isVitalChild(){return this.isVitalReferenceChild||this.isVitalCollectionChild}get isAssociationChild(){return!!this.nodeDecorator.isAssociationCollectionChild||!!this.nodeDecorator.isAssociationReferenceChild||!!this.baseFactory?.isAssociationChild}get isPublished(){return!!this.nodeDecorator.isPublished}get isCached(){return!!this.nodeDecorator.isCached||!!this.baseFactory?.isCached}get isVitallyCached(){return this.isVitalChild?this.vitalParentFactory.isCached:this.isCached}get canRead(){return!!this.nodeDecorator.canRead||this.isVitalChild&&this.vitalParentFactory.canRead}get canCreate(){if(this.baseFactory?.canCreate)return true;const e=!!this.nodeDecorator.canCreate;return this.externalStorageManager?.canCreate?this.externalStorageManager.canCreate(e):e}get canUpdate(){if(this.baseFactory?.canUpdate)return true;const e=!!this.nodeDecorator.canUpdate;return this.externalStorageManager?.canUpdate?this.externalStorageManager.canUpdate(e):e}get canDelete(){if(this.baseFactory?.canDelete)return true;const e=!!this.nodeDecorator.canDelete;return this.externalStorageManager?.canDelete?this.externalStorageManager.canDelete(e):e}get canDuplicate(){if(this.baseFactory?.canDuplicate)return true;return!!this.nodeDecorator.canDuplicate}get duplicateAttachments(){if(this.baseFactory?.duplicateAttachments)return!!this.baseFactory.duplicateAttachments;return!!this.nodeDecorator.duplicateAttachments}get notifies(){const e=this.baseFactory?.notifies??[],t=this.nodeDecorator.notifies??[];return _.uniq([...e,...t])}get canAudit(){const e=this.notifies;return e.includes("created")&&e.includes("updated")&&e.includes("deleted")}get canBeDuplicated(){if(this.canDuplicate)return true;if(this.isVitalChild&&this.vitalParentFactory.canBeDuplicated)return true;if(this.isAbstract&&this.subFactories.some(e=>e.canBeDuplicated))return true;return false}get canBulkDelete(){return!!this.nodeDecorator.canBulkDelete}get canDeleteMany(){const e=!!this.nodeDecorator.canDeleteMany;return this.externalStorageManager?.canDeleteMany?this.externalStorageManager.canDeleteMany(e):e}get canExport(){return false!==this.nodeDecorator.canExport}get isSetupNode(){return!!this.nodeDecorator.isSetupNode||this.isVitalChild&&this.vitalParentFactory!==this&&this.vitalParentFactory.isSetupNode||!!this.baseFactory?.isSetupNode}get hasVendorProperty(){if(false===this.nodeDecorator.hasVendorProperty)return false;return"sql"===this.storage&&!this.isSharedByAllTenants&&!this.isPlatformNode&&this.isSetupNode&&(!this.isVitalChild||this.isVitalChild&&this.vitalParentFactory.hasVendorProperty)}get hasAttachments(){return this.nodeDecorator.hasAttachments??!!this.baseFactory?.hasAttachments}get hasTags(){return this.nodeDecorator.hasTags??!!this.baseFactory?.hasTags}get hasNotes(){return this.nodeDecorator.hasNotes??!!this.baseFactory?.hasNotes}#i;get hasLookupAccess(){if(null==this.#i)if(context_1.Context.accessRightsManager.hasLookupAccess)this.#i=context_1.Context.accessRightsManager.hasLookupAccess(this.name);else this.#i=this.properties.some(e=>e.lookupAccess&&!["_id","_customData","_createStamp","_updateStamp","_sortValue"].includes(e.name));return this.#i}get isPlatformNode(){return!!this.nodeDecorator.isPlatformNode}get isPlatformNodeExportable(){return!!this.nodeDecorator.isPlatformNodeExportable||this.isPlatformNode&&this.isSetupNode}get isSkippedByLayerExtract(){return!!this.nodeDecorator.isSkippedByLayerExtract}get isContentAddressable(){return this.baseFactory?this.baseFactory.isContentAddressable:!!this.nodeDecorator.isContentAddressable}get keyPropertyNames(){return this.nodeDecorator.keyPropertyNames??this.naturalKey??[]}#a;get uniqueKeyProperties(){if(this.#a)return this.#a;if(this.#a=[this.keyProperties.map(e=>e.name)],"external"===this.storage)this.#a.push(["_id"]);if(this.indexes?.filter(e=>e.isUnique).forEach(e=>{this.#a.push(Object.keys(e.orderBy))}),this.baseFactory)this.#a.push(...this.baseFactory.uniqueKeyProperties);return this.#a=_.uniq(this.#a.map(e=>JSON.stringify(e.slice().sort((e,t)=>e.localeCompare(t))))).map(e=>JSON.parse(e)),this.#a}#o;get vitalParentProperty(){if(this.#o)return this.#o;if(!this.isVitalChild)throw this.logicError("cannot access vital parent property on a node which is not a vital child");const e=this.properties.find(e=>e.isVitalParent);if(!e)throw this.systemError("isVitalParent property not found");if(!e.isReferenceProperty())throw this.propertySystemError(e,"vital parent property is not a reference");return this.#o=e,this.#o}get associationParentProperties(){return this.properties.filter(e=>e.isVitalParent||e.isAssociationParent)}get vitalParentFactory(){return this.vitalParentProperty.targetFactory}get isSetupNodeVitalChild(){return this.isVitalChild&&this.vitalParentFactory!==this&&this.vitalParentFactory.isSetupNode}get isClearedByReset(){return"sql"===this.storage&&(this.nodeDecorator.isClearedByReset||this.isVitalChild&&this.vitalParentProperty.targetFactory.isClearedByReset||this.baseFactory?.isClearedByReset)}_retrieveNaturalKey(){const e=this.indexes?.find(e=>e.isNaturalKey);if(null!=e)return Object.keys(e.orderBy);if(this.baseFactory){const e=this.baseFactory.naturalKey;if(e){if(!this.isAbstract)return e.filter(e=>"_constructor"!==e);return e}}if(this.isVitalChild&&!this.isAssociationChild){if(this.vitalParentFactory.naturalKey)return this.isVitalCollectionChild?[this.vitalParentProperty.name,"_sortValue"]:[this.vitalParentProperty.name]}if(this.isAssociationChild)return this.associationParentProperties.map(e=>e.name);return}get naturalKey(){if(null===this._naturalKey)if(this._naturalKey=this._retrieveNaturalKey(),this._naturalKey)Object.freeze(this._naturalKey);return this._naturalKey}get delegatedProperties(){return this.#s}get foreignNodeProperties(){return this.#e}get referenceProperties(){return this.#t}get vitalProperties(){return this.#r}get hasSelfReference(){return this.referenceProperties.some(e=>e.isSelfReference)||this.name===core_hooks_1.CoreHooks.sysManager.getUserNode().name}get hasSqlInsertFunction(){return"sql"===this.storage&&!this.isAbstract}get prepareBegin(){if(this.events.prepareBegin&&this.events.prepare&&this.events.prepare!==this.events.prepareBegin)throw this.logicError("cannot have both prepare and prepareBegin rules");return this.events.prepareBegin=this.events.prepareBegin||this.events.prepare,this.events.prepareBegin}get prepareEnd(){return this.events.prepareEnd}getConcreteFactories(e=[]){if(this.isAbstract)this.subFactories.forEach(t=>t.getConcreteFactories(e));else e.push(this);return e}isSubNodeOf(e){return this.name===e||!!this.baseFactory?.isSubNodeOf(e)}isAssignableTo(e){if(this===e)return true;return!!this.baseFactory&&this.baseFactory.isAssignableTo(e)}isEnabledByServiceOptions(e){return(0,xtrem_async_helper_1.asyncArray)(this.serviceOptions).every(t=>e.isServiceOptionEnabled(t))}getInternalSystemProperties(){return system_properties_1.SystemProperties.getInternalSystemProperties(this)}addProperty(e,t="push"){if(!this.propertiesByName[e.name]){if("unshift"===t)this.properties.unshift(e);else this.properties.push(e);this.propertiesByName[e.name]=e}}createMainNodeProperties(e){this.createProperties(this.decorators.properties||[],e).forEach(e=>this.addProperty(e))}addExtensionDecorator(e){this.extensions=this.extensions||[],this.extensions.push(e)}createProperties(e,t){return e.map(e=>(0,create_property_1.createProperty)(this,e,t))}getExtensionDepth(e){return this.application.getFactoryByConstructor(e.nodeExtension.extends()).subclassDepth()}checkExtensionDepth(e,t){const r=e._extensionDepth,s=this.getExtensionDepth(t);if(r!==s)throw this.systemError(`${e.name}: invalid extension superclass: expected SubNodeExtension${s}, got SubNodeExtension${r}`)}static getExtensionPackage(e){return e[decorator_utils_1.decoratorsSymbol].package}mergeExtensions(e){this.extensions?.filter(t=>t[decorator_utils_1.decoratorsSymbol].package===e).forEach(t=>{const r=t[decorator_utils_1.decoratorsSymbol];this.checkExtensionDepth(t,r);const s=r.properties||[];this.createProperties(s.filter(e=>!e.isOverride),e).forEach(e=>{const t=this.propertiesByName[e.name];if(t){const r=`The property '${e.name}' has already been registered by the factory ${t.factory.fullName}`;throw this.systemError(r)}e.isInherited=this.getExtensionDepth(r)!==this.subclassDepth(),this.addProperty(e)});s.filter(e=>e.isOverride).forEach(e=>{this.findProperty(e.name).addExtension(e)}),this.mergeExtensionMethods(t),this.mergeExtensionHeader(r.nodeExtension,e),this.mergeOperations(r),this.mergeListeners(r)})}mergeExtensionMethods(e){const nonStaticFilter=e=>"constructor"!==e;this.mergeMethods(e,{throws:true,nonStaticFilter})}mergeSubNodeMethods(e){const nonStaticFilter=t=>{try{if(!e.prototype.$)return false;return"constructor"!==t}catch{return false}};this.mergeMethods(e,{throws:false,nonStaticFilter})}mergeMethods(e,t){const r=Object.getOwnPropertyNames(class Dummy{});Object.getOwnPropertyNames(e.prototype).filter(t.nonStaticFilter).forEach(r=>{if(t.throws&&this.nonStaticMethods[r])throw this.systemError(`${e.name}.${r}: invalid non-static method override`);const s=e.prototype[r];this.nonStaticMethods[r]=s,this.nodeConstructor.prototype[r]=function f(...e){return s.apply(this,e)}}),Object.getOwnPropertyNames(e).filter(e=>!r.includes(e)).forEach(r=>{if(t.throws&&this.staticMethods[r])throw this.systemError(`${e.name}.${r}: invalid static method override`);const s=e[r];this.staticMethods[r]=s,this.nodeConstructor[r]=function f(e,...t){return s.apply(this,[e,...t])}})}mergeOperationKind(e,t){const r=e[t];if(!r)return;const s=this[t];r.forEach(t=>{if(t.definingPackage=t.definingPackage?.allDependencies.includes(this.package)?t.definingPackage:this.package,s.some(e=>e.name===t.name&&"stop"!==e.action&&"stop"!==t.action&&"requestUserNotification"!==e.action&&"requestUserNotification"!==t.action))throw new Error(`${t.name} is already defined on a parent node of ${this.name}.`);const r=e.nodeExtension?.name;if(r&&t.decorator?.topic.startsWith(`${r}/`))t.decorator.topic=`${this.name}/${t.decorator.topic.substring(r.length+1)}`;s.push(t)})}mergeOperations(e){this.mergeOperationKind(e,"mutations"),this.mergeOperationKind(e,"queries")}mergeListeners(e){this.mergeOperationKind(e,"messageListeners"),this.mergeOperationKind(e,"notificationListeners")}mergeSubNodeHeader(e){const t=Object.keys(e),r=e.name;t.filter(t=>void 0!==e[t]).forEach(t=>{switch(t){case"storage":if(!this.storage)this.storage=e[t];if(this.storage!==e[t])throw this.systemError(`${r}.storage can't be redefined from '${e[t]}' to '${this.storage}'`);break;case"indexes":case"tableName":case"name":case"isAbstract":case"isSetupNode":case"isPublished":case"canDeleteMany":case"extends":case"isFrozen":case"canRead":case"canCreate":case"canUpdate":case"canDelete":case"canDuplicate":case"canBulkUpdate":case"canBulkDelete":case"canSearch":case"notifies":case"hasAttachments":case"hasTags":case"hasNotes":case"isVitalCollectionChild":case"isVitalReferenceChild":case"isAssociationReferenceChild":case"isAssociationCollectionChild":case"isClearedByReset":case"isCustomizable":case"isSynchronizable":case"isSynchronized":case"isCached":break;case"prepare":case"prepareBegin":case"prepareEnd":case"createEnd":case"controlBegin":case"controlEnd":case"controlDelete":case"saveBegin":case"saveEnd":case"deleteBegin":case"deleteEnd":try{this.events[t]=(0,decorator_utils_1.chainEvents)(e[t],this.events[t],t)}catch(e){throw this.systemError(e.message)}break;case"getFilters":try{const t=e.getFilters,r=this.events.getFilters;this.events.getFilters=async function chainArrayEventResult(...e){const s=await(r?.apply(this,e)),i=await(t?.apply(this,e));return(0,decorator_utils_1.chainArrays)(s,i)||[]}}catch(e){throw this.systemError(e.message)}break;default:throw this.systemError(`${e.name}.${t} cannot be redefined.`)}})}mergeExtensionHeader(e,t){Object.keys(e).forEach(r=>{switch(r){case"name":case"extends":break;case"hasAttachments":this.nodeDecorator.hasAttachments=e[r],this.systemPropertyDefiningPackage._attachments=t;break;case"hasTags":this.nodeDecorator.hasTags=e[r],this.systemPropertyDefiningPackage._tags=t;break;case"hasNotes":this.nodeDecorator.hasNotes=e[r],this.systemPropertyDefiningPackage._notes=t;break;case"isSynchronizable":this.nodeDecorator.isSynchronizable=e[r];break;case"isSynchronized":this.nodeDecorator.isSynchronized=e[r];break;case"prepare":case"prepareBegin":case"prepareEnd":case"createEnd":case"controlBegin":case"controlEnd":case"controlDelete":case"saveBegin":case"saveEnd":case"deleteBegin":case"deleteEnd":try{this.events[r]=(0,decorator_utils_1.chainEvents)(this.events[r],e[r],r)}catch(e){throw this.systemError(e.message)}break;case"indexes":this.indexes=(0,decorator_utils_1.chainArrays)(this.indexes,e[r]);break;case"externalStorageManagerExtension":if("external"!==this.storage)throw this.systemError("Base node not managed by an external storage.");_.merge(this.externalStorageManager,e.externalStorageManagerExtension);break;case"isVitalReferenceChild":this.nodeDecorator.isVitalReferenceChild=e.isVitalReferenceChild;break;case"isAssociationCollectionChild":this.nodeDecorator.isAssociationCollectionChild=e.isAssociationCollectionChild;break;case"isAssociationReferenceChild":this.nodeDecorator.isAssociationReferenceChild=e.isAssociationReferenceChild;break;default:throw this.systemError(`${r} cannot be redefined.`)}})}subclassDepth(){const e=this.getSuperFactory();return e?e.subclassDepth()+1:0}checkSubclassDepth(){const e=this.subclassDepth();if(e>ts_api_1.maxNodeSubclassingDepth)throw this.systemError(`${this.name}: subclass hierarchy is too deep: currently limited to ${ts_api_1.maxNodeSubclassingDepth} levels, got ${e} levels`)}mergeSubNodes(){if(!this.decorators.superDecorators)throw this.systemError(`${this.name} is not a subNode.`);this.checkSubclassDepth();const e=[];let t=this.decorators;for(;t.superDecorators;)e.push(t.superDecorators),t=t.superDecorators;e.forEach(e=>{this.mergeSubNodeMethods(this.package.application.getFactoryByName(e.node.name).nodeConstructor),this.mergeSubNodeHeader(e.node),this.mergeOperations(e)})}getSuperFactory(){if(!this.decorators.superDecorators)return;return this.package.application.getFactoryByName(this.decorators.superDecorators.node.name)}createSuperNodeProperties(e){if(!this.decorators.superDecorators)throw this.systemError(`${this.name} is not a subNode.`);const t=[];let r=this.getSuperFactory();for(;r;)t.push(r),r=r.getSuperFactory();t.reverse().forEach(t=>{const r=t.decorators.properties.filter(e=>{const t=this.propertiesByName[e.name];return e.name&&!t});this.createProperties(r,e).forEach(e=>{e.isInherited=true,this.addProperty(e)})})}createSubNodeProperties(e){if(!this.decorators.superDecorators)throw this.systemError(`${this.name} is not a subNode.`);const t=this.decorators.properties.filter(e=>!e.isOverride)||[];this.createProperties(t,e).forEach(t=>{if(this.propertiesByName[t.name])throw this.propertiesByName[t.name].logicError(`invalid decorator: change it to ...PropertyOverride (in ${e.name})`);this.addProperty(t)})}createSubNodeOverrides(){let e=this.getSuperFactory();const t=[];for(;e;)t.push(e),e=e.getSuperFactory();t.reverse();[...t,this].forEach(e=>{e.decorators.properties.filter(e=>e.isOverride).forEach(e=>{this.findProperty(e.name).addExtension(e)})})}verifyIsContentsAddressable(){if(this.nodeDecorator.isContentAddressable&&this.baseFactory)throw this.systemError("isContentsAddressable can only be set on root node");if(this.isContentAddressable&&"sql"!==this.storage)throw this.systemError("isContentsAddressable can only be set node with storage class");if(this.isVitalChild){if(this.isContentAddressable)throw this.systemError("isContentsAddressable is not supported on vital graphs");if(this.vitalParentFactory.isContentAddressable)throw this.vitalParentFactory.systemError("isContentsAddressable is not supported on vital graphs")}}verifyIsSynchronizable(){if(!this.nodeDecorator.isSynchronizable)return;if("sql"!==this.storage)throw this.systemError("isSynchronizable can only be set on nodes with sql storage");if(this.isSharedByAllTenants)throw this.systemError("isSynchronizable cannot be set on nodes shared by all tenants");if(void 0===this.naturalKey)throw this.systemError("isSynchronizable can only be set on nodes with a natural key");if(this.baseFactory?.isSynchronizable)throw this.systemError("isSynchronizable cannot be redefined on a sub node")}verifyIsSynchronized(){if(!this.nodeDecorator.isSynchronized)return;if(this.isAbstract)throw this.systemError("isSynchronized cannot be set on an abstract node");if("sql"!==this.storage)throw this.systemError("isSynchronized can only be set on nodes with sql storage");if(void 0===this.naturalKey)throw this.systemError("isSynchronized can only be set on nodes with a natural key")}verifyDefaultsToSingleMatch(){if(!this.nodeDecorator.defaultsToSingleMatch)return;if(!this.isCached)throw this.systemError("defaultsToSingleMatch can only be set on cached nodes")}verify(){if(this.application.skipVerifications)return;if(this.isVitalChild)this._verifyVitalChildFactory();if(this.nodeDecorator.isClearedByReset)this._verifyClearedByResetFactory();if("external"===this.storage){if(0===this.keyPropertyNames.length)throw this.systemError("keyPropertyNames attribute cannot be empty");if(!this.externalStorageManager)throw this.missingClassDecorator("externalStorageManager");this.checkExternalDecorator()}else if(this.externalStorageManager)throw this.systemError("externalStorageManager attribute supplied for non-external node.");else this.checkDecorators();if(this.baseFactory?.hasAttachments&&!this.hasAttachments)throw this.systemError(`Sub node cannot override hasAttachments where base node is set to true (${this.baseFactory.name})`);if(this.baseFactory?.hasTags&&!this.hasTags)throw this.systemError(`Sub-factory ${this.baseFactory.name} cannot have 'hasTags=true' while its base factory ${this.baseFactory.name} has 'hasTags=false'`);if(this.baseFactory?.hasNotes&&!this.hasNotes)throw this.systemError(`Sub-factory ${this.baseFactory.name} cannot have 'hasNotes=true' while its base factory ${this.baseFactory.name} has 'hasNotes=false'`);if(Object.values(this.mutations).some(e=>"bulkMutation"===e.operationKind&&!!e.authorizedBy))throw this.systemError("NYI: authorizedBy not supported on bulk mutations");this.verifyIsSynchronizable(),this.verifyIsSynchronized();const e=[];this.vitalProperties.forEach(t=>{const r=t.targetFactory.name,s=e.find(e=>r===e.targetFactory.name);if(s)throw this.systemError(`Found two vital properties for the same vital child node ${r}: '${t.name}' and '${s.name}'`);else e.push(t)});const t=this.properties.filter(e=>e.isOwnedByCustomer).map(e=>e.name);if(t.length>0)if(!this.hasVendorProperty)throw this.systemError(`The isOwnedByCustomer attribute is only allowed if the node has a vendor property. Check properties: '${t}'`);if(this.properties.forEach(e=>e.verify()),this.indexes){const e=this.indexes?.filter(e=>e.isNaturalKey);if(e)if(e.length>1)throw this.systemError(`${this.name} cannot have more than 1 index with isNaturalKey set to true.`)}if(this.isSetupNode&&!this.naturalKey)throw this.systemError(`${this.name} setup nodes must have a natural key.`);if(this.verifyIsContentsAddressable(),this.getSelfIndexes().forEach(e=>{this.verifyIndex(e)}),this.ensureNoMultipleUniqueIndexes(),this.verifyDefaultsToSingleMatch(),this.externalStorageManager?.verifyFactory)this.externalStorageManager?.verifyFactory()}_verifyVitalChildFactory(){if(true===this.nodeDecorator.isClearedByReset)throw this.systemError("isClearedByReset can only be tagged in parent node");if(this.vitalParentFactory.isSetupNode&&(this.canCreate||this.canUpdate))throw this.systemError("vital children of setup nodes cannot have canCreate or canUpdate set to true");if(this.isVitalChild&&this.properties.some(e=>e.provides?.includes("site"))){if(this.vitalParentFactory.properties.some(e=>e.provides?.includes("site")))throw this.systemError(`Vital child cannot have provides properties if already defined on the vital parent  (${this.properties.filter(e=>e.provides?.includes("site")).map(e=>e.name).join(",")})`);if(this.vitalParentFactory.properties.some(e=>e.isReferenceProperty()&&e.node.provides?.includes("site")))throw this.systemError(`Vital child cannot provide site property, site property is present on the vital parent (${this.vitalParentFactory.properties.filter(e=>e.isReferenceProperty()&&e.node.provides?.includes("site")).map(e=>e.name).join(",")})`)}}_verifyClearedByResetFactory(){if(this.isSetupNode&&"function"!=typeof this.nodeDecorator.isClearedByReset)throw this.systemError("isClearedByReset cannot be set on setup node");if(this.isAbstract)this._subFactories.forEach(e=>{if(e.nodeDecorator.isClearedByReset)throw this.systemError("A subNode can only be tagged isClearedByReset if its base node is not tagged")});if(this.isSharedByAllTenants)throw this.systemError("isClearedByReset tag cannot be set on a node which is shared by all tenants")}getSelfIndexes(){const e=this.baseFactory?.indexes;if(!this.indexes||!e)return this.indexes||[];return this.indexes.filter(t=>e.every(e=>!(0,node_factory_utils_1.sameIndexProperties)(t,e)))}verifyJoins(){this.properties.forEach(e=>{if(e.isForeignNodeProperty())e.verifyJoin()})}async verifyTable(e,t={}){let r=t;const findTableInList=(e,t,r)=>{const s=`${r}${e?`=>${e.targetFactory.name}`:""}`;if(!e||e.targetFactory.table.name===t)return{link:e,path:s};return findTableInList(e.previousLink,t,s)},createUpgradeError=e=>new xtrem_shared_1.SystemError(`${e}. Please upgrade the sql schema with 'xtrem schema --upgrade'`),findIsNullableLink=(e,t)=>{if(!e)throw this.logicError("Unexpected end of factory list");if(e.targetFactory.table.name===t)return!!e.property.isNullable;if(e.property.isNullable)return true;return findIsNullableLink(e.previousLink,t)},checkCyclicFactory=async(t,s,i)=>{if(!findIsNullableLink(t,s.table.name))throw this.systemError(`A cyclic reference exists (${i}). A nullable property is required in the dependency tree for a cyclic reference.`);if(r?.compareToSqlSchema&&!await s.table.tableExists(e))throw this.systemError(`The table '${s.table.name}', referenced by '${i}' does not exist`)};if("sql"!==this.storage)return;if(!r)r={factoryLinkedList:void 0,foreignFactories:[]};if(this.baseFactory)await this.baseFactory.verifyTable(e,r);if(r.compareToSqlSchema&&!await this.table.tableExists(e))throw createUpgradeError(`The table '${this.table.name}' does not exist.`);const s=r.compareToSqlSchema?await new read_table_sql_context_1.ReadTableSqlContext(e.application).readSchema(this.table.name,{skipIndexes:true,skipSecurity:true,skipSequences:true}):void 0,i=s?.columns?.map(e=>e.name);await(0,xtrem_async_helper_1.asyncArray)(this.properties.filter(e=>!e.isInherited&&e.isStored&&e.columnName&&!["_createUser","_updateUser"].includes(e.name))).forEach(async t=>{if(i&&!i.includes(t.requiredColumnName))throw createUpgradeError(`No column exists for the property ${this.name}.${t.name}.`);if(!t.isReferenceProperty())return;if("json"===t.targetFactory.storage)return;this.checkIncompatibleAttributes(t,"isVital","isStored");const a={previousLink:r?.factoryLinkedList,targetFactory:this,property:t},o=t.targetFactory,n=findTableInList(a,o.table.name,`${o.name}`);if(!r.doNotRecurseOnReferences)if(!n.link)await o.verifyTable(e,{...r,factoryLinkedList:a});else{if(!t.isSelfReference)await checkCyclicFactory(a,o,n.path);if(r&&!r.foreignFactories?.includes(o))r.foreignFactories?.push(o)}if(!this.table.foreignKeys?.find(e=>e.columnNames.find(e=>e===t.columnName))&&!n){const e=this.createForeignKey(o,t);if(e)if(s&&!s.foreignKeys?.find(t=>t.name===e.name))throw createUpgradeError(`The foreign key '${this.name}.${e.name}' is missing.`)}})}computeDependencyIndex(){this.properties=(0,xtrem_toposort_1.topoSort)(this.properties),this.properties.forEach((e,t)=>{e.dependencyIndex=t+1})}setSubFactories(){const e=this.decorators.superDecorators;if(e)if(this._baseFactory=this.package.application.getFactoryByName(e.node.name),!this._baseFactory?._subFactories.includes(this))this._baseFactory?._subFactories.push(this)}fillForeignNodeProperties(){this.#e.push(...this.properties.filter(e=>e.isForeignNodeProperty)),Object.freeze(this.#e)}fillReferenceProperties(){this.#t.push(...this.foreignNodeProperties.filter(e=>e.isReferenceProperty)),Object.freeze(this.#t)}fillVitalProperties(){this.#r.push(...this.foreignNodeProperties.filter(e=>e.isVital)),Object.freeze(this.#r)}fillDelegatedProperties(){this.#s.push(...this.properties.filter(e=>e.delegatesTo)),Object.freeze(this.#s)}fillMutableProperties(){this.mutableProperties=this.properties.filter(e=>e.isForeignNodeProperty()&&e.isMutable),this.mutableProperties.filter(e=>e.isCollectionProperty()).forEach(e=>{if(e.isCollectionProperty())e.targetFactory.addUpdateActionProperty()}),Object.freeze(this.mutableProperties)}get strictMutableProperties(){return this.mutableProperties.filter(e=>!e.isVital)}addUpdateActionProperty(){const e=system_properties_1.SystemProperties.updateActionProperty(this);if(this.propertiesByName[e.name])return;this.addProperty(e,"unshift")}complement(e){if(!this.keyProperties.length)this.addSystemProperties();if(this.computeDependencyIndex(),this.complementFactoryIndexes(),"external"===this.storage)this.keyProperties=[],this.keyPropertyNames.forEach(e=>{const t=this.propertiesByName[e];this.keyProperties.push(t)});if("sql"===this.storage)this.table=this.makeTable();this.properties.forEach(e=>{if(e.provides)e.provides.forEach(t=>this.setTaggedProperty(t,e))}),(0,node_factory_utils_1.setChildFactoriesTable)(this),["updateDependsOn","dependsOn"].forEach(t=>this.computePropagationPaths(t,e)),this.properties.filter(e=>properties_1.foreignNodePropertyTypes.includes(e.type)).filter(e=>!e.targetFactory.referringProperties.some(t=>this.name===t.targetFactory.name&&e.name===t.property.name)).forEach(e=>{e.targetFactory.referringProperties.push({targetFactory:this,property:e})}),this.lazyLoadedProperties=this.properties.filter(e=>e.isStored&&e.shouldLazyLoad),this.storedEncryptedProperties=this.properties.filter(e=>e.isStringProperty()&&e.isStoredEncrypted),this.fillForeignNodeProperties(),this.fillReferenceProperties(),this.fillMutableProperties(),this.fillVitalProperties(),this.fillDelegatedProperties()}get extendedVitalFactories(){if(!this._extendedVitalFactories){const e=new Set;this.vitalProperties.forEach(t=>{const r=t.targetFactory;e.add(r),r.extendedVitalFactories.forEach(t=>e.add(t))}),this._extendedVitalFactories=[...e]}return this._extendedVitalFactories}complementFactoryIndexes(){const e="sql"===this.storage;if(this.indexes=this.indexes||[],e&&this.isVitalChild&&!this.isAssociationChild&&!(this.baseFactory&&this.baseFactory.propertiesByName[this.vitalParentProperty.name])){const e=this.isVitalCollectionChild?{[this.vitalParentProperty.name]:1,_sortValue:1}:{[this.vitalParentProperty.name]:1},t=Object.keys(e).join(),r=this.indexes.findIndex(e=>{const r=Object.keys(e.orderBy).join();return r===t||r===`_constructor,${t}`}),s=!!this.indexes?.find(e=>e.isNaturalKey);if(r<0){const t=this.vitalParentFactory.naturalKey&&!s?{orderBy:e,isUnique:true,isNaturalKey:true}:{orderBy:e,isUnique:this.isVitalCollectionChild?!s:true};this.indexes.push(t)}else if(this.vitalParentFactory.naturalKey&&!s)this.indexes[r].isNaturalKey=true}if(e&&this.isAssociationChild){const e=this.indexes.find(e=>e.isNaturalKey);for(let t=0;t<this.associationParentProperties.length;t++){const r={};for(let e=0;e<this.associationParentProperties.length;e++)r[this.associationParentProperties[(e+t)%this.associationParentProperties.length].name]=1;if(!this.indexes.find(e=>(0,node_factory_utils_1.arraysAreEqual)(Object.keys(e.orderBy),Object.keys(r)))){const s={orderBy:r,isUnique:true,isNaturalKey:0===t&&!e};this.indexes.push(s)}}}if(this.isContentAddressable)this.indexes.push({orderBy:{_valuesHash:1},isUnique:true});if(this.nodeDecorator.isSynchronizable)this.indexes.push({orderBy:{_syncTick:1}});this.indexes.forEach((e,t)=>{if(!e.name)e.name=(0,naming_1.makeName63)(`${this.tableName}_ind${t}`)})}addSystemProperties(){this.getInternalSystemProperties().forEach(e=>this.addProperty(e,"unshift")),this.keyProperties=[this.propertiesByName._id];system_properties_1.SystemProperties.getPublishedSystemProperties(this).forEach(e=>{this.publishedSystemProperties[e.name.substring(1)]=e,this.addProperty(e)}),this.publishedInputSystemProperties=system_properties_1.SystemProperties.getPublishedInputSystemProperties()}computePropagationPaths(e,t){const r="dependsOn"===e?"propagatesTo":"updatePropagatesTo";this.properties.filter(t=>t[e]).forEach(s=>{try{const i=[];if(this.addPropagatePaths(r,s[e],[s],i),t&&i.length)i.forEach(r=>t.warnings.add(`${this.name}.${s.name}.${e}: ${r}`))}catch(t){throw this.propertySystemError(s,`invalid '${e}' value: ${t.message}`)}})}createNewTableColumns(e){return e.filter(e=>e.isStored).filter(e=>!e.isInherited).map(e=>{const t=e.columnType||e.type,r=e.dataType,s=r instanceof types_1.StringDataType&&r.maxLength;if("string"===t&&!s)throw this.missingPropertyDecorator(e.name,"dataType");return new schema_1.Column(e)})}get defaultOrderBy(){if("external"===this.storage)return this.externalStorageManager.defaultOrderBy;if(this.naturalKey)return this.naturalKey.reduce((e,t)=>{const r=this.findProperty(t);if(r.isReferenceProperty()&&r.targetFactory.naturalKey)e[t]=r.targetFactory.defaultOrderBy;else e[t]=1;return e},{});return{_id:1}}get package(){return this._package}get application(){return this.package.application}get name(){return this.nodeDecorator.name}get fullName(){if(this.package)return`${this.package.name}/${this.name}`;return`application-not-found/${this.name}`}get baseFactory(){return this._baseFactory}get rootFactory(){return this._baseFactory?this._baseFactory.rootFactory:this}get rootCollectionFactory(){if(this.nodeDecorator.isVitalCollectionChild)return this._baseFactory&&this._baseFactory.rootCollectionFactory?this._baseFactory.rootCollectionFactory:this;return}get rootVendorFactory(){if(this.hasVendorProperty)return this._baseFactory&&this._baseFactory.hasVendorProperty?this._baseFactory.rootVendorFactory:this;return}get isSharedByAllTenants(){return!!this.nodeDecorator.isSharedByAllTenants}get tableName(){if(this.nodeDecorator.tableName)return"sql"===this.storage?_.snakeCase(this.nodeDecorator.tableName):this.nodeDecorator.tableName;return(0,xtrem_shared_1.nameToSqlName)(this.name)}get requiredTableName(){const e=this.tableName;if(!e)throw this.logicError("missing tableName");return e}get fullTableName(){return`${this.application.schemaName}.${this.tableName}`}async resolveReferenceId(e,t){if(null===t)return null;if("number"==typeof t)return t;if("string"!=typeof t)return t instanceof ts_api_1.Node?t._id:t;if("#"!==t[0])return(0,types_1.safeParseInt)(t,"_id");const r=await e.select(this.nodeConstructor,{_id:true},{filter:this.parseNodeId(t)});if(0===r.length)return null;if(r.length>1)throw this.systemError(`Invalid natural key ${t}. More than 1 row returned when resolving reference id.`);return r[0]._id}getVitalTree(){const e=[],addForeignNodes=t=>{if(e.includes(t))return;e.push(t),t.vitalProperties.forEach(e=>addForeignNodes(e.targetFactory))};return addForeignNodes(this),e}getMutableTree(){const e=[],addForeignNodes=t=>{if(e.includes(t))return;e.push(t),t.mutableProperties.forEach(e=>addForeignNodes(e.targetFactory))};return addForeignNodes(this),e}getAllTableNames(){if("sql"!==this.storage)return[];const e=[],walkToRoot=t=>{if(e.unshift(this.fullTableName),t.baseFactory)walkToRoot(t.baseFactory)};walkToRoot(this);const walkToLeaves=t=>{t._subFactories.forEach(t=>{e.push(t.fullTableName),walkToLeaves(t)})};return walkToLeaves(this),e}get authorizationCode(){return this.nodeDecorator.authorizationCode}getIsolationLevel(e){return this.nodeDecorator.isolationLevels?.[e]||"low"}get provides(){return this.nodeDecorator.provides}get subFactories(){return[...this._subFactories]}checkDecorators(){if(this.canDuplicate&&!this.canCreate)throw this.systemError("canDuplicate requires canCreate on the node decorator");if(this.canBulkDelete&&!this.canDelete)throw this.systemError("canBulkDelete requires canDelete on the node decorator")}checkExternalDecorator(){const checkExternalManagerFunctions=e=>{if(!this.externalStorageManager[e])throw this.systemError(`missing ${e} function on externalStorageManager decorator member of external node`)};if(this.canRead)checkExternalManagerFunctions("query"),checkExternalManagerFunctions("mapRecordIn"),checkExternalManagerFunctions("mapAggregateRecordIn");if(this.canDelete||this.canDeleteMany)checkExternalManagerFunctions("delete");if(this.canBulkDelete)throw this.systemError("bulkDelete async mutations are not supported on external nodes");if(this.canCreate)checkExternalManagerFunctions("insert");if(this.canUpdate)checkExternalManagerFunctions("update")}checkIncompatibleAttributes(e,t,r){if(e[t]&&e[r])throw this.propertySystemError(e,`'${t}' and '${r}' attributes are incompatible`)}setTaggedProperty(e,t){const r=this._taggedProperties[e];if(r&&r!==t)throw this.propertySystemError(t,`${r.name}: ambiguous ${e} property`);if("isActive"===e&&!t.isBooleanProperty())throw this.propertySystemError(t,"Properties that provide isActive can only be boolean");this._taggedProperties[e]=t}getTaggedProperty(e){return this._taggedProperties[e]}findReverseProperty(e,t){const r=this.properties.filter(e=>properties_1.foreignNodePropertyTypes.includes(e.type)).filter(t=>t.targetFactory===e).map(e=>({prop:e,join:e.join||{}})).filter(e=>!!e.join).find(e=>Object.keys(e.join).every(r=>{const s=e.join[r];return"string"==typeof s&&t.join?t.join[s]===r:true}));return r?.prop}warnDecorator(e){if(this.decoratorWarnings[e])return;this.decoratorWarnings[e]=true,logger.warn(`${this.name}: ${e}`)}checkPropagatesTo(e,t,r){if(this.application.skipVerifications)return;if(!r.isVitalParent&&!r.isAssociationParent)return;("updatePropagatesTo"===e?["canUpdate"]:["canCreate","canUpdate","canDelete","canDeleteMany","canRead"]).forEach(r=>{if(this.nodeDecorator[r])this.warnDecorator(`${r} should not be set because of a ${e} attribute on ${t.name} in its vital parent`)})}addPropagatePaths(e,t,r,s){if(Array.isArray(t))t.forEach(t=>this.addPropagatePaths(e,t,r,s));else if("string"==typeof t){const s=this.findProperty(t);s[e]=s[e]||[],s[e].push(r)}else{const i=new Set;Object.keys(t).forEach(a=>{const o=this.findProperty(a);if(!o.isForeignNodeProperty())throw this.propertySystemError(o,"property must be a reference or a collection");const n=o.targetFactory,c=n.findReverseProperty(this,o);if(void 0===c){if(!this.application.skipVerifications)s.push(`${this.name}.${o.name} is not part of the vital graph. The rule '${JSON.stringify(t)}' will be ignored.`);i.add(a)}else n.checkPropagatesTo(e,o,c),n.addPropagatePaths(e,t[a],[c,...r],s),o[e]=o[e]||[],o[e].push(r)}),[...i.values()].forEach(t=>this.addPropagatePaths(e,t,r,s))}}systemError(e){return new xtrem_shared_1.SystemError(`${this.name}: ${e}`)}authorizationError(e,t){const r=e.localize(t.key,t.message,t.data||{});return new xtrem_shared_1.AuthorizationError(`${this.name}: ${r}`,t.innerError)}logicError(e,t){return new xtrem_shared_1.LogicError(`${this.name}: ${e}`,t)}propertySystemError(e,t){return new xtrem_shared_1.SystemError(`${this.name}.${e.name}: ${t}`)}checkCanMutate(e,t){if((!e.isWritable||e.hasReadonlyScopes())&&("sql"===this.storage||"external"===this.storage))throw this.systemError(`cannot ${t}: context is readonly`);if(this.isSharedByAllTenants&&!this.isPlatformNode&&"admin-tool"!==e.application.applicationType)throw this.authorizationError(e,{key:"@sage/xtrem-core/shared-by-all-tenants",message:"cannot {{verb}}: shared by all tenants.",data:{verb:t}})}checkCanCreate(e){this.checkCanMutate(e,"create")}checkCanDelete(e){this.checkCanMutate(e,"delete")}checkCanUpdate(e){this.checkCanMutate(e,"update")}checkCanDeleteMany(e){if(this.checkCanDelete(e),!this.canDeleteMany)throw this.systemError('deleteMany operation is not allowed. Consider adding "canDeleteMany" in the decorator')}addPropertyAccessors(e){if(!Object.getOwnPropertyDescriptor(this.nodeConstructor.prototype,e.name))try{if("_id"===e.name)Object.defineProperty(this.nodeConstructor.prototype,e.name,{get(){return state_get_value_1.StateGetValue.getPropertyValueSync(this.$.state,e)},set(e){this.$.state.values._id=e},enumerable:true});else if(e.isCollectionProperty())Object.defineProperty(this.nodeConstructor.prototype,e.name,{get(){return state_get_value_1.StateGetValue.getPropertyValueSync(this.$.state,e)},enumerable:true});else Object.defineProperty(this.nodeConstructor.prototype,e.name,{get(){return this.$.state.getPropertyValue(e)},enumerable:true})}catch(e){throw this.systemError(e.message)}}getAllIndexes(){const e=[];for(let t=this;t;t=t.baseFactory)if(t.indexes)e.push(...t.indexes);return e}getKeyValues(e,t,r){if("sql"===this.storage&&null!=t._id)return{_id:t._id};if("external"===this.storage)return this.externalStorageManager.getKeyValues(e,t,r);if(r?.allocateTransient)return{_id:e.allocateTransientId()};throw this.systemError("cannot get key values: class is not persistent")}getLocalizedTitleKey(){return`${this.package.name}/nodes__${_.snakeCase(this.name)}__node_name`}getLocalizedTitle(e,t){try{return e.localize(this.getLocalizedTitleKey(),this.name)}catch(e){return logger.warn(`Could not resolve node name: ${this.name}: ${e?.message}`),t?.useTitleCase?(0,xtrem_shared_1.titleCase)(this.name):this.name}}getLocalizedOperationFailedMessage(e,t){const r=e.diagnoses?.map(e=>`[${e.path.join(".")}]: ${xtrem_shared_1.ValidationSeverity[e.severity]}: ${e.message}`).join("\n")||"No diagnoses available";switch(loggerApplication.verbose(()=>`getLocalizedOperationFailedMessage with inner diagnosis ${r}`),t){case"create":return(0,xtrem_i18n_1.localizedText)("@sage/xtrem-core/record-was-not-created","The record was not created.");case"update":return(0,xtrem_i18n_1.localizedText)("@sage/xtrem-core/record-was-not-updated","The record was not updated.");case"delete":return(0,xtrem_i18n_1.localizedText)("@sage/xtrem-core/record-was-not-deleted","The record was not deleted.");case"duplicate":return(0,xtrem_i18n_1.localizedText)("@sage/xtrem-core/record-was-not-duplicated","The record was not duplicated.");case"save":return(0,xtrem_i18n_1.localizedText)("@sage/xtrem-core/record-was-not-saved","The record was not saved.");default:try{const e=this.mutations.find(e=>e.name===t)?.operationKind,r=`${this.package.name}/nodes__${_.snakeCase(this.name)}__${e}__${t}__failed`;return(0,xtrem_i18n_1.localizedText)(r,`${(0,xtrem_shared_1.titleCase)(t)} failed.`)}catch{return`${(0,xtrem_shared_1.titleCase)(t)} failed.`}}}async delete(e,t){const r=new node_state_1.NodeState(e,this,t,node_state_1.StateStatus.updatable,{forUpdate:false,isThunk:true});await r.delete()}async deleteMany(e,t,r){const s=(this.provides?.length??0)>0||this.properties.some(e=>(e.provides?.length??0)>0);if(this.hasVendorProperty||s||this.nodeDecorator.controlDelete||this.nodeDecorator.deleteBegin||this.nodeDecorator.deleteEnd||"external"===this.storage){let s=[];if((0,utils_2.isCompound)(t))s=await(await this.query(e,{filter:t,forUpdate:true})).map(e=>e.$.state).readAll();else{const r=await node_state_1.NodeState.newFromRead(e,this,t,{forUpdate:true,dontThrow:true});if(!r)return 0;s=[r]}return await(0,xtrem_async_helper_1.asyncArray)(s).forEach(e=>e.delete(r)),s.length}if((0,utils_2.isCompound)(t)){this.checkCanDelete(e),await state_intern_1.StateIntern.removeStateWithData(e,this,t);const r=await this.table.delete(e,t);if(r>0)e.prefetcher.afterDelete(this);return r}const i=await node_state_1.NodeState.newFromRead(e,this,t,{forUpdate:true});if(!i)return 0;return await i.delete(),i.context.hasErrors()?0:1}async query(e,t){const r=t?{...t}:{},s=await this.createNodeQuery(e,r);if(t?.aggregate)return s.getAggregateReader();if(this.name.startsWith("FifoValuation"))return s.getNodeReader();const i=await s.getDataReader().readAll();return i.forEach(r=>e.prefetcher.visit(this,!!t?.forUpdate,r)),(0,xtrem_async_helper_1.asyncArrayReader)(i).map(r=>node_state_1.NodeState.newFromQuery(e,this,r,!!t?.forUpdate).node)}async getAllowedAccessCodes(e,t){let r=e.getAllowedAccessCodes(t);if("external"===this.storage&&this.externalStorageManager.getAllowedAccessCodes)r=await this.externalStorageManager.getAllowedAccessCodes(e,t,r);return r}async getParentPropertyFilter(e,t,r){let s;if(r.vitalParentFactory.isVitalChild)if(s=await this.getParentPropertyFilter(e,t,r.vitalParentFactory),s)return{[r.vitalParentProperty.name]:s};const i=r.vitalParentFactory.getTaggedProperty(t);if(!i)return;const a=await this.getAllowedAccessCodes(e,t);if(a){if(i.isNullable)return{_or:[{[r.vitalParentProperty.name]:{[i.name]:{_in:a}}},{[r.vitalParentProperty.name]:{[i.name]:null}}]};return{[r.vitalParentProperty.name]:{[i.name]:{_in:a}}}}return s}async getPropertyFilter(e,t){if("site"===t&&this.isVitalChild){const r=await this.getParentPropertyFilter(e,t,this);if(r)return r}const r=this.getTaggedProperty(t);if(!r)return;const s=await this.getAllowedAccessCodes(e,t);if(r&&s){if(r.isNullable)return{_or:[{[r.name]:{_in:s}},{[r.name]:null}]};return{[r.name]:{_in:s}}}return}async getNodeFilter(e,t){if(this.provides&&this.provides.length>0&&this.provides.includes(t)){const r=await this.getAllowedAccessCodes(e,t);if(r)return{_id:{_in:r}}}return}async getConstructorFilter(e,t){if(!this.isAbstract||"external"===this.storage)return;const r=this.getConcreteFactories();if(0===r.length)return logger.warn(`No concrete factories found for abstract node ${this.name}`),{_id:-1};const s=await(0,xtrem_async_helper_1.asyncArray)(r).filter(async r=>"authorized"!==(await context_1.Context.accessRightsManager.getUserAccessFor(e,r.name,t)).status).map(e=>e.name).toArray();if(s.length>0)return{_constructor:{_nin:s}};return}async getAccessRightsFilter(e,t){const r=[...this.events.getFilters&&await(this.events.getFilters?.(e))||[],await this.getPropertyFilter(e,"site"),await this.getPropertyFilter(e,"accessCode"),t?void 0:await this.getNodeFilter(e,"site")].filter(e=>!!e);return r.length>0?{_and:r}:void 0}createLazyLoadedValueQuery(e,t,r){const s=r.find(e=>!e.shouldLazyLoad);if(s)throw new Error(`Property ${this.name}.${s.name}: can only lazy-load properties where shouldLazyLoad is true`);return mapper_1.SqlQuery.create(e,this,{filters:[{_id:t}],orderBy:{_id:1},onlyProperties:r})}async createNodeQuery(e,t,r){const s=t||{},i=Array.isArray(s.filter)?s.filter:s.filter?[s.filter]:[],a=await this.getAccessRightsFilter(e,t.omitNodeProvidesFilter);if(a)i.push(a);const o={...s,forUpdate:s.forUpdate,filters:i,selector:r};return mapper_1.SqlQuery.create(e,this,o)}async queryCount(e,t){const r=await this.getAccessRightsFilter(e),notEmpty=e=>null!=e&&Object.keys(e).length>0,s=notEmpty(t.filter)?notEmpty(r)?{_and:[t.filter,r]}:t.filter:r,i=await(await this.createNodeQuery(e,{...t,filter:s,count:true})).getCount();if(null==i)throw this.systemError("getCount: empty result");if("number"!=typeof i)throw this.logicError(`${this.name}: getCount: bad result type: ${typeof i}`);return i}async exists(e,t){return await this.queryCount(e,{filter:t})>0}getToken(e){return this.keyProperties.map(t=>String(e[t.name]||"")).join("~")}findProperty(e,t){let r;if(t&&t.includeSystemProperties&&e.startsWith("_"))r=this.publishedSystemProperties[e.substring(1)];if(r=r||this.propertiesByName[e],!r)throw this.logicError(`${this.name}.${e} : property not found`);return r}parseOrderBy(e,t){if(!t)return[];if("external"===this.storage)return this.externalStorageManager.parseOrderBy(e,t).map(e=>{const t=this.findProperty(e.property.name);return{...e,property:t}});return new mapper_1.SqlConverter(e,this).convertOrderBy(t)}getValuesHash(e){const t=this.properties.filter(e=>e.isStored&&!e.isSystemProperty).map(e=>e.name),r=_.zipObject(t,t.map(t=>{const r=e[t];return r instanceof ts_api_1.Node?r._id:r??this.findProperty(t).getTypeDefaultValue()})),replacer=(e,t)=>!(0,utils_2.isScalar)(t)&&!Array.isArray(t)?_.pick(t,Object.keys(t).sort((e,t)=>e>t?1:-1)):t;return crypto.createHash("SHA256").update(JSON.stringify(r,replacer)).digest("base64")}getTableColumns(){return this.createNewTableColumns(this.properties)}static getOnDeleteBehavior(e,t){if(e.isVitalParent||e.isAssociationParent||t)return"cascade";if(e.isNullable)return"noAction";return"restrict"}createForeignKey(e,t,r=false){const s=this.nodeDecorator,i=NodeFactory.getOnDeleteBehavior(t,r),a=[t.requiredColumnName],o=[system_properties_1.SystemProperties.idColumn(this).columnName];if(!e.isSharedByAllTenants)a.unshift(system_properties_1.SystemProperties.tenantIdColumn(this).columnName),o.unshift(system_properties_1.SystemProperties.tenantIdColumn(this).columnName);const n=(0,naming_1.makeName63)(`${this.tableName}_${(0,xtrem_shared_1.nameToSqlName)(t.name)}_fk`);return new schema_1.ForeignKey({name:n,columnNames:a,targetColumnNames:o,targetTable:s.name===e.name?this.requiredTableName:e.tableName||(0,xtrem_shared_1.nameToSqlName)(e.name),onDeleteBehaviour:i,isDeferrable:true})}getForeignKeys(){const e=[];this.properties.filter(e=>e.isReferenceProperty()&&e.isStored&&!e.isInherited).forEach(t=>{const r=t.targetFactory,s=this.createForeignKey(r,t);if(s)e.push(s)});const t=this.baseFactory;if(t){const r=this.propertiesByName._id,s=this.createForeignKey(t,r,true);if(s)e.push(s)}if(!this.isSharedByAllTenants)if(utils_1.testPackageExclusions.includes(this.application.mainPackage.name));else e.push(new schema_1.ForeignKey({name:(0,naming_1.makeName63)(`${this.tableName}__tenant_id_fk`),columnNames:["_tenant_id"],targetColumnNames:["tenant_id"],targetTable:"sys_tenant",onDeleteBehaviour:"restrict",isDeferrable:true}));return e}makeTable(){const e=this.getTableColumns();if("sql"===this.storage||"external"===this.storage)this.properties.filter(e=>e.isForeignNodeProperty()).forEach(e=>{if(!e.targetFactory)throw this.missingPropertyDecorator(e.name,"node")});const t="sql"===this.storage?this.getForeignKeys():[];return new schema_1.Table({factory:this,columns:e,foreignKeys:t})}missingClassDecorator(e){return this.systemError(`${e} decorator missing`)}missingPropertyDecorator(e,t){return this.systemError(`${e}: ${t} decorator missing or incomplete`)}getNodeSchemaDescription(){return(0,node_factory_utils_1.getSchemaDescription)(this.name,this.name)}static async fixSequences(e,t){const r=e.getAllSortedFactories();return await(0,xtrem_async_helper_1.asyncArray)(r).forEach(e=>e.fixAutoIncrementSequences(t)),r}async fixAutoIncrementSequences(e){if(this.externalStorageManager)return;if(await this.table.fixAutoIncrementSequences(e),this.baseFactory)await this.baseFactory.fixAutoIncrementSequences(e)}async ensureTableExists(e,t){await this.table.ensureTableExists(e,t)}async ensureAllTableColumnsExists(e){await this.table.ensureAllTableColumnsExists(e)}async dropTable(e,t){if(await this.table.tableExists(e))await this.table.dropTable(e,t)}resolveKeyFilter(e,t){const r=Array.isArray(e)?e:e.split("|").reverse(),s="external"===this.storage?this.keyPropertyNames:this.naturalKey;if(s)return s.reduce((e,s)=>{const i=this.findProperty(s);if(i.isReferenceProperty()){const a=r[r.length-1];if(""===a||void 0===a)r.pop(),e[s]=null;else{const a=i.targetFactory;if(a.naturalKey||"external"===a.storage)e[s]=a.resolveKeyFilter(r,[...t,s,a.name])}return e}let a=r.pop();if(i.isBooleanProperty())if("true"===a)a=true;else if("false"===a)a=false;return e[s]=""===a||void 0===a?null:a,e},{});throw new Error(`Node ${this.name} does not have a natural key index.`)}parseNodeId(e){if(Number.isFinite(Number(e)))return{_id:Number(e)};if(!e)return{};if("string"==typeof e)return this.resolveKeyFilter(e.startsWith("#")?e.substring(1):e,[this.name]);throw new Error(`${this.name}: Cannot parse value ${e}.`)}getNaturalKeyStringValue(e,t){if(!this.naturalKey)throw this.logicError("no natural key");return(0,xtrem_async_helper_1.asyncArray)(this.naturalKey).map(async r=>{const s=this.findProperty(r),i=t[s.name];if(!i)return"";if(s.isReferenceProperty()){if(i&&"object"==typeof i)return s.targetFactory.getNaturalKeyStringValue(e,i);if(s.targetFactory.naturalKey){const t=Number.isFinite(i)&&"sql"===s.targetFactory.storage?Number(i):`#${i}`,r=await e.read(s.targetFactory.nodeConstructor,{_id:t});return s.targetFactory.getNaturalKeyStringValue(e,r.$.state.values)}}return i?String(i):""}).join("|")}getNaturalKeyValueFromNode(e){if(!this.naturalKey)throw this.logicError("no natural key");return(0,xtrem_async_helper_1.asyncArray)(this.naturalKey).reduce(async(t,r)=>{const s=this.findProperty(r),i=await e.$.get(s.name);if(i&&s.isReferenceProperty()){if(i instanceof ts_api_1.Node)if(s.targetFactory.naturalKey)t[r]=await s.targetFactory.getNaturalKeyValueFromNode(i);else t[r]=i._id}else t[r]=i;return t},{})}getNaturalKeyValueLength(){if(!this.naturalKey)throw this.logicError("no natural key");return this.naturalKey.reduce((e,t)=>{const r=this.findProperty(t);let s=e;if(r.isReferenceProperty()&&r.targetFactory.naturalKey)s+=r.targetFactory.getNaturalKeyValueLength();else s+=1;return s},0)}getReverseVitalProperty(){if(this.vitalParentFactory){const e=this.vitalParentFactory.properties.filter(e=>e.isReferenceProperty()&&e.targetFactory.name===this.name);if(1!==e.length)throw new Error(`Vital parent property ${this.vitalParentProperty.name} must have a unique child property ${this.name}`);return e[0]}return}get adminOperations(){return this.nodeDecorator.adminOperations}get isCustomizable(){if(void 0!==this.nodeDecorator.isCustomizable)return this.nodeDecorator.isCustomizable;if(this.baseFactory)return this.baseFactory.isCustomizable;return false}get isSynchronizable(){return!!this.nodeDecorator.isSynchronizable||!!this.baseFactory?.isSynchronizable}get isSynchronized(){return!!this.nodeDecorator.isSynchronized}get defaultsToSingleMatch(){return!!this.nodeDecorator.defaultsToSingleMatch}get denyReadOnLookupOnlyAccess(){return!!this.nodeDecorator.denyReadOnLookupOnlyAccess}getOperationByName(e,t){return this.mutations.find(r=>{const s=["bulkMutation","asyncMutation"].includes(r.operationKind);return r.name===e&&(s&&r.action===(t??"start")||!s)})||this.queries.find(r=>{const s=["bulkMutation","asyncMutation"].includes(r.operationKind);return r.name===e&&(s&&r.action===(t??"start")||!s)})}get authorizedBy(){return this.nodeDecorator.authorizedBy}executeRule(e,t,...r){const s=this.events[t]||this.nodeDecorator[t];return e.context.sqlSpy.withRuleMetrics({nodeName:this.name,propertyName:"",ruleName:t},()=>s.apply(e.node,r))}broadcastCrudMessage(e,t){if(!e.managedExternal){const r=`${this.name}/${t}`;e.broadcastToAllUsers({category:xtrem_shared_1.NOTIFICATION_CATEGORY_NODE_MODIFIED,payload:r,afterCommit:true})}}}exports.NodeFactory=NodeFactory;
//# sourceMappingURL=node-factory.js.map