/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.NodeFactoryCache=void 0;const xtrem_metrics_1=require("@sage/xtrem-metrics"),loggers_1=require("./loggers"),emptyCounters={ignored:0,countQueries:0,fetches:0,misses:0,invalidations:0};class NodeFactoryCache{#e=false;#t={...emptyCounters};constructor(e){this.factory=e,this.factory.application.globalCache.setCategoryTokens(this.cacheCategory,this.factory.getAllTableNames())}get cacheCategory(){return`$${this.factory.isSharedByAllTenants?"SHARED_NODE":"NODE"}.${this.factory.name}`}async fetch(e,t){if(!this.factory.isCached||t.ignoreCache)return this.#t.ignored+=1,(await t.getValue()).value;const getValue=()=>(this.#t.misses+=1,xtrem_metrics_1.DebugMetrics.withMetrics("nodeCache",`${this.factory.name}.miss`,()=>t.getValue()));return this.#t.fetches+=1,xtrem_metrics_1.DebugMetrics.withMetrics("nodeCache",`${this.factory.name}.query`,()=>e.getCachedValue({category:this.cacheCategory,key:t.getKey(),getValue,isolateInContext:t.isolateInContext,cacheInMemory:this.factory.isCached,ttlInSeconds:3600}))}async invalidate(e){if(!this.factory.isCached)return;this.#t.invalidations+=1,await e.invalidateCachedCategory(this.cacheCategory,{skipNotify:true})}get counters(){const e=this.#t,t=e.ignored+e.misses+e.countQueries,r=e.ignored+e.fetches+e.countQueries,percent=(e,t)=>`${Math.round(100*e/(t||1))}%`;return{totalMisses:t,totalQueries:r,totalHitRate:percent(r-t,r),fetchHitRate:percent(e.fetches-e.misses,e.fetches),...e}}postToNewRelic(){if(!this.#e)return;loggers_1.loggers.performance.verbose(()=>`Node cache: ${this.performanceSummary}`);try{(0,xtrem_metrics_1.recordCustomEventToNewrelic)("NodeCache",{nodeName:this.factory.name,...this.#t})}catch({stack:e,message:t}){loggers_1.loggers.performance.warn(`Failed to send NodeCache to newrelic ${e||t}`)}this.#e=false}get performanceSummary(){const e=this.counters;return`${this.factory.name}: ${Object.keys(e).map(t=>`${t}: ${e[t]}`).join(", ")}`}incrementCountQueryCounter(){this.#e=true,this.#t.countQueries+=1}incrementIgnoredCounter(){this.#e=true,this.#t.ignored+=1}}exports.NodeFactoryCache=NodeFactoryCache;
//# sourceMappingURL=node-factory-cache.js.map