/** @packageDocumentation @module runtime */
import { Application, Package } from '../application';
import { TypeName } from '../decorators';
import { AnyOrderBy, Node } from '../ts-api';
import { Context } from './context';
import { Enum } from './property';
export interface IntrospectionPropertyDescriptor {
    name: string;
    type: TypeName;
    isNullable: boolean;
    isPublished: boolean;
    code: string | null;
    isStored: boolean;
    columnType: TypeName | null;
    enum: Enum | null;
    node: typeof Node | null;
    isNotEmpty: boolean;
    maxLength: number;
    precision: number;
    scale: number;
    isRequired: boolean;
}
export interface IntrospectionIndexDescriptor {
    isUnique: boolean;
    orderBy: AnyOrderBy;
}
export interface IntrospectionNodeDescriptor {
    application: Application;
    package: Package;
    name: string;
    tableName?: string;
    properties: IntrospectionPropertyDescriptor[];
    indexes: IntrospectionIndexDescriptor[];
}
export declare class Introspection {
    private readonly context;
    constructor(context: Context);
    getNodeFromTableName(tableName: string): typeof Node | undefined;
    getPropertyNameFromColumnName(clas: typeof Node, columnName: string): string | null;
    getNodeDescriptor(clas: typeof Node): IntrospectionNodeDescriptor;
}
//# sourceMappingURL=introspection.d.ts.map