/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";var __decorate=this&&this.__decorate||function(e,t,o,r){var a,s=arguments.length,i=s<3?t:null===r?r=Object.getOwnPropertyDescriptor(t,o):r;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)i=Reflect.decorate(e,t,o,r);else for(var l=e.length-1;l>=0;l--)if(a=e[l])i=(s<3?a(i):s>3?a(t,o,i):a(t,o))||i;return s>3&&i&&Object.defineProperty(t,o,i),i};Object.defineProperty(exports,"__esModule",{value:true}),exports.GlobalLock=exports.SysGlobalLock=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),decorators_1=require("../decorators"),ts_api_1=require("../ts-api"),loggers_1=require("./loggers"),dataTypes=require("./system-data-types");let SysGlobalLock=class SysGlobalLock extends ts_api_1.Node{};exports.SysGlobalLock=SysGlobalLock,__decorate([decorators_1.decorators.stringProperty({dataType:()=>dataTypes.cacheKey,isStored:true})],SysGlobalLock.prototype,"key",void 0),exports.SysGlobalLock=SysGlobalLock=__decorate([decorators_1.decorators.node({isPublished:false,storage:"sql",canCreate:true,canDeleteMany:true,isPlatformNode:true,indexes:[{orderBy:{key:1},isUnique:true}]})],SysGlobalLock);const logger=loggers_1.loggers.globalLock;class GlobalLock{constructor(e){this.application=e,this._initFunnel=(0,xtrem_async_helper_1.funnel)(1),this._isInitialized=false}async _initIfNeeded(e){await this._initFunnel(async()=>{if(this._isInitialized)return;await this.application.getFactoryByConstructor(SysGlobalLock).ensureTableExists(e,{skipDrop:true}),this._isInitialized=true})}async acquire(e,t){if(await this._initIfNeeded(e),!e.transaction.isWritable)throw new Error("Exclusive processes can only be run inside a writable transaction");const o=logger.info(`Try to acquire lock '${t}'`,{lowThreshold:50,highThreshold:200});return logger.doAsync(async()=>{let r=await e.tryRead(SysGlobalLock,{key:t},{forUpdate:true});if(null==r)if(await this.application.asRoot.withCommittedContext(e.tenantId,async e=>{logger.verbose(()=>`Created lock '${t}'`);try{r=await e.create(SysGlobalLock,{key:t}),await r.$.save()}catch(e){logger.warn(`Race condition during creation of global lock: ${e.message}`)}},{description:()=>`Create lock key ${t}`}),e.prefetcher.reset(),r=await e.tryRead(SysGlobalLock,{key:t},{forUpdate:true}),!r)throw new Error(`Could not acquire lock '${t}'`);return o.success(),r},{onError:e=>{throw o.fail(e.toString()),e}})}}exports.GlobalLock=GlobalLock;
//# sourceMappingURL=global-lock.js.map