/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.ServiceOptionManager=exports.PackageManager=exports.CoreHooks=void 0;const xtrem_shared_1=require("@sage/xtrem-shared"),application_1=require("../application"),chatbot_manager_1=require("../application/chatbot-manager"),client_settings_manager_1=require("../application/client-settings-manager"),csv_checksum_manager_1=require("../application/csv-checksum-manager"),dashboard_manager_1=require("../application/dashboard-manager"),notification_manager_1=require("../application/notification-manager"),package_manager_1=require("../application/package-manager");Object.defineProperty(exports,"PackageManager",{enumerable:true,get:function(){return package_manager_1.PackageManager}});const package_manager_stub_1=require("../application/package-manager-stub"),sage_ai_manager_1=require("../application/sage-ai-manager"),service_option_manager_1=require("../application/service-option-manager");Object.defineProperty(exports,"ServiceOptionManager",{enumerable:true,get:function(){return service_option_manager_1.ServiceOptionManager}});const service_option_manager_stub_1=require("../application/service-option-manager-stub"),auditing_1=require("../hooks/auditing"),workflow_1=require("../workflow"),loaded_once_1=require("./loaded-once");(0,loaded_once_1.loadedOnce)("core-hooks");class CoreHooks{static{this.createPackageManager=e=>new package_manager_stub_1.PackageManagerStub(e)}static{this.createServiceOptionManager=e=>new service_option_manager_stub_1.ServiceOptionManagerStub(e)}static{this.createHotUpgradeManager=()=>new application_1.HotUpgradeManagerStub}static{this.createDashboardManager=()=>new dashboard_manager_1.DashboardManagerStub}static{this.getChatbotManager=()=>new chatbot_manager_1.ChatbotManagerStub}static{this.createPrintingManager=()=>null}static{this.createClientSettingsManager=()=>new client_settings_manager_1.ClientSettingsManagerStub}static{this.createNotificationManager=()=>new notification_manager_1.NotificationManagerStub}static{this.createCsvChecksumManager=()=>new csv_checksum_manager_1.CsvChecksumManagerStub}static{this.getDataValidationManager=()=>{throw new xtrem_shared_1.LogicError("DataValidation manager has not been registered")}}static{this.createWorkflowManager=()=>new workflow_1.WorkflowManagerStub}static{this.auditManager=auditing_1.auditManagerStub}static{this.getAttachmentManager=()=>{throw new xtrem_shared_1.LogicError("Attachment manager has not been registered")}}static{this.getTagManager=()=>{throw new xtrem_shared_1.LogicError("Tag manager has not been registered")}}static{this.getNoteManager=()=>{throw new xtrem_shared_1.LogicError("Note manager has not been registered")}}static{this.getSageAiManager=()=>new sage_ai_manager_1.SageAiManagerStub}static{this.testManager={async loadTestData(e,t,a){},async initTestTenantActivePackages(e){}}}static{this.webSocketHandlers={}}static{this.communicationManager={notify(e,t,a){throw new xtrem_shared_1.LogicError(`cannot send ${t} notification: notification middleware not installed`)},startAsyncMutation(e,t,a,r){throw new xtrem_shared_1.LogicError(`cannot start ${t}/${a} async operation: notification middleware not installed`)},trackAsyncMutation(e,t,a,r){throw new xtrem_shared_1.LogicError(`cannot track ${a} async mutation: notification middleware not installed`)},requestStop(e,t,a){throw new xtrem_shared_1.LogicError(`cannot request a stop on ${t} async mutation: notification middleware not installed`)},setStopped(e,t){throw new xtrem_shared_1.LogicError(`cannot set ${t} async mutation to stopped: notification middleware not installed`)},requestUserNotification(e,t){throw new xtrem_shared_1.LogicError(`cannot set ${t} async mutation to notify the user: notification middleware not installed`)},isStopRequested(e){throw new xtrem_shared_1.LogicError("cannot call isStopRequested: notification middleware not installed")},extendClassDecorator(e){},updateProgress(e,t){throw new xtrem_shared_1.LogicError("cannot call updateProgress: notification middleware not installed")},logErrorBatchMessage(e,t){throw new xtrem_shared_1.LogicError("cannot call logErrorBatchMessage: notification middleware not installed")}}}static{this.interopManager={getInteropAppInfo(e,t){throw new xtrem_shared_1.LogicError("cannot call getInteropAppInfo: interop manager not installed")},interopProxyMiddleware:e=>(e,t)=>{t.status(404).send("not found")},getTenantApps(e){throw new xtrem_shared_1.LogicError("cannot call getTenantApps: interop manager not installed")},fixInteropTransformationsActivation(e,t){}}}static{this.metadataManager={upgradeMetadata(e,t){},getMetaNodeFactoryConstructor:()=>null}}static{this.sysManager={getUserNode(){throw new Error("User node not set")}}}static{this.customizationManager={getWizardUrl:()=>"",getCustomFields:(e,t,a)=>Promise.resolve(void 0)}}static{this.importExportManager={executeExport:(e,t,a,r,n)=>Promise.resolve(""),executeExportByDefinition:(e,t,a,r,n,o)=>Promise.resolve(""),getNodeExportTemplates:(e,t)=>Promise.resolve({}),getExportPageUrl:()=>""}}static{this.remoteAppManager={getRemoteAppToken:e=>e.remoteContext?.callbackToken??null,getLocalUserFromRemoteUser:e=>null}}}exports.CoreHooks=CoreHooks;
//# sourceMappingURL=core-hooks.js.map