/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.ContextVault=void 0;const xtrem_config_1=require("@sage/xtrem-config"),xtrem_shared_1=require("@sage/xtrem-shared"),crypto=require("crypto"),nanoid_1=require("nanoid"),secret_manager_1=require("./secret-manager");class ContextVault{#e;static#t=(0,xtrem_shared_1.createDictionary)();constructor(e){this.context=e,this.#e=(0,xtrem_shared_1.createDictionary)(),this.ivLength=16,this.cryptoAlgorithm="aes-256-gcm"}recordValue(e){if(!e)return e;const t=(0,nanoid_1.nanoid)();return this.#e[t]={encryptedValue:e},t}getValueFromVault(e){if(!e)return e;const t=this.#e[e]??ContextVault.#t[e];if(!t)throw new xtrem_shared_1.LogicError(`invalid vault key: ${e}`);return t.encryptedValue}async encrypt(e){if(!e)return e;const t=crypto.randomFillSync(Buffer.allocUnsafe(16));if(t.length!==this.ivLength)throw new xtrem_shared_1.LogicError(`encrypt iv must be exactly 16 bytes, but received ${t.length}`);const r=crypto.createCipheriv(this.cryptoAlgorithm,await this.getEncryptionKey(),t);let a=r.update(e);return a=Buffer.concat([a,r.final()]),`${t.toString("hex")}:${a.toString("hex")}`}async decrypt(e){if(!e)return e;const[t,r]=this.getValueFromVault(e).split(":").map(e=>Buffer.from(e,"hex"));return crypto.createDecipheriv(this.cryptoAlgorithm,await this.getEncryptionKey(),t).update(r).toString()}async encrypt64(e){const t=crypto.randomFillSync(Buffer.alloc(this.ivLength)),r=await this.getEncryptionKey(),a=crypto.createCipheriv(this.cryptoAlgorithm,r,t);let n=a.update(e);return n=Buffer.concat([n,a.final()]),[t.toString("base64"),n.toString("base64"),a.getAuthTag().toString("base64")].join(".")}async decrypt64(e){const[t,r,a]=e.split("."),n=Buffer.from(t,"base64"),c=Buffer.from(r,"base64"),o=Buffer.from(a,"base64"),i=await this.getEncryptionKey(),s=crypto.createDecipheriv(this.cryptoAlgorithm,i,n);s.setAuthTag(o);const u=s.update(c);return Buffer.concat([u,s.final()]).toString()}async getEncryptionKey(){const e={xtremEnv:process.env.XTREM_ENV,clusterId:this.context.clusterId},t=await secret_manager_1.SecretManager.getTenantEncryptionKey(e,this.context.tenantId||"*");return Buffer.from(t,"base64")}static getConfigSecretValue(e){const t={xtremEnv:process.env.XTREM_ENV,clusterId:xtrem_config_1.ConfigManager.current.clusterId};return secret_manager_1.SecretManager.getConfigSecretValue(t,e)}cacheValues(e,t,r){if(!r||0===r.length)return;for(const a of r){const r=t[a.name];if("string"==typeof r&&21===r.length){const t=this.#e[r];if(!t)return;t.category=e,ContextVault.#t[r]=t}}}static invalidateCache(e,t){if(t)delete ContextVault.#t[t];else for(const t of Object.keys(ContextVault.#t)){if(ContextVault.#t[t].category===e)delete ContextVault.#t[t]}}async createHmac(e){const t=await this.getEncryptionKey();return crypto.createHmac("sha256",t).update(e).digest("hex")}}exports.ContextVault=ContextVault;
//# sourceMappingURL=context-vault.js.map