import { AnyValue } from '@sage/xtrem-shared';
import { NodeRuleName } from '../decorators/node-decorators/node-events';
import { PropertyRuleName } from '../decorators/property-decorators/base-property-events';
import { NodeFactory } from '../system-exports';
import { Context } from './context';
export type SqlVerb = 'SELECT' | 'INSERT' | 'UPDATE' | 'DELETE';
export declare class ContextSqlSpy {
    private readonly context;
    private readonly startMillis;
    private readonly isEnabled;
    constructor(context: Context);
    private static globalPerfCounters;
    private perfCounters;
    private ruleKey;
    private static logCounters;
    incrementCounter(factory: NodeFactory, verb: SqlVerb): void;
    withRuleMetrics<ResultT extends AnyValue>(metrics: {
        nodeName: string;
        propertyName: string;
        ruleName: NodeRuleName | PropertyRuleName;
    }, body: () => Promise<ResultT>): Promise<ResultT>;
}
//# sourceMappingURL=context-sql-spy.d.ts.map