/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.ContextPrefetcher=void 0,exports.camelCase=camelCase;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_config_1=require("@sage/xtrem-config"),_=require("lodash"),lodash_1=require("lodash"),__1=require("..");function camelCase(e){const t=_.camelCase(e);return"_"===e[0]?`_${t}`:t}class ContextPrefetcher{constructor(e){this.context=e,this.factoryBuckets={}}spy(e,...t){const r=xtrem_config_1.ConfigManager.current.storage?.prefetch?.spiedNodeNames;if(!r?.length)return;if(r.some(t=>"~"===t[0]?new RegExp(t.substring(1)).test(e.name):t===e.name))console.log(e.name,...t)}skipFactory(e){if(xtrem_config_1.ConfigManager.current.storage?.prefetch?.isDisabled)return true;if(this.context.managedExternal||e.externalStorageManager)return true;if(e.isVitallyCached)return true;return false}getFactoryBucket(e,t){const r=`${e.name}.${t}`;let i=this.factoryBuckets[r];if(!i)i={factory:e,forUpdate:t,pendingSysIds:new Set,fetchedRecords:new Map,referenceBuckets:new Map,collectionBuckets:new Map,funnel:(0,xtrem_async_helper_1.funnel)(1)},this.factoryBuckets[r]=i;return i}getReferenceBucket(e,t,r){if("_id"===t)throw new __1.LogicError("Cannot create reference bucket for _id");const i=this.getFactoryBucket(e,r);let s=i.referenceBuckets.get(t);if(s)return s;return s={factoryBucket:i,bucketId:t,pendingRecordKeys:new Set,fetchedSysIds:new Map},i.referenceBuckets.set(t,s),s}getCollectionBucket(e,t,r){const i=this.getFactoryBucket(e,r);let s=i.collectionBuckets.get(t);if(s)return s;return s={factoryBucket:i,bucketId:t,pendingRecordKeys:new Set,fetchSysIdArrays:new Map},i.collectionBuckets.set(t,s),s}getFetchedRecord(e,t){const r=e.fetchedRecords.get(t);if(!r)throw e.factory.logicError(`record not found: {"_id":${t}}`);return r}getFetchedCollectionRecords(e,t,r,i){const s=this.getFactoryBucket(e,r),c=s.collectionBuckets.get(t)?.fetchSysIdArrays.get(i);return c?c.map(e=>this.getFetchedRecord(s,e)):void 0}isSysIdValid(e){return Number(e)>0}getSysId(e){if("number"==typeof e)return String(e);if("string"==typeof e)return e;if(e&&"object"==typeof e)return this.getSysId(e._id);return""}formatRecordKey(e){if(1===e.length&&"number"==typeof e[0])return String(e[0]);if(e.some(e=>e&&"object"==typeof e))throw new __1.LogicError("Cannot format record id with objects");return JSON.stringify(e.map(e=>null===e?null:"boolean"==typeof e?e:String(e)))}parseRecordKey(e){if("["!==e[0])return[e];return JSON.parse(e)}formatBucketId(e){return e.join("|")}parseBucketId(e){return e.split("|")}getValidKeyValue(e){if(null==e)return e;if(!(0,__1.isScalar)(e))return e._id;if("string"==typeof e){if("#"===e[0])return;if(e.startsWith("_id:"))return e.substring(4);return e}if("boolean"==typeof e)return e;return String(e)}getReferenceBucketIdAndKey(e,t){if(!e)return;const r=e.map(e=>this.getValidKeyValue(t[e]));if(r.some(e=>void 0===e))return;return{bucketId:this.formatBucketId(e),recordKey:this.formatRecordKey(r)}}visitSysId(e,t,r){if(this.skipFactory(e))return;const i=this.getFactoryBucket(e,t);if(i.pendingSysIds.has(r))return;if(i.fetchedRecords.has(r))return;this.spy(e,"Visit add _id key",t,r),i.pendingSysIds.add(r)}visitReferenceKey(e,t,r,i){const s=this.getReferenceBucket(e,t,r);if(s.pendingRecordKeys.has(i))return;if(s.fetchedSysIds.has(i))return;this.spy(e,"Visit add reference key",t,r,i),s.pendingRecordKeys.add(i)}visitCollectionKey(e,t,r,i){if(this.skipFactory(e))return;const s=this.getCollectionBucket(e,t,r);if(s.pendingRecordKeys.has(i))return;if(s.fetchSysIdArrays.has(i))return;this.spy(e,"Visit add collection key",t,r,i),s.pendingRecordKeys.add(i)}visitUniqueIndex(e,t,r,i){const s=this.getReferenceBucketIdAndKey(r,i);if(s)this.visitReferenceKey(e,s.bucketId,t,s.recordKey)}visitUniqueIndexes(e,t,r){return e.uniqueKeyProperties.slice(1).forEach(i=>{this.visitUniqueIndex(e,t,i,r)})}visitReferenceProperty(e,t,r){const i=t.targetFactory;if(t.isVital||t.isAssociation){const s=r[t.name];if(s&&"object"==typeof s){const c=e;this.visit(i,c,t.isVital?{[i.vitalParentProperty.name]:r,...s}:r)}else if(t.reverseReference&&this.isSysIdValid(r._id))this.visitReferenceKey(i,t.reverseReference,e,String(r._id))}else{const s=t.isVitalParent||t.isAssociationParent?e:false,c=this.getSysId(r[t.name]);if(this.isSysIdValid(c))this.visitSysId(i,s,c);else if(t.decorator.prefetch){const e=t.decorator.prefetch(r);if(!e)return;const c=Object.values(e).map(this.getValidKeyValue);if(this.spy(i,"Calling prefetch rule",t.fullName,c),c.some(e=>void 0===e))return;const o=this.formatBucketId(Object.keys(e)),n=this.formatRecordKey(c);this.visitReferenceKey(i,o,s,n)}}}visitCollectionProperty(e,t,r){if(!t.reverseReference)return;const i=t.targetFactory;if(t.isVital||t.isAssociation){const s=r[t.name];if(s&&Array.isArray(s))s.forEach(t=>{if(t&&"object"==typeof t){const s=e;this.visit(i,s,{[i.vitalParentProperty.name]:r,...t})}});else if(t.reverseReference&&this.isSysIdValid(r._id))this.visitCollectionKey(i,t.reverseReference,e,String(r._id))}else if(t.decorator.prefetch){const s=t.isVital||t.isAssociation?e:false,c=t.decorator.prefetch(r);if(!c)return;if(Object.values(c).some(e=>void 0===e))return;const o=this.formatBucketId(Object.keys(c)),n=this.formatRecordKey(Object.values(c));this.visitCollectionKey(i,o,s,n)}}visitProperties(e,t,r){e.properties.forEach(e=>{if(e.isReferenceProperty())this.visitReferenceProperty(t,e,r);else if(e.isCollectionProperty())this.visitCollectionProperty(t,e,r)})}prepareRecordForVisit(e,t,r){if(!e.isVitalChild)return r;const i=e.vitalParentProperty,s=r[i.name];if("object"==typeof s)return r;if(!this.isSysIdValid(s))return r;const c=this.getFactoryBucket(i.targetFactory,t).fetchedRecords.get(String(s));return c?{...r,[i.name]:c}:r}visit(e,t,r){if(!r)return;if(this.skipFactory(e))return;if(this.isSysIdValid(r._id))this.visitSysId(e,t,String(r._id));const i=this.prepareRecordForVisit(e,t,r);this.visitUniqueIndexes(e,t,i),this.visitProperties(e,t,i)}addRecordToReferenceBucket(e,t,r,i,s){const c=this.getReferenceBucket(e,t,r);if(c.pendingRecordKeys.has(i))c.pendingRecordKeys.delete(i);const o=s?._id?String(s._id):null;if(!c.fetchedSysIds.has(i))this.spy(e,"Adding fetched record",t,r,i,o);c.fetchedSysIds.set(i,o)}addRecordToFactoryBucket(e,t,r){if(!r._id)throw e.logicError(`Logic error: _id missing in record: ${JSON.stringify(r)}`);if(!this.isSysIdValid(r._id))throw e.logicError(`Logic error: _id invalid in record: ${JSON.stringify(r)}`);const i=String(r._id),s=this.getFactoryBucket(e,t);if(s.pendingSysIds.has(i))s.pendingSysIds.delete(i);if(!s.fetchedRecords.has(i))this.spy(e,"Adding fetched record","_id",t,i);s.fetchedRecords.set(i,r)}addRecordToUniqueIndexBucket(e,t,r,i){const s=this.getReferenceBucketIdAndKey(r,i);if(s)this.addRecordToReferenceBucket(e,s.bucketId,t,s.recordKey,i)}addRecordToUniqueIndexesBuckets(e,t,r){e.uniqueKeyProperties.slice(1).forEach(i=>{this.addRecordToUniqueIndexBucket(e,t,i,r)})}addRecord(e,t,r){if(this.skipFactory(e))return;this.addRecordToFactoryBucket(e,t,r),this.addRecordToUniqueIndexesBuckets(e,t,r),this.visit(e,t,r)}async fetchPendingRecords(e,t,r,i,s){if(0===i.length)return;const c=await e.getAccessRightsFilter(this.context);let o;const n=this.parseBucketId(t);if(n.length>1)o={_or:i.map(e=>(0,lodash_1.zipObject)(n,this.parseRecordKey(e)))};else o={[t]:{_in:i.map(e=>this.parseRecordKey(e)[0])}};const d={...c,...o},a=await e.createNodeQuery(this.context,{filter:d,forUpdate:r,orderBy:s}),f=await a.getDataReader().readAll();if(this.spy(e,"Fetched pending records",t,r,i,f.length),f.forEach(t=>{this.addRecord(e,r,t)}),"_id"!==t)i.forEach(i=>this.visitReferenceKey(e,t,r,i));return f}async fetchPendingReferences(e){const{factory:t,forUpdate:r}=e.factoryBucket,i=e.bucketId,s=Array.from(e.pendingRecordKeys),c=await this.fetchPendingRecords(t,i,r,s);if(!c)return;s.forEach(i=>{if(!e.fetchedSysIds.has(i))this.addRecordToReferenceBucket(t,e.bucketId,r,i,null)}),c.forEach(e=>{this.visit(t,r,e)})}async fetchPendingCollections(e,t){const{factory:r,forUpdate:i}=e.factoryBucket,s=e.bucketId,c=Array.from(e.pendingRecordKeys),o=await this.fetchPendingRecords(r,s,i,c,t);if(!o)return;c.forEach(t=>{e.fetchSysIdArrays.set(t,[])});const n=s.split("|");o.forEach(t=>{const r=this.formatRecordKey(n.map(e=>t[e])),i=e.fetchSysIdArrays.get(r);if(!i)throw new __1.LogicError(`${s}: collection array not found: ${r}`);i.push(String(t._id))}),e.pendingRecordKeys.clear(),o.forEach(e=>{this.visit(r,i,e)})}async readKeyValue(e,t,r,i){const s=this.getReferenceBucket(e,t,r),c=s.factoryBucket;if(!s.fetchedSysIds.has(i))s.pendingRecordKeys.add(i),await this.fetchPendingReferences(s);const o=s.fetchedSysIds.get(i);if(!o)s.fetchedSysIds.set(i,null);return o?c.fetchedRecords.get(o):null}async tryReadSysId(e,t,r){const i=this.getFactoryBucket(e,t);if(!i.fetchedRecords.has(r)){i.pendingSysIds.add(r);const s=Array.from(i.pendingSysIds).map(String);await this.fetchPendingRecords(e,"_id",t,s)}return i.fetchedRecords.get(r)}tryRead(e,t,r){if(this.skipFactory(e))return Promise.resolve(void 0);return this.spy(e,"Try read",t,r),this.getFactoryBucket(e,r).funnel(()=>{if(t._id){if(!this.isSysIdValid(t._id))return Promise.resolve(void 0);return this.tryReadSysId(e,r,String(t._id))}const i=e.uniqueKeyProperties.slice(1);for(const s of i){const i=this.getReferenceBucketIdAndKey(s,t);if(i)return this.readKeyValue(e,i.bucketId,r,i.recordKey);if(s.length>1)for(const i of s){const s=t[i];if(s){if(this.getFetchedCollectionRecords(e,i,r,s))return Promise.resolve(null)}}}return Promise.resolve(void 0)})}tryQueryFullCollection(e,t,r,i,s){if(this.skipFactory(e))return Promise.resolve(void 0);this.spy(e,"Try query full collection",t,i,r);const c=this.getCollectionBucket(e,t,r);return c.factoryBucket.funnel(async()=>{const e=this.formatRecordKey([i]);if(!c.fetchSysIdArrays.has(e))await this.fetchPendingCollections(c,s);const t=c.fetchSysIdArrays.get(e);if(!t)return;return t.map(e=>this.getFetchedRecord(c.factoryBucket,e))})}invalidateCollectionBuckets(e,t){this.getFactoryBucket(e,t).collectionBuckets.forEach(e=>{Array.from(e.fetchSysIdArrays.keys()).forEach(t=>{e.pendingRecordKeys.add(t)}),e.fetchSysIdArrays.clear()})}insertRecord(e,t,r){if(e.baseFactory)this.insertRecord(e.baseFactory,t,r);this.addRecord(e,t,r),this.invalidateCollectionBuckets(e,t),delete this.factoryBuckets[`${e.name}.${!t}`]}afterInsert(e,t){if(this.skipFactory(e))return;this.spy(e,"After insert",t._id),this.insertRecord(e,false,t)}updateRecord(e,t,r){if(e.baseFactory)this.updateRecord(e.baseFactory,t,r);const i=this.getFactoryBucket(e,t).fetchedRecords.get(String(r._id));if(i)e.uniqueKeyProperties.slice(1).forEach(s=>{const c=this.getReferenceBucketIdAndKey(s,i),o=this.getReferenceBucketIdAndKey(s,r);if(c&&o&&c.recordKey!==o.recordKey){const r=this.getReferenceBucket(e,c.bucketId,t);r.pendingRecordKeys.delete(c.recordKey),r.fetchedSysIds.delete(c.recordKey)}});this.addRecord(e,t,r),this.invalidateCollectionBuckets(e,t),delete this.factoryBuckets[`${e.name}.${!t}`]}afterUpdate(e,t){if(this.skipFactory(e))return;this.spy(e,"After update",t._id),this.updateRecord(e,true,t)}deleteRecord(e,t,r){if(e.baseFactory)this.deleteRecord(e.baseFactory,t,r);delete this.factoryBuckets[`${e.name}.${!t}`];const i=this.getFactoryBucket(e,t);e.uniqueKeyProperties.slice(1).forEach(i=>{const s=this.getReferenceBucketIdAndKey(i,r);if(s){const r=this.getReferenceBucket(e,s.bucketId,t);r.pendingRecordKeys.delete(s.recordKey),r.fetchedSysIds.delete(s.recordKey)}}),i.fetchedRecords.delete(String(r._id)),i.collectionBuckets.clear(),delete this.factoryBuckets[`${e.name}.${!t}`]}deleteMany(e){if(e.baseFactory)this.deleteMany(e.baseFactory);delete this.factoryBuckets[`${e.name}.false`],delete this.factoryBuckets[`${e.name}.true`]}afterDelete(e,t){if(this.skipFactory(e))return;if(this.spy(e,"After delete",t?._id),t)this.deleteRecord(e,true,t);else this.deleteMany(e)}reset(){this.factoryBuckets={}}}exports.ContextPrefetcher=ContextPrefetcher;
//# sourceMappingURL=context-prefetcher.js.map