import { integer } from '../ts-api';
import { Context } from './context';
import { NodeFactory } from './node-factory';
/**
 * Converter that converts reference ids to natural keys.
 * It is activated by context.withReferenceAsNaturalKey when running synchronization queries.
 */
export declare class ContextNaturalKeyConverter {
    #private;
    private readonly context;
    constructor(context: Context);
    /** Size of the cache */
    static cacheSize: number;
    /**
     * Converts a reference when mapping records returned by SQL queries.
     * It returns the
     */
    convertReference(factory: NodeFactory, id: integer): Promise<string | integer>;
}
//# sourceMappingURL=context-natural-key-converter.d.ts.map