/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.applyPagingOptions=applyPagingOptions,exports.dateFromString=dateFromString,exports.valueComparator=valueComparator,exports.applyOrderBy=applyOrderBy,exports.matchesFilter=matchesFilter,exports.applyFilter=applyFilter,exports.filterToString=filterToString,exports.applyPagingOperation=applyPagingOperation;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_date_time_1=require("@sage/xtrem-date-time"),xtrem_decimal_1=require("@sage/xtrem-decimal"),xtrem_shared_1=require("@sage/xtrem-shared"),lodash_1=require("lodash"),collections_1=require("../collections"),ts_api_1=require("../ts-api"),types_1=require("../types"),stream_1=require("../types/stream"),utils_1=require("./utils");async function applyPagingOptions(e,r,t,a){let n=Array.isArray(t)?t:await t.toArray(),i=n.length;if(!a)return{items:n,totalCount:i};if(a.last){if(a.first)throw new Error("first cannot be supplied with last.");if(a.after)throw new Error("after cannot be supplied with last.")}else if(a.before)throw new Error("before cannot be supplied without last.");if(a.filter)n=await applyFilter(n,a.filter,r.locales).toArray(),i=n.length;let o=[];if("external"!==e.storage)o=e.parseOrderBy(r,a.orderBy);else{if(!e.externalStorageManager)throw e.logicError("External storage manager is not defined");o=e.externalStorageManager.parseOrderBy(r,a.orderBy)}if(0!==o.length&&a.orderBy)n=await applyOrderBy(n,a.orderBy);const getCursorValue=r=>{if("external"===e.storage){if(!e.externalStorageManager)throw e.logicError("External storage manager is not defined");return e.externalStorageManager.parseCursor(o,r)}return(0,types_1.parseCursor)(o.map(e=>e.property),r)};if(null!=a.after)n=await applyPagingOperation(n,o,getCursorValue(a.after),"after").toArray();if(null!=a.before)n=await applyPagingOperation(n,o,getCursorValue(a.before),"before").toArray();if(null!=a.first&&0!==a.first)n=n.slice(0,a.first);if(null!=a.last&&0!==a.last)n=n.slice(-a.last);return{items:n,totalCount:i}}function composeComparators(e,r){return async(t,a)=>{const n=await e(t,a);if(0!==n)return n;return r(t,a)}}function dateFromString(e){return e.includes("T")?xtrem_date_time_1.DateValue.parse(e,void 0,"YYYY-MM-DDThh:mm:ss.SSSZ"):xtrem_date_time_1.DateValue.parse(e)}function valueComparator(e,r,t){if(null==e)return null==r?0:-1;if(null==r)return 1;if(xtrem_decimal_1.Decimal.isDecimal(e)||xtrem_decimal_1.Decimal.isDecimal(r))return(0,xtrem_decimal_1.compare)(e,r)||0;if(xtrem_date_time_1.DateValue.isDate(e)){if(xtrem_date_time_1.DateValue.isDate(r))return e.compare(r);if("string"==typeof r&&""!==r)return e.compare(dateFromString(r));if("number"==typeof r)return e.compare(new xtrem_date_time_1.DateValue(r));return-1}if(xtrem_date_time_1.Datetime.isDatetime(e)){if(xtrem_date_time_1.Datetime.isDatetime(r))return e.compare(r);if("string"==typeof r)return e.compare(xtrem_date_time_1.Datetime.parse(r));return-1}if(stream_1.Stream.isStream(e))return e.compareTo(r);if(Array.isArray(e))return JSON.stringify(e)===JSON.stringify(r)?0:JSON.stringify(e)<JSON.stringify(r)?-1:1;if("string"==typeof e&&"string"==typeof r)return e.localeCompare(r,t?.map(e=>"base"===e?"en":e));if(e instanceof ts_api_1.Node&&r instanceof ts_api_1.Node){if(e.$.factory.rootFactory!==r.$.factory.rootFactory)throw new xtrem_shared_1.LogicError("Cannot compare nodes with different base nodes");return valueComparator(e._id,r._id,t)}if(e instanceof ts_api_1.Node)return valueComparator(e._id,r,t);if(r instanceof ts_api_1.Node)return valueComparator(e,r._id,t);if(e==r)return 0;return e<r?-1:1}function compileOrderBy(e){let out=()=>0;return Object.keys(e).forEach((r,t)=>{const a=e[r];let n;if(-1===a||1===a)n=async(e,t)=>{async function getPropertyValue(e){if("_id"===r&&"external"!==e.$.factory.storage)return Math.abs(e._id);const t=e.$.factory.findProperty(r,{includeSystemProperties:true});let a=await e.$.state.getPropertyValue(t);if(t.isEnumProperty()&&"string"==typeof a)a=t.dataType.numberValue(a);return a}if(e===t)return 0;if(null==e)return null==t?0:-a;if(null==t)return a;return valueComparator(await getPropertyValue(e),await getPropertyValue(t),e.$.context.locales)*a};else{const t=compileOrderBy(e[r]);n=async(e,a)=>{if(null==e&&null==a)return 0;if(null==a)return t(await e[r],null);if(null==e)return t(null,await a[r]);return t(await e[r],await a[r])}}if(0===t)out=n;else out=composeComparators(out,n)}),out}function applyOrderBy(e,r){return(0,xtrem_async_helper_1.asyncArray)(e).sort((e,t)=>compileOrderBy(r)(e,t)).toArray()}function matchesFilter(e,r,t){return converter(t)(e)(r)}function applyFilter(e,r,t){const a=converter(t)(r);return(0,xtrem_async_helper_1.asyncArray)(e).filter(e=>a(e))}function filterPartToString(e,r){if(null==r)return`${e} is NULL`;if((0,utils_1.isScalar)(r))return r.toString();const t=Object.keys(r)[0],a=Object.values(r)[0],arrayToStr=r=>r.map(r=>filterPartToString(e,r));switch(t){case"_eq":return`${e} = ${a}`;case"_ne":return`${e} != ${a}`;case"_gt":return`${e} > ${a}`;case"_gte":return`${e} >= ${a}`;case"_lt":return`${e} < ${a}`;case"_lte":return`${e} <= ${a}`;case"_contains":case"_containsRange":return`${e} @> ${a}`;case"_containedBy":return`${e} <@ ${a}`;case"_in":return`${e} in [${arrayToStr(a).join(", ")}]`;case"_nin":return`${e} nin [${arrayToStr(a).join(", ")}]`;case"_and":return`(${arrayToStr(a).join(" && ")})`;case"_or":return`(${arrayToStr(a).join(" || ")})`;case"_not":return`!(${filterPartToString(e,a)})`;default:return JSON.stringify(r)}}function filterToString(e){return Object.keys(e).map(r=>filterPartToString(r,e[r])).join(" and ")}function applyPagingOperation(e,r,t,a){const n=r.map((e,n)=>{const i=[];for(let e=0;e<n;e+=1)i.push({[r[e].path.join(".")]:{_eq:t[e].value}});const o=e.direction>0?"before"===a?"_lt":"_gt":"before"===a?"_gt":"_lt";return i.push({[r[n].path.join(".")]:{[o]:t[n].value}}),1===i.length?i[0]:{_and:i}});return applyFilter(e,1===n.length?n[0]:{_or:n})}function converter(e){const pfalse=()=>false,ptrue=()=>true,valueToArray=e=>{if(Array.isArray(e))return e;return[e]},r={_eq:r=>t=>0===valueComparator(t,r,e),_ne:r=>t=>0!==valueComparator(t,r,e),_gt:r=>t=>valueComparator(t,r,e)>0,_gte:r=>t=>valueComparator(t,r,e)>=0,_lt:r=>t=>valueComparator(t,r,e)<0,_lte:r=>t=>valueComparator(t,r,e)<=0,_in:r=>t=>valueToArray(r).some(r=>0===valueComparator(r,t,e)),_nin:r=>t=>valueToArray(r).every(r=>0!==valueComparator(r,t,e)),_and:e=>and(valueToArray(e).map(cvt)),_or:e=>or(valueToArray(e).map(cvt)),_nor:e=>not(or(valueToArray(e).map(cvt))),_not:e=>not(cvt(e)),_exists:e=>r=>("string"==typeof e||"number"==typeof e)&&null!=r&&"object"==typeof r&&e in r,_type:e=>r=>typeof r===e,_mod:e=>r=>Array.isArray(e)&&"number"==typeof e[0]&&"number"==typeof r&&r%e[0]===e[1],_regex:(e,r)=>{if("string"!=typeof e)throw new xtrem_shared_1.LogicError("invalid regex type:"+typeof e);const t=new RegExp(e,r._options||"");return e=>"string"==typeof e&&t.test(e)}},reTest=e=>r=>"string"==typeof r&&e.test(r),not=e=>async r=>!await e(r),or=e=>{if(0===e.length)return pfalse;if(1===e.length)return e[0];return r=>(0,xtrem_async_helper_1.asyncArray)(e).some(e=>e(r))},and=e=>{if(0===e.length)return ptrue;if(1===e.length)return e[0];return r=>(0,xtrem_async_helper_1.asyncArray)(e).every(e=>e(r))},compose=(e,r)=>async t=>e(await r(t)),deref=e=>r=>{if(null==r)return;if("_index"===e&&r.$)return r.state.index;const t=r[e];return"function"==typeof t?t():t},walk=e=>{const r=e.indexOf(".");if(r>=0)return compose(walk(e.substring(r+1)),walk(e.substring(0,r)));return deref(e)},isQuantifiedBy=(e,r)=>r in e,quantifiedFilter=(e,r,t)=>{const a=cvt((0,lodash_1.omit)(e,r));return async r=>{let n=0;if(r instanceof collections_1.BaseCollection)n=await r.filter(a).length;if(r instanceof ts_api_1.Node&&r.$.state.collection)n=await r.$.state.collection.filter(a).length;return t(n,e)}},isFilterObject=e=>null!=e&&"object"==typeof e,cvt=e=>{if(e instanceof RegExp)return reTest(e);if(isFilterObject(e)&&isQuantifiedBy(e,"_atLeast"))return quantifiedFilter(e,"_atLeast",(e,r)=>e>=r._atLeast);if(isFilterObject(e)&&isQuantifiedBy(e,"_atMost"))return quantifiedFilter(e,"_atMost",(e,r)=>e<=r._atMost);if(isFilterObject(e)&&isQuantifiedBy(e,"_none"))return quantifiedFilter(e,"_none",(e,r)=>r._none?0===e:0!==e);if(isFilterObject(e)&&isQuantifiedBy(e,"_every"))return cvt({_not:{...(0,lodash_1.omit)(e,"_every")},_none:e&&e._every});if(e&&(0,utils_1.isCompound)(e)){if(e instanceof ts_api_1.Node)return r._eq(e);return and(Object.keys(e).map(t=>{const a=e[t];if("_options"===t)return ptrue;if("_"===t[0]&&"_id"!==t&&"_sortValue"!==t){if(!r[t])throw new xtrem_shared_1.LogicError(`bad operator: ${t}`);return r[t](a,e)}return compose(cvt(a),walk(t))}))}return r._eq(e)};return cvt}
//# sourceMappingURL=array-utils.js.map