/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.StringArrayProperty=exports.StringProperty=void 0;const property_1=require("./property"),util_1=require("./util");class StringProperty extends property_1.Property{constructor(r,t,e){super(r,t,e),this._decorator=t}get isNotEmpty(){if(this.delegatesTo)return this.getDelegatingInfo().childProperty.isNotEmpty;return!!this._decorator.isNotEmpty}get isLocalized(){if(this.delegatesTo)return this.getDelegatingInfo().childProperty.isLocalized;return this.dataType?.isLocalized}get isStoredEncrypted(){return!!this._decorator.isStoredEncrypted}get maxLength(){const r=this.dataType;if(r)return r.maxLength;return 255}isValueTypeValid(r){return"string"==typeof r}needsTypeConversion(r){return this.isLocalized&&"object"==typeof r&&Object.values(r).every(r=>this.isValueTypeValid(r))}mapInputValue(r){return JSON.stringify(r)}verify(){if(super.verify(),this.isNullable)throw this.systemError("A string property cannot be nullable");if(this.isLocalized&&!this.isStored&&null==this.delegatesTo)throw this.systemError("localized properties isStored attribute must be set to true or delegated to another property")}}exports.StringProperty=StringProperty;class StringArrayProperty extends property_1.Property{constructor(r,t,e){super(r,t,e),this._decorator=t}isValueTypeValid(r){return Array.isArray(r)&&r.every(r=>"string"==typeof r)}needsTypeConversion(r){return(0,util_1.isArrayOfStrings)(r)}mapInputValue(r){return(0,util_1.stringToArrayOfStrings)(r)}verify(){if(super.verify(),this.isNullable)throw this.systemError("A string array property cannot be nullable");if(this.isLocalized&&!this.isStored)throw this.systemError("localized properties isStored attribute must be set to true")}}exports.StringArrayProperty=StringArrayProperty;
//# sourceMappingURL=string-property.js.map