/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.Property=exports.overridableAttributes=exports.foreignNodePropertyTypes=void 0,exports.isPropertyOutputOnly=isPropertyOutputOnly,exports.isPropertyInputOnly=isPropertyInputOnly;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_config_1=require("@sage/xtrem-config"),xtrem_shared_1=require("@sage/xtrem-shared"),lodash_1=require("lodash"),decorator_utils_1=require("../decorators/decorator-utils"),context_1=require("../runtime/context"),loggers_1=require("../runtime/loggers"),sql_1=require("../sql"),types_1=require("../types"),arrays_1=require("../types/arrays"),util_1=require("../types/util");exports.foreignNodePropertyTypes=["collection","reference","jsonReference","instance","referenceArray"];const propertyLogger=loggers_1.loggers.property;exports.overridableAttributes=["name","type","columnName","dependencyIndex","extends","isOverride","defaultValue","deferredDefaultValue","duplicatedValue","updatedValue","getValue","adaptValue","prepare","control","setValue","dependsOn","updateDependsOn","upgrade","computeValue","node","isFrozen","isStored","isVitalParent","isPublished"];class Property{#e;constructor(e,t,r){if(this._decorator=t,this.definingPackage=r,this._factory=e,!this._decorator.name)throw new Error("Can't create property without name.");if(!this._decorator.type)throw new Error("Can't create property without type.");this._factory=e.application.getFactoryByName(this._factoryDecorators.node.name),this._factory.addPropertyAccessors(this)}get factory(){return this._factory}get _factoryDecorators(){return this._factory.decorators}get shouldLazyLoad(){return false}static getDecoratorsDifferences(e,t){return["isStored","isPublished","isNullable","type","isOverride","dataType"].filter(r=>{let i=e[r],s=t[r];if("boolean"==typeof i||"boolean"==typeof s)i=!!i,s=!!s;return i!==s})}getLocalizedTitleKey(){const e=this.rootProperty;if(e.isSystemProperty||"_sortValue"===e.name)return`@sage/xtrem-core/system_property_${(0,lodash_1.snakeCase)(e.name)}`;return!e.isExtendedProperty?`${e.factory.package.name}/nodes__${(0,lodash_1.snakeCase)(e.factory.name)}__property__${e.name}`:`${e.definingPackage.name}/node-extensions__${(0,lodash_1.snakeCase)(e.factory.name)}_extension__property__${e.name}`}getLocalizedTitle(e){const t=this.rootProperty,r=this.getLocalizedTitleKey();try{return e.localize(r,t.name)}catch{return propertyLogger.warn(`Could not resolve localized title for property name: ${this.factory.name}.${this.name}, key ${r}`),this.name}}verifyDelegatedToProperty(e){if(e.type!==this.type)throw this.logicError(`Invalid delegatesTo attribute: type mismatch, expected ${this.type}, got ${e.type}`);if(this.dataType&&this.dataType!==e.dataType)throw this.logicError("Invalid delegatesTo attribute: dataType mismatch")}verifyDelegatesTo(){const e=this.delegatesTo;if(!e)return;if("object"!=typeof e)throw this.logicError("delegatesTo is not an object");const t=Object.keys(e);if(1!==t.length)throw this.logicError(`Invalid delegatesTo attribute: object must have exactly one key, found ${t.length}.`);const r=this.factory.findProperty(t[0]);if(!r.isReferenceProperty())throw this.logicError(`Invalid delegatesTo attribute: property ${this.fullName} is not a reference.`);if(r.isNullable&&!this.isNullable)throw this.logicError(`Property must be nullable because its dependsOn reference ${r.fullName} is nullable`);if(!r.isMutable&&!r.isVital)throw r.logicError("Property must be marked as isVital or isMutable because it is used in delegatesTo attributes");const i=e[t[0]];if("string"!=typeof i)throw this.logicError("delegatesTo child property name is not a string");const s=r.targetFactory.propertiesByName[i];if(!s)throw this.logicError("Invalid delegatesTo attribute: child property not found");if(s.isNullable&&!this.isNullable)throw this.logicError(`Property must be nullable because its dependsOn child property ${s.fullName} is nullable`)}verifyDuplicatedValue(){if(void 0===this.decorator.duplicatedValue)return;if(!this.factory.canBeDuplicated)throw this.systemError("The duplicatedValue attribute can only be set if the node can be duplicated.")}verifyClearByReset(){if(!this.isClearedByReset)return;if(this.factory.isClearedByReset)throw this.systemError("isClearedByReset tag is already declared in the node decorator");if(!this.isStored&&null==this.delegatesTo)throw this.systemError("isClearedByReset tag can only be set to stored properties or delegated properties");if("function"==typeof this.defaultValue)throw this.systemError("isClearedByReset tag cannot be set if defaultValue is a function");if(this.factory.indexes?.some(e=>Object.keys(e.orderBy)[0]===this.name&&e.isUnique))throw this.systemError("isClearedByReset tag cannot be set on a unique index")}verifyDefaultValue(){if("UpgradeAddColumns.newMandatoryDatetimeWithDefault"===this.fullName)return;const e=this.defaultValue;if(null==e)return;if("object"!=typeof e)return;if(e.constructor===Object)return;if(e===types_1.TextStream.empty)return;if(Array.isArray(e)&&0===e.length)return;throw this.systemError("defaultValue must be a boolean, a number, a string, a function or a plain object")}verify(){const e=this._factory;if(this.definingPackage!==this.factory.package&&this.isStored)if(this.definingPackage.isService)this.systemError("Cannot define stored property in node extension inside a service package");if(void 0!==this._decorator.isNotEmpty&&"string"!==this.type)throw this.systemError("isNotEmpty attribute can only be used for string properties");if(this._decorator.node&&!exports.foreignNodePropertyTypes.includes(this.type))throw this.systemError("Invalid property definition (has a node() function but is not a reference).");if("collection"===this.type&&!this.isMutable&&this.isRequired)throw this.systemError("Non vital collection cannot be required.");if(this.verifyDuplicatedValue(),this.verifyClearByReset(),this.isReferenceProperty()&&this.isStored&&!this.isInherited&&this.column&&this.targetFactory.isClearedByReset&&this.isHardDependency)if(!e.isClearedByReset){const t=this.targetFactory.name;throw this.systemError(`target factory ${t} is flagged by isClearedByReset. The current factory ${e.name} should be also be flagged by isClearedByReset`)}if(e.table&&"collection"!==this.type&&!this.isMutable&&!this.isStored&&!this.isTransientInput&&null==this.delegatesTo&&null==this._decorator.getValue&&null==this._decorator.computeValue&&null==this.join&&this.isPublished)throw this.systemError("A published property needs either 'isStored', 'isVital', 'isMutable', 'isTransientInput', 'computeValue', 'getValue' or 'join' decorator member to be set.");if(this.isStored&&this.isTransientInput)throw this.systemError("Property attributes 'isStored' and 'isTransientInput' cannot be both true on a single property.");if(this.isStored&&null!=this._decorator.getValue)throw this.systemError("Property attribute 'isStored' or 'isStoredOutput' cannot be true when 'getValue' is supplied on a single property.");if(this.decorator.lookupAccess&&this.isTransientInput)throw this.systemError("Property attributes 'lookupAccess' and 'isTransientInput' cannot be both true on a single property.");if(!this.isPublished&&this._decorator.lookupAccess&&!["_updateStamp","_createStamp"].includes(this.name))throw this.systemError("Property attribute 'lookupAccess' cannot be true when property attribute 'isPublished' is not on a single property.");if(!this.updatedValue&&this.isStoredOutput)throw this.systemError("If 'isStoredOutput' is set to true an 'updatedValue' must be supplied.");if(this.isStored&&"sql"!==e.storage&&"external"!==e.storage)throw this.systemError(`'isStored' decorator member is invalid on non-persistent class, got ${e.storage}`);if("external"!==e.storage){if(this._decorator.columnName)throw this.systemError("'columnName' decorator member is only allowed in class with 'external' storage");if(this._decorator.columnType)throw this.systemError("'columnType' decorator member is only allowed in class with 'external' storage")}if(!this.isStored&&!this.isMutable&&!this.isTransientInput&&this.defaultValue&&"collection"!==this.type&&("sql"===e.storage||"external"===e.storage))throw this.systemError("defaultValue is not allowed on computed properties");if(this.verifyDefaultValue(),this.isNullable&&this.isRequired)throw this.systemError("required property cannot be nullable");if(void 0===this.type)throw this.systemError("type is undefined");if(this.isVitalParent&&!e.isVitalChild)throw this.systemError("The 'isVitalParent' attribute can only be used in nodes flagged with 'isVitalReferenceChild' or 'isVitalCollectionChild'");if(this.isVitalParent&&this.isTransientInput)throw this.systemError("A vital parent property cannot be a transient input");if(this.isVitalParent&&this.isMutable)throw this.systemError("A vital parent property cannot be a mutable property");if(this.isVitalParent&&!this.isStored)throw this.systemError("A vital parent property must be flagged with 'isStored'");if(this.isReferenceArrayProperty()){const e=this.decorator.onDelete;if(this.isStored&&null==e)throw this.systemError("onDelete attribute is required for reference array properties");else if(!this.isStored&&null!=e)throw this.systemError("onDelete attribute is only allowed for stored reference array properties")}if(this.isMutable&&!exports.foreignNodePropertyTypes.includes(this.type))throw this.systemError("A mutable property must be either a collection or a reference");if(this.decorator.node)if(!exports.foreignNodePropertyTypes.includes(this.type))throw this.systemError(`Invalid property type: expected ${exports.foreignNodePropertyTypes.join(" | ")}, got '${this.type}'`);if("external"!==this.factory.storage&&this.serviceOptions.length>0&&this.isReferenceProperty()&&!this.isNullable&&this.serviceOptions.some(e=>!this.factory.serviceOptions.includes(e)))throw this.systemError("A reference property depending on a service option must be nullable");if(false===this._isFrozen)if(this.isFrozen)throw this.systemError("Cannot override isFrozen if already frozen in base class");if(this.duplicatedValue&&!this.factory.canCreate)if(this.factory.isVitalChild){let e=this.factory.vitalParentFactory,t=e.canCreate;for(;!t&&e&&(t=e.canCreate,!t);)e=e.vitalParentFactory;if(!t)throw this.systemError("The duplicatedValue attribute is only allowed for a vital node if at least one of its parents has canCreate set to true.")}else throw this.systemError("The duplicatedValue attribute is only allowed for non vital node if it has canCreate set to true.");if(this.isReferenceProperty()&&!this.isNullable&&this.factory.naturalKey&&!this.targetFactory.naturalKey&&!this.targetFactory.isContentAddressable&&void 0===this.defaultValue)if(["AccountsReceivableInvoiceLineStaging","JournalEntryLineStaging","AccountsPayableInvoiceLineStaging","JournalEntryLineStaging"].includes(this._factory.name))propertyLogger.warn(()=>`${this._factory.name}.${this.name}: must be natural key`);else throw this.systemError("Reference properties on nodes with a natural key must either; be linked to a target node with a natural key, be nullable, or have defaultValue.");if(this.verifyAnonymizeMethod(),this.dataType)if("development"===xtrem_config_1.ConfigManager.current.deploymentMode){if(!(e=>{if(!e||e.includes("new"))return;const t=/(?:[^.]+\.)*(\w+)\.?/.exec(e);return t?t[1]:void 0})(this?.decorator?.dataType?.toString()))propertyLogger.warn(`${e.name}.${this.name}: anonymous DataTypes are not allowed`)}if(this.verifyDelegatesTo(),this.cacheComputedValue&&!this.getValue&&!this.computeValue)throw this.systemError("cacheComputedValue is only allowed if getValue or computeValue is set")}verifyAnonymizeMethod(){if(this.decorator.anonymizeMethod){if(void 0===this.decorator.dataSensitivityLevel)throw this.systemError("dataSensitivityLevel is required when specifying an anonymize method.");if(["fixed","custom"].includes(this.decorator.anonymizeMethod)&&void 0===this.decorator.anonymizeValue)throw this.systemError("anonymizeValue is required for 'fixed' and 'custom' anonymize methods.");if(["hash","hashLimit"].includes(this.decorator.anonymizeMethod)&&"string"!==this.type)throw this.systemError("anonymizeMethod 'hash' is only applicable to properties of type string.");if("random"===this.decorator.anonymizeMethod&&!["short","integer","float","decimal","double"].includes(this.type))throw this.systemError("anonymizeMethod 'random' is only applicable to properties with a number type.");if("hashLimit"===this.decorator.anonymizeMethod&&(void 0===this.decorator.anonymizeValue||!(0,lodash_1.isNumber)(this.decorator.anonymizeValue)))throw this.systemError("A number is required in anonymizeValue for 'hashLimit' anonymize method.");if("binary"===this.decorator.anonymizeMethod&&"string"==typeof this.decorator.anonymizeValue&&!["pdf","image"].includes(this.decorator.anonymizeValue))throw this.systemError("A valid AnonymizeBinary value is required in anonymizeValue for 'binary' anonymize method.")}}addExtension(e){this.verifyExtensionKeys(Object.keys(e),exports.overridableAttributes),this.overrideAttributes(e)}verifyExtensionKeys(e,t){e.filter(e=>!t.includes(e)).forEach(e=>{throw this.systemError(`${e} can't be redefined by an extension.`)})}overrideAttributes(e){Object.keys(e).forEach(t=>{switch(t){case"name":case"type":if(this.decorator[t]!==e[t])throw this.systemError(`Extension mismatch on ${t}`);break;case"columnName":case"dependencyIndex":case"extends":case"isOverride":default:break;case"isFrozen":this[t]=(0,decorator_utils_1.chainIsFrozens)(this,e);break;case"getValue":if(void 0!==e.getValue)this._getValue=e.getValue,this._computeValue=void 0;break;case"computeValue":if(void 0!==e.computeValue)this._computeValue=e.computeValue,this._getValue=void 0;break;case"defaultValue":case"deferredDefaultValue":if(void 0!==e[t])this[t]=e[t];break;case"duplicatedValue":if(void 0!==e.duplicatedValue)this.duplicatedValue=e.duplicatedValue;break;case"updatedValue":if(void 0!==e.updatedValue)this.updatedValue=e.updatedValue;break;case"adaptValue":if(void 0!==e.adaptValue)this.adaptValue=e.adaptValue;break;case"prepare":case"control":case"setValue":try{this[t]=(0,decorator_utils_1.chainEvents)(this[t],e[t],t)}catch(e){throw this.systemError(e.message)}break;case"dependsOn":case"updateDependsOn":this[t]=(0,decorator_utils_1.chainArrays)(this[t],e[t])}})}getTypeDefaultValue(){return(0,util_1.typeDefaultValue)(this.type,this.isNullable,this.isLocalized,this.factory.storage)}get decorator(){return this._decorator}get name(){return this._decorator.name}get fullName(){return`${this.factory.name}.${this.name}`}get type(){return this._decorator.type}get serviceOptions(){if(!this.#e)this.#e=(0,lodash_1.uniq)([...this._decorator.serviceOptions?.()||[],...this.dataType&&this.dataType.serviceOptions||[],...this.isForeignNodeProperty()&&this.targetFactory.serviceOptions||[]]);return this.#e}get propagatesTo(){return this._propagatesTo}set propagatesTo(e){this._propagatesTo=e}get updatePropagatesTo(){return this._updatePropagatesTo}set updatePropagatesTo(e){this._updatePropagatesTo=e}get dependsOn(){return this._dependsOn||this._decorator.dependsOn}set dependsOn(e){this._dependsOn=e}get updateDependsOn(){return this._updateDependsOn||this._decorator.updateDependsOn}set updateDependsOn(e){this._updateDependsOn=e}get dependencyIndex(){return void 0===this._dependencyIndex?this._decorator.dependencyIndex:this._dependencyIndex}set dependencyIndex(e){this._dependencyIndex=e}get isOverride(){return!!this._decorator.isOverride}get isInherited(){return void 0===this._isInherited?!!this._decorator.isInherited:this._isInherited}set isInherited(e){this._isInherited=e}get isClearedByReset(){if(this.delegatesTo)return this.getDelegatingInfo().childProperty.isClearedByReset;return this._decorator.isClearedByReset}get duplicateRequiresPrompt(){return this._decorator.duplicateRequiresPrompt}set isSystemProperty(e){this._isSystemProperty=e}get isSystemProperty(){return!!this._isSystemProperty}get rootProperty(){if(!this.factory.baseFactory)return this;const e=this.factory.baseFactory.propertiesByName[this.name];return e?e.rootProperty:this}get delegatesTo(){return this._decorator.delegatesTo}getDelegatingInfo(){const e=this.delegatesTo;if(!e)throw this.logicError("missing delegatesTo attribute");const t=Object.keys(e);if(1!==t.length)throw this.logicError(`expected 1 key in delegatesTo, got ${t.length}`);const r=this.factory.findProperty(t[0]);if(!r.isReferenceProperty())throw this.logicError(`delegating property ${t[0]} is not a reference`);const i=e[r.name];if("string"!=typeof i)throw this.logicError("delegatesTo child property name is not a string");const s=r.targetFactory.findProperty(i);return{reference:r,childProperty:s}}get invalidForIndexReason(){switch(this.type){case"string":if(this.isLocalized)return`${this.type} - localized`;if(this.isStringProperty()&&this.isStoredEncrypted)return`${this.type} - encrypted`;return"";case"reference":if(this.isVital)return`${this.type} - vital`;return"";case"boolean":case"enum":case"short":case"integer":case"float":case"double":case"decimal":case"date":case"datetime":case"time":case"uuid":case"dateRange":return"";default:return this.type}}get accessCode(){return this._decorator.accessCode}get isStored(){return!!this.decorator.isStored||!!this.decorator.isStoredOutput}get isTransientInput(){if(this.delegatesTo)return this.getDelegatingInfo().childProperty.isTransientInput;return!!this._decorator.isTransientInput}get isStoredOutput(){return!!this._decorator.isStoredOutput}get columnType(){return this._columnType||this._decorator.columnType}set columnType(e){this._columnType=e}get columnName(){if(this._columnName)return this._columnName;if(!this.isStored&&this.getValue||this.isStored&&"external"!==this._factory.storage)return(0,xtrem_shared_1.nameToSqlName)(this.name);return this._decorator.columnName}set columnName(e){this._columnName=e}get requiredColumnName(){const e=this.columnName;if(!e)throw this.logicError("missing columnName");return e}get column(){if(this._column)return this._column;const e=this._factory,t=e.table&&e.table.columns.find(e=>e.propertyName===this.name);if(!t){if("sql"===e.storage&&this.isStored&&!this.isInherited)propertyLogger.warn(`${e.name}.${this.name}: no column ${this.columnName}`);return}return t}set column(e){this._column=e}get isAutoIncrement(){return void 0===this._isAutoIncrement?!!this._decorator.isAutoIncrement:this._isAutoIncrement}set isAutoIncrement(e){this._isAutoIncrement=e}get provides(){return this._decorator.provides}get isOwnedByCustomer(){return this._decorator.isOwnedByCustomer}get canSearch(){return!!this._decorator.canSearch}get searchCategory(){return this._decorator.searchCategory}get lookupAccess(){return!!this._decorator.lookupAccess||this.isVital&&this.isReferenceProperty()||this.isVitalParent||this.isAssociationParent}get excludedFromPayload(){return!!this._decorator.excludedFromPayload}get isPublished(){if(this.delegatesTo)return this.getDelegatingInfo().childProperty.isPublished;return!!this._decorator.isPublished}get isRequired(){if(this.delegatesTo)return this.getDelegatingInfo().childProperty.isRequired;return!!this._decorator.isRequired}get isFrozen(){if(this.delegatesTo)return this.getDelegatingInfo().childProperty.isFrozen;if(this.isVitalParent||this.isAssociationParent)return true;return void 0===this._isFrozen?this._decorator.isFrozen:this._isFrozen}set isFrozen(e){this._isFrozen=e}get dataType(){return this._decorator.dataType?this._decorator.dataType():void 0}get isVitalParent(){return false}get isAssociationParent(){return false}get isExtendedProperty(){return this.definingPackage!==this.factory.package}get max(){return this._decorator.max}get defaultValue(){return void 0===this._defaultValue?this._decorator.defaultValue:this._defaultValue}set defaultValue(e){this._defaultValue=e}get deferredDefaultValue(){return void 0===this._deferredDefaultValue?this._decorator.deferredDefaultValue:this._deferredDefaultValue}set deferredDefaultValue(e){this._deferredDefaultValue=e}get duplicatedValue(){return void 0===this._duplicatedValue?this._decorator.duplicatedValue:this._duplicatedValue}set duplicatedValue(e){this._duplicatedValue=e}get updatedValue(){return void 0===this._updatedValue?this._decorator.updatedValue:this._updatedValue}set updatedValue(e){this._updatedValue=e}get adaptValue(){return void 0===this._adaptValue?this._decorator.adaptValue:this._adaptValue}set adaptValue(e){this._adaptValue=e}get setValue(){return void 0===this._setValue?this._decorator.setValue:this._setValue}set setValue(e){this._setValue=e}get control(){return void 0===this._control?this._decorator.control:this._control}set control(e){this._control=e}get prepare(){return void 0===this._prepare?this._decorator.prepare:this._prepare}set prepare(e){this._prepare=e}get getValue(){return"_getValue"in this?this._getValue:this._decorator.getValue}set getValue(e){this._getValue=e}get computeValue(){return"_computeValue"in this?this._computeValue:this._decorator.computeValue}set computeValue(e){this._computeValue=e}get cacheComputedValue(){return!!this._decorator.cacheComputedValue}get isNullable(){if(this.delegatesTo)return this.getDelegatingInfo().childProperty.isNullable;return!!this._decorator.isNullable}get allowedInUniqueIndex(){return!!this._decorator.allowedInUniqueIndex}get isVital(){return false}get isMutable(){return false}get isNotEmpty(){return false}get isLocalized(){return false}get isNotZero(){return false}get enum(){return}get maxLength(){return}get countColumnName(){return}get reverseReference(){return}get join(){return}get isOutputOnly(){if(this.delegatesTo)return this.getDelegatingInfo().childProperty.isOutputOnly;return isPropertyOutputOnly(this)}get isOnOutputType(){if(this.delegatesTo)return this.getDelegatingInfo().childProperty.isOnOutputType;return(this.isOutputOnly||this.isPublished||!this.excludedFromPayload)&&!this.isTransientInput}get isInputOnly(){if(this.delegatesTo)return this.getDelegatingInfo().childProperty.isInputOnly;return isPropertyInputOnly(this)}get isOnInputType(){if(this.delegatesTo)return this.getDelegatingInfo().childProperty.isOnInputType;return this.isPublished&&!this.isStoredOutput&&(!!this.setValue||this.isInputOnly||this.isMutable||this.isStored||this.isTransientInput)}get canTranslateToSql(){if(this.delegatesTo)return this.getDelegatingInfo().childProperty.canTranslateToSql;return this.isStored||!!this.getValue}get canSort(){return this.canTranslateToSql}get canFilter(){return this.canTranslateToSql}get sqlAttributes(){return this.decorator.sqlAttributes}async isEnabledByServiceOptions(e){return await(0,xtrem_async_helper_1.asyncArray)(this.serviceOptions).every(t=>e.isServiceOptionEnabled(t))&&e.isAccessCodeAvailable(this.accessCode)}async isAuthorized(e){if(this.factory.authorizedBy){const t=(await this.factory.authorizedBy(e,this.name,{}))?.status;if(void 0!==t)return"authorized"===t||"readonly"===t}const t=(await context_1.Context.accessRightsManager.getUserAccessFor(e,this.factory.name,this.name)).status;return"authorized"===t||"readonly"===t}isBooleanProperty(){return"boolean"===this.type}isIntegerProperty(){return"short"===this.type||"integer"===this.type}isFloatingPointProperty(){return"float"===this.type||"double"===this.type}isDecimalProperty(){return"decimal"===this.type}isNumberProperty(){return this.isIntegerProperty()||this.isDecimalProperty()||this.isForeignNodeProperty()}isStringProperty(){return"string"===this.type}isStringArrayProperty(){return"stringArray"===this.type}isDateProperty(){return"date"===this.type}isDatetimeProperty(){return"datetime"===this.type}isDatetimeRangeProperty(){return"datetimeRange"===this.type}isDateRangeProperty(){return"dateRange"===this.type}isRangeProperty(){return["integerRange","decimalRange","dateRange","datetimeRange"].includes(this.type)}isTimeProperty(){return"time"===this.type}isForeignNodeProperty(){return this.isReferenceProperty()||this.isReferenceArrayProperty()||this.isCollectionProperty()}isReferenceProperty(){return"reference"===this.type}isReferenceArrayProperty(){return"referenceArray"===this.type}isCollectionProperty(){return"collection"===this.type}isArrayProperty(){return arrays_1.arrayTypes.includes(this.type)}isEnumProperty(){return"enum"===this.type}isEnumArrayProperty(){return"enumArray"===this.type}isJsonProperty(){return"json"===this.type}isTextStreamProperty(){return"textStream"===this.type}isBinaryStreamProperty(){return"binaryStream"===this.type}needsTypeConversion(e){return false}mapInputValue(e){return e}executeRule(e,t,...r){const i=this[t];return e.context.sqlSpy.withRuleMetrics({nodeName:this.factory.name,propertyName:this.name,ruleName:t},()=>i.apply(e.node,r))}testSqlConversion(e){return this.factory.application.asRoot.withReadonlyContext("7".repeat(21),t=>{try{return new sql_1.SqlConverter(t,this.factory,{quiet:true}).convertFunction(e),null}catch(e){return e.message}},{withoutSqlConnection:true})}async testSqlConversions(){let e=0;const t=this.getValue,r=this.computeValue;if(t&&r)propertyLogger.error(`${this.fullName}: getValue and computeValue cannot be set at the same time`),e+=1;if(t){const r=await this.testSqlConversion(t);if(r)propertyLogger.error(`${this.fullName}: getValue cannot be converted to SQL, replace it by computeValue: \n[${r}]`),e+=1}else if(r&&!await this.testSqlConversion(r))propertyLogger.error(`${this.fullName}: computeValue can be converted to SQL, replace it by getValue`),e+=1;return e}inputError(e){return new xtrem_shared_1.BusinessRuleError(`${this._factory.name}.${this.name}: ${e}`)}systemError(e){return new xtrem_shared_1.SystemError(`${this._factory.name}.${this.name}: ${e}`)}logicError(e){return new xtrem_shared_1.LogicError(`${this._factory.name}.${this.name}: ${e}`)}}function isPropertyOutputOnly(e){if(e.delegatesTo){const{childProperty:t}=e.getDelegatingInfo();return isPropertyOutputOnly(t)}if(e.isStoredOutput)return true;if((e.getValue||e.computeValue)&&!e.setValue)return true;if(e.isReferenceProperty()&&e.decorator.join&&!e.isMutable)return true;if(e.isCollectionProperty()){if(!(e.isTransientInput||e.isMutable))return true;if(e.getFilter)return true}return false}function isPropertyInputOnly(e){if(e.isTransientInput||!e.getValue&&!e.computeValue&&e.setValue)return true;return false}exports.Property=Property;
//# sourceMappingURL=property.js.map