import { AnyValue, AsyncResponse } from '@sage/xtrem-async-helper';
import { ColumnTypeName, integer, SystemError } from '@sage/xtrem-shared';
import { BinaryStreamProperty, TextStreamProperty } from '.';
import { Package, ServiceOption } from '../application';
import { DelegatesTo, PropertyFilterTag, PropertySqlAttributes, TypedPropertyDecorator } from '../decorators';
import { TypeName } from '../decorators/decorator-utils';
import { PropertyRuleName, SetValueData } from '../decorators/property-decorators/base-property-events';
import { NodeState } from '../node-state';
import { Context } from '../runtime/context';
import { FactoryDecorators, NodeFactory } from '../runtime/node-factory';
import { Column } from '../sql/schema';
import { AnyNode, Node, ValidationContext, Validator } from '../ts-api';
import { DataType, Enum, InternalPropertyJoin } from '../types';
import { BooleanProperty } from './boolean-property';
import { DateProperty, DateRangeProperty, DatetimeProperty, DatetimeRangeProperty, TimeProperty } from './date-time-property';
import { EnumArrayProperty, EnumProperty } from './enum-property';
import { CollectionProperty, ForeignNodeProperty, ReferenceArrayProperty, ReferenceProperty } from './foreign-node-property';
import { JsonProperty } from './json-property';
import { DecimalProperty, DoubleProperty, FloatProperty, IntegerProperty, NumberProperty } from './numeric-property';
import { StringArrayProperty, StringProperty } from './string-property';
export declare abstract class Property {
    #private;
    protected _decorator: TypedPropertyDecorator;
    readonly definingPackage: Package;
    private _dependencyIndex?;
    private _propagatesTo?;
    private _updatePropagatesTo?;
    private _column?;
    protected _columnName?: string;
    protected _factory: NodeFactory;
    private _columnType?;
    private _isInherited?;
    private _isAutoIncrement?;
    private _isSystemProperty?;
    private _isFrozen?;
    private _defaultValue?;
    private _deferredDefaultValue?;
    private _duplicatedValue?;
    private _updatedValue?;
    private _adaptValue?;
    private _getValue?;
    private _computeValue?;
    private _setValue?;
    private _control?;
    private _prepare?;
    private _dependsOn?;
    private _updateDependsOn?;
    constructor(factory: NodeFactory, _decorator: TypedPropertyDecorator, definingPackage: Package);
    get factory(): NodeFactory;
    get _factoryDecorators(): FactoryDecorators;
    /**
     * Returns whether this property should be lazy loaded
     */
    get shouldLazyLoad(): boolean;
    /**
     * Returns the name of attributes that differ between 2 properties
     */
    static getDecoratorsDifferences(prop1: Property | TypedPropertyDecorator, prop2: Property | TypedPropertyDecorator): string[];
    getLocalizedTitleKey(): string;
    getLocalizedTitle(context: Context): string;
    verifyDelegatedToProperty(toProperty: Property): void;
    private verifyDelegatesTo;
    private verifyDuplicatedValue;
    private verifyClearByReset;
    private verifyDefaultValue;
    verify(): void;
    private verifyAnonymizeMethod;
    addExtension(extension: TypedPropertyDecorator): void;
    protected verifyExtensionKeys(extensionKeys: string[], authorizedKeys: string[]): void;
    protected overrideAttributes(extension: TypedPropertyDecorator): void;
    getTypeDefaultValue(): AnyValue;
    get decorator(): TypedPropertyDecorator;
    get name(): string;
    get fullName(): string;
    get type(): TypeName;
    get serviceOptions(): ServiceOption[];
    get propagatesTo(): PropagatePropertyPath[] | undefined;
    set propagatesTo(paths: PropagatePropertyPath[] | undefined);
    get updatePropagatesTo(): PropagatePropertyPath[] | undefined;
    set updatePropagatesTo(paths: PropagatePropertyPath[] | undefined);
    get dependsOn(): any[] | undefined;
    set dependsOn(dependsOn: any[] | undefined);
    get updateDependsOn(): any[] | undefined;
    set updateDependsOn(updateDependsOn: any[] | undefined);
    get dependencyIndex(): number | undefined;
    set dependencyIndex(index: number | undefined);
    get isOverride(): boolean;
    get isInherited(): boolean;
    set isInherited(isInherited: boolean);
    get isClearedByReset(): InternalBooleanOrUndefined;
    get duplicateRequiresPrompt(): InternalBooleanOrUndefined;
    set isSystemProperty(isSystemProperty: boolean);
    get isSystemProperty(): boolean;
    get rootProperty(): this;
    get delegatesTo(): DelegatesTo<AnyNode> | undefined;
    getDelegatingInfo(): {
        reference: ReferenceProperty;
        childProperty: Property;
    };
    /** Returns an empty string if the property can be used in an index, otherwise the reason why
     * the property cannot be used in an index */
    get invalidForIndexReason(): string;
    get accessCode(): string | undefined;
    get isStored(): boolean;
    get isTransientInput(): boolean;
    get isStoredOutput(): boolean;
    get columnType(): ColumnTypeName | undefined;
    set columnType(columnType: ColumnTypeName | undefined);
    get columnName(): string | undefined;
    set columnName(name: string | undefined);
    get requiredColumnName(): string;
    get column(): Column | undefined;
    set column(column: Column | undefined);
    get isAutoIncrement(): boolean;
    set isAutoIncrement(isAutoIncrement: boolean);
    get provides(): PropertyFilterTag[] | undefined;
    get isOwnedByCustomer(): boolean | undefined;
    get canSearch(): boolean;
    get searchCategory(): string | undefined;
    get lookupAccess(): boolean;
    get excludedFromPayload(): boolean;
    get isPublished(): boolean;
    get isRequired(): boolean;
    get isFrozen(): InternalBooleanOrUndefined;
    set isFrozen(isFrozen: InternalBooleanOrUndefined);
    get dataType(): DataType<AnyValue, Node> | undefined;
    get isVitalParent(): boolean;
    get isAssociationParent(): boolean;
    get isExtendedProperty(): boolean;
    get max(): integer | undefined;
    get defaultValue(): InternalDefaultValueRule;
    set defaultValue(defaultValue: InternalDefaultValueRule);
    get deferredDefaultValue(): InternalDefaultValueRule;
    set deferredDefaultValue(deferredDefaultValue: InternalDefaultValueRule);
    get duplicatedValue(): InternalDuplicatedValueRule;
    set duplicatedValue(duplicatedValue: InternalDuplicatedValueRule);
    get updatedValue(): InternalUpdatedValueRule;
    set updatedValue(updatedValue: InternalUpdatedValueRule);
    get adaptValue(): ((this: Node, val: AnyValue) => AsyncResponse<AnyValue>) | undefined;
    set adaptValue(adaptValue: ((this: Node, val: AnyValue) => AsyncResponse<AnyValue>) | undefined);
    get setValue(): ((this: Node, val: SetValueData<AnyValue>) => AsyncResponse<void>) | undefined;
    set setValue(setValue: ((this: Node, val: SetValueData<AnyValue>) => AsyncResponse<void>) | undefined);
    get control(): Validator<Node, AnyValue> | undefined;
    set control(control: Validator<Node, AnyValue> | undefined);
    get prepare(): ((this: Node, cx: ValidationContext, val: AnyValue) => AsyncResponse<void>) | undefined;
    set prepare(prepare: ((this: Node, cx: ValidationContext, val: AnyValue) => AsyncResponse<void>) | undefined);
    get getValue(): ((this: Node) => AsyncResponse<AnyValue>) | undefined;
    set getValue(getValue: ((this: Node) => AsyncResponse<AnyValue>) | undefined);
    get computeValue(): ((this: Node) => AsyncResponse<AnyValue>) | undefined;
    set computeValue(computeValue: ((this: Node) => AsyncResponse<AnyValue>) | undefined);
    get cacheComputedValue(): boolean;
    get isNullable(): boolean;
    get allowedInUniqueIndex(): boolean;
    get isVital(): boolean;
    get isMutable(): boolean;
    get isNotEmpty(): boolean;
    get isLocalized(): boolean;
    get isNotZero(): boolean;
    get enum(): Enum | undefined;
    get maxLength(): number | undefined;
    get countColumnName(): Enum | undefined;
    get reverseReference(): string | undefined;
    get join(): InternalPropertyJoin<Node> | undefined;
    get isOutputOnly(): boolean;
    get isOnOutputType(): boolean;
    get isInputOnly(): boolean;
    get isOnInputType(): boolean;
    get canTranslateToSql(): boolean;
    get canSort(): boolean;
    get canFilter(): boolean;
    /**
     * Internal sql attributes used when we generate the column SQL definition.
     * default - used on the column DEFAULT
     */
    get sqlAttributes(): PropertySqlAttributes | undefined;
    isEnabledByServiceOptions(context: Context): Promise<boolean>;
    isAuthorized(context: Context): Promise<boolean>;
    isBooleanProperty(): this is BooleanProperty;
    isIntegerProperty(): this is IntegerProperty;
    isFloatingPointProperty(): this is FloatProperty | DoubleProperty;
    isDecimalProperty(): this is DecimalProperty;
    isNumberProperty(): this is NumberProperty;
    isStringProperty(): this is StringProperty;
    isStringArrayProperty(): this is StringArrayProperty;
    isDateProperty(): this is DateProperty;
    isDatetimeProperty(): this is DatetimeProperty;
    isDatetimeRangeProperty(): this is DatetimeRangeProperty;
    isDateRangeProperty(): this is DateRangeProperty;
    isRangeProperty(): boolean;
    isTimeProperty(): this is TimeProperty;
    isForeignNodeProperty(): this is ForeignNodeProperty;
    isReferenceProperty(): this is ReferenceProperty;
    isReferenceArrayProperty(): this is ReferenceArrayProperty;
    isCollectionProperty(): this is CollectionProperty;
    isArrayProperty(): boolean;
    isEnumProperty(): this is EnumProperty;
    isEnumArrayProperty(): this is EnumArrayProperty;
    isJsonProperty(): this is JsonProperty;
    isTextStreamProperty(): this is TextStreamProperty;
    isBinaryStreamProperty(): this is BinaryStreamProperty;
    abstract isValueTypeValid(value: AnyValue): boolean;
    needsTypeConversion(_value: AnyValue): boolean;
    mapInputValue(value: AnyValue): AnyValue;
    executeRule<ResultT extends AnyValue>(state: NodeState, ruleName: PropertyRuleName, ...args: AnyValue[]): Promise<ResultT>;
    testSqlConversion(fn: () => any): Promise<string | null>;
    /** Test if getValue and computeValue are correctly configured - used by xtrem-cop  */
    testSqlConversions(): Promise<integer>;
    inputError(message: string): SystemError;
    systemError(message: string): SystemError;
    logicError(message: string): SystemError;
}
export declare function isPropertyOutputOnly(property: Property): boolean;
export declare function isPropertyInputOnly(property: Property): boolean;
//# sourceMappingURL=property.d.ts.map