import { AnyValue } from '@sage/xtrem-async-helper';
import { Package } from '../application';
import { DecimalPropertyDecorator, DecimalRangePropertyDecorator, DoublePropertyDecorator, FloatPropertyDecorator, IntegerArrayPropertyDecorator, IntegerPropertyDecorator, IntegerRangePropertyDecorator, NumberPropertyDecorator, ShortPropertyDecorator } from '../decorators';
import { NodeFactory } from '../runtime';
import { Property } from './property';
export declare abstract class NumberProperty extends Property {
    protected _decorator: NumberPropertyDecorator;
    constructor(factory: NodeFactory, _decorator: NumberPropertyDecorator, definingPackage: Package);
    get isNotZero(): boolean;
}
export declare class IntegerProperty extends NumberProperty {
    protected _decorator: IntegerPropertyDecorator;
    constructor(factory: NodeFactory, _decorator: IntegerPropertyDecorator, definingPackage: Package);
    isValueTypeValid(value: AnyValue): boolean;
    needsTypeConversion(value: AnyValue): boolean;
    mapInputValue(value: AnyValue): AnyValue;
}
export declare class IntegerArrayProperty extends Property {
    protected _decorator: IntegerArrayPropertyDecorator;
    constructor(factory: NodeFactory, _decorator: IntegerArrayPropertyDecorator, definingPackage: Package);
    isValueTypeValid(value: AnyValue): boolean;
    needsTypeConversion(value: AnyValue): boolean;
    mapInputValue(value: AnyValue): AnyValue;
}
export declare class ShortProperty extends NumberProperty {
    protected _decorator: ShortPropertyDecorator;
    constructor(factory: NodeFactory, _decorator: ShortPropertyDecorator, definingPackage: Package);
    isValueTypeValid(value: AnyValue): boolean;
    needsTypeConversion(value: AnyValue): boolean;
    mapInputValue(value: AnyValue): AnyValue;
}
export declare class FloatProperty extends NumberProperty {
    protected _decorator: FloatPropertyDecorator;
    constructor(factory: NodeFactory, _decorator: FloatPropertyDecorator, definingPackage: Package);
    isValueTypeValid(value: AnyValue): boolean;
}
export declare class DoubleProperty extends NumberProperty {
    protected _decorator: DoublePropertyDecorator;
    constructor(factory: NodeFactory, _decorator: DoublePropertyDecorator, definingPackage: Package);
    isValueTypeValid(value: AnyValue): boolean;
}
export declare class DecimalProperty extends NumberProperty {
    protected _decorator: DecimalPropertyDecorator;
    constructor(factory: NodeFactory, _decorator: DecimalPropertyDecorator, definingPackage: Package);
    isValueTypeValid(value: AnyValue): boolean;
    needsTypeConversion(value: AnyValue): boolean;
    mapInputValue(value: AnyValue): AnyValue;
}
export declare class IntegerRangeProperty extends Property {
    protected _decorator: IntegerRangePropertyDecorator;
    constructor(factory: NodeFactory, _decorator: IntegerRangePropertyDecorator, definingPackage: Package);
    isValueTypeValid(value: AnyValue): boolean;
}
export declare class DecimalRangeProperty extends Property {
    protected _decorator: DecimalRangePropertyDecorator;
    constructor(factory: NodeFactory, _decorator: DecimalRangePropertyDecorator, definingPackage: Package);
    isValueTypeValid(value: AnyValue): boolean;
}
//# sourceMappingURL=numeric-property.d.ts.map