import { AnyValue } from '@sage/xtrem-async-helper';
import { Package } from '../application';
import { EnumArrayPropertyDecorator, EnumPropertyDecorator } from '../decorators';
import { NodeFactory } from '../runtime';
import { Enum, EnumDataType } from '../types';
import { Property } from './property';
export declare class EnumProperty extends Property {
    protected _decorator: EnumPropertyDecorator | EnumArrayPropertyDecorator;
    constructor(factory: NodeFactory, _decorator: EnumPropertyDecorator | EnumArrayPropertyDecorator, definingPackage: Package);
    get dataType(): EnumDataType;
    get enum(): Enum;
    isValueTypeValid(value: AnyValue): boolean;
    getTypeDefaultValue(): AnyValue;
}
export declare class EnumArrayProperty extends EnumProperty {
    protected _decorator: EnumArrayPropertyDecorator;
    constructor(factory: NodeFactory, _decorator: EnumArrayPropertyDecorator, definingPackage: Package);
    isValueTypeValid(value: AnyValue): boolean;
    needsTypeConversion(value: AnyValue): boolean;
    mapInputValue(value: AnyValue): AnyValue;
}
//# sourceMappingURL=enum-property.d.ts.map