/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.TimeProperty=exports.DatetimeRangeProperty=exports.DatetimeProperty=exports.DateRangeProperty=exports.DateProperty=void 0;const xtrem_date_time_1=require("@sage/xtrem-date-time"),property_1=require("./property");class DateProperty extends property_1.Property{constructor(e,t,r){super(e,t,r),this._decorator=t}isValueTypeValid(e){return xtrem_date_time_1.DateValue.isDate(e)}needsTypeConversion(e){return"string"==typeof e&&/^([12]\d{3}[-/](0[1-9]|1[0-2])[-/](0[1-9]|[12]\d|3[01]))$/.test(e)}mapInputValue(e){const t=e;return xtrem_date_time_1.DateValue.parse(t,"base","YYYY-MM-DD")}}exports.DateProperty=DateProperty;class DateRangeProperty extends property_1.Property{constructor(e,t,r){super(e,t,r),this._decorator=t}isValueTypeValid(e){return xtrem_date_time_1.DateRange.isDateRange(e)}needsTypeConversion(e){if("string"==typeof e)try{return xtrem_date_time_1.DateRange.parse(e),true}catch{}return false}mapInputValue(e){return xtrem_date_time_1.DateRange.parse(e)}}exports.DateRangeProperty=DateRangeProperty;const isValueConvertibleToDatetime=e=>"string"==typeof e&&/^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}Z$/.test(e);class DatetimeProperty extends property_1.Property{constructor(e,t,r){super(e,t,r),this._decorator=t}needsTypeConversion(e){return isValueConvertibleToDatetime(e)}isValueTypeValid(e){return xtrem_date_time_1.Datetime.isDatetime(e)}mapInputValue(e){const t=e;return xtrem_date_time_1.Datetime.parse(t)}}exports.DatetimeProperty=DatetimeProperty;class DatetimeRangeProperty extends property_1.Property{constructor(e,t,r){super(e,t,r),this._decorator=t}isValueTypeValid(e){return xtrem_date_time_1.DatetimeRange.isDatetimeRange(e)}needsTypeConversion(e){if("string"==typeof e)try{return xtrem_date_time_1.DatetimeRange.parse(e),true}catch{}return false}mapInputValue(e){return xtrem_date_time_1.DatetimeRange.parse(e)}}exports.DatetimeRangeProperty=DatetimeRangeProperty;class TimeProperty extends property_1.Property{constructor(e,t,r){super(e,t,r),this._decorator=t}isValueTypeValid(e){return xtrem_date_time_1.Time.isTime(e)}}exports.TimeProperty=TimeProperty;
//# sourceMappingURL=date-time-property.js.map