/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.createProperty=createProperty;const xtrem_shared_1=require("@sage/xtrem-shared"),_1=require("."),foreign_node_property_1=require("./foreign-node-property"),propertyNamesBlacklist=["prototype","constructor"];function createProperty(e,r,t){if(r.name&&(/^(#|__)/.test(r.name)||propertyNamesBlacklist.includes(r.name)))throw new xtrem_shared_1.SecurityError(`Unauthorized property name '${r.name}'`);switch(r.type){case"boolean":return new _1.BooleanProperty(e,r,t);case"enum":return new _1.EnumProperty(e,r,t);case"enumArray":return new _1.EnumArrayProperty(e,r,t);case"short":return new _1.ShortProperty(e,r,t);case"integer":return new _1.IntegerProperty(e,r,t);case"integerRange":return new _1.IntegerRangeProperty(e,r,t);case"integerArray":return new _1.IntegerArrayProperty(e,r,t);case"decimalRange":return new _1.DecimalRangeProperty(e,r,t);case"date":return new _1.DateProperty(e,r,t);case"dateRange":return new _1.DateRangeProperty(e,r,t);case"datetimeRange":return new _1.DatetimeRangeProperty(e,r,t);case"datetime":return new _1.DatetimeProperty(e,r,t);case"time":return new _1.TimeProperty(e,r,t);case"float":return new _1.FloatProperty(e,r,t);case"decimal":return new _1.DecimalProperty(e,r,t);case"double":return new _1.DoubleProperty(e,r,t);case"string":return new _1.StringProperty(e,r,t);case"stringArray":return new _1.StringArrayProperty(e,r,t);case"uuid":return new _1.UuidProperty(e,r,t);case"reference":{const n=r,o=e.application.getFactoryByConstructor(n.node());if("json"===e.storage||"json"===o.storage)return new foreign_node_property_1.JsonReferenceProperty(e,n,t);return new _1.ReferenceProperty(e,n,t)}case"referenceArray":{const n=r;return new foreign_node_property_1.ReferenceArrayProperty(e,n,t)}case"collection":return new _1.CollectionProperty(e,r,t);case"jsonReference":return new foreign_node_property_1.JsonReferenceProperty(e,r,t);case"json":return new _1.JsonProperty(e,r,t);case"binaryStream":return new _1.BinaryStreamProperty(e,r,t);case"textStream":return new _1.TextStreamProperty(e,r,t)}throw new xtrem_shared_1.LogicError(`${r.name}: couldn't create a property with type ${r.type}`)}
//# sourceMappingURL=create-property.js.map