/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.StateUtils=void 0;const xtrem_shared_1=require("@sage/xtrem-shared"),decorator_utils_1=require("../decorators/decorator-utils"),loggers_1=require("../runtime/loggers"),node_state_1=require("./node-state");class StateUtils{static checkNotStale(e){if(e.status===node_state_1.StateStatus.stale)throw new Error(`${e.interningKeyValues[0]}: invalid operation on stale node`)}static requiredPropertyError(e,t){return e.propertyDataInputError(t,{message:"property is required",key:"@sage/xtrem-core/property-is-required"})}static validateAccessControl(e,t,r){if(!t.provides||0===t.provides.length)return;for(const s of t.provides){if(!isFilterTag(s))continue;const o=e.context.getAllowedAccessCodes(s);if(void 0===o)continue;if(null===o)throw e.propertyDataInputError(t,{key:"@sage/xtrem-core/no-access",message:`Access not allowed to ${s}.`,data:{accessType:s,value:r._id}});if(0===o.length)continue;const i=String(r._id);if(!o.includes(i))throw e.propertyDataInputError(t,{key:"@sage/xtrem-core/no-access",message:`Access not allowed to ${s}.`,data:{accessType:s,value:i}})}}static isEnabledByServiceOptions(e,t){return e.context.isEnabledByServiceOptions(t)}static isPropertyGetterOnly(e){if(e.isCollectionProperty()){if(!(e.isTransientInput||e.isMutable))return true;if(e.getFilter)return true}if(e.isReferenceProperty()&&e.decorator.join&&!e.isMutable)return true;return!(!e.getValue&&!e.computeValue||e.setValue)}static formatStateValues(e){const t=Object.entries(e);return(t.length>1?t.filter(([e])=>"_id"!==e):t).map(([e,t])=>`${e}: ${t}`).join(", ")}static async withValidationErrorRethrow(e,t,r,s){try{await s()}catch(t){if(e.isOnlyForLookup||e.isOnlyForDuplicate)return void loggers_1.loggers.runtime.warn(t.message);if(e.isOnlyForDefaultValues){if(e.context.severity<xtrem_shared_1.ValidationSeverity.exception)e.context.addDiagnoseAtPath(xtrem_shared_1.ValidationSeverity.exception,r,t.message);return}if(t instanceof xtrem_shared_1.BaseError){if(!t.path)t.path=r;throw t}throw loggers_1.loggers.runtime.error(t.stack),new xtrem_shared_1.UnknownError(t.message,t,r)}}static restructureDelegatedInputValues(e,t){const r=e.delegatedProperties;if(0===r.length)return t;const s={...t};return r.forEach(e=>{const t=s[e.name];delete s[e.name];const{reference:r,childProperty:o}=e.getDelegatingInfo();if(void 0===t&&r.isNullable)return;let i=s[r.name];if(!i)i={},s[r.name]=i;if(void 0!==t)i[o.name]=t}),s}}function isFilterTag(e){return decorator_utils_1.FILTER_TAGS.includes(e)}exports.StateUtils=StateUtils;
//# sourceMappingURL=state-utils.js.map