/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.StateSetValue=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_config_1=require("@sage/xtrem-config"),xtrem_decimal_1=require("@sage/xtrem-decimal"),xtrem_toposort_1=require("@sage/xtrem-toposort"),_=require("lodash"),lodash_1=require("lodash"),collections_1=require("../collections"),array_utils_1=require("../runtime/array-utils"),loggers_1=require("../runtime/loggers"),utils_1=require("../runtime/utils"),ts_api_1=require("../ts-api"),lazy_loaded_marker_1=require("./lazy-loaded-marker"),node_state_1=require("./node-state"),state_dependency_1=require("./state-dependency"),state_get_value_1=require("./state-get-value"),state_init_1=require("./state-init"),state_intern_1=require("./state-intern"),state_invalidate_1=require("./state-invalidate"),state_join_1=require("./state-join"),state_load_1=require("./state-load"),state_new_1=require("./state-new"),state_old_1=require("./state-old"),state_utils_1=require("./state-utils");class StateSetValue{static async setRawValue(e,t,a){if(e.isThunk&&!e.factory.keyProperties.includes(t))await state_load_1.StateLoad.load(e);if(Array.isArray(a))e.values[t.name]=Object.freeze([...a]);else e.values[t.name]=a}static async setReference(e,t,a){if(a)state_utils_1.StateUtils.validateAccessControl(e,t,a);if(e.references.set(t.name,a),a)await state_join_1.StateJoin.assignJoinedProperties(e,t,a);else await StateSetValue.setRawValue(e,t,null)}static async setReferenceArray(e,t,a){if(a)await(0,xtrem_async_helper_1.asyncArray)(a).forEach(async a=>{state_utils_1.StateUtils.validateAccessControl(e,t,a)});if(e.referenceArrays.set(t.name,a),null!=a){const r=a.map(e=>e._id);await this.setRawValue(e,t,r)}else await StateSetValue.setRawValue(e,t,null)}static async setNewVitalReference(e,t,a,r){if(!t.targetFactory.isContentAddressable)state_join_1.StateJoin.initVitalReferenceJoin(e,t,r);const s=await state_init_1.StateInit.newFromContextCreate(e.context,t.targetFactory,a,r,{isOnlyForDefaultValues:e.isOnlyForDefaultValues,isOnlyForDuplicate:e.isOnlyForDuplicate,isOnlyForLookup:e.isOnlyForLookup,isTransient:e.isTransient});await StateSetValue.setReference(e,t,s.node)}static async setVitalReferenceValue(e,t,a,r){if(null!=r&&(0,utils_1.isScalar)(r))throw e.propertyDataInputError(t,{message:"invalid value for vital reference: typeof={{type}}, value={{value}}",key:"@sage/xtrem-core/invalid-value-vital-reference",data:{type:typeof r,value:r}});if(r){const s=await state_get_value_1.StateGetValue.getReferenceValue(e,t);if(s)if(t.targetFactory.isContentAddressable){if(s.$.state.isThunk)await state_load_1.StateLoad.load(s.$.state);await state_load_1.StateLoad.resolveLazyLoadedValues(s.$.state);const i=s.$.state.values,n=_.omit({...i,...r},"_id");if(t.targetFactory.getValuesHash(n)!==(i._valuesHash||t.targetFactory.getValuesHash(i)))await StateSetValue.setNewVitalReference(e,t,a,n)}else await s.$.state.set(r);else await StateSetValue.setNewVitalReference(e,t,a,r)}else{const a=await state_get_value_1.StateGetValue.getReferenceValue(e,t);if(a)if(e.references.delete(t.name),t.targetFactory.isContentAddressable)e.values[t.name]=null;else if(await state_intern_1.StateIntern.removeStateWithVitalChildren(e),!a.$.isNew)await a.$.state.delete({path:[t.name]});else state_intern_1.StateIntern.removeState(a.$.state)}}static async setVitalNodeReferenceValue(e,t,a){const r=t.targetFactory;if("sql"===r.storage||"external"===r.storage||r.keyPropertyNames.length>0){const s=await e.getPropertyValue(t);if(s&&!s.$.factory.isContentAddressable)if(!s.$.isNew)await s.$.state.delete({path:[t.name]});else state_intern_1.StateIntern.removeState(s.$.state);if(e.references.set(t.name,a),t.isVital){const t=r.vitalParentProperty;a.$.state.values[t.name]=e.values._id}}else if(t.setValue)await t.executeRule(e,"setValue",a);else throw e.propertyDataInputError(t,{message:"cannot update reference, decorator lacks key information",key:"@sage/xtrem-core/decorators-lacks-key-information"})}static resolveReference(e){return(state_intern_1.StateIntern.findState(e,e.isWritable)||e).node}static async setNonVitalReferenceValue(e,t,a){if(a||"external"===e.factory.storage&&"external"===t.targetFactory.storage&&null!=a){if(a instanceof ts_api_1.Node){const r=StateSetValue.resolveReference(a.$.state);await StateSetValue.setReference(e,t,r)}else if((0,utils_1.isCompound)(a)){if("string"==typeof a._id&&"sql"===t.targetFactory.storage)a._id=parseInt(a._id,10);const r=(await state_new_1.StateNew.newReferenceThunk(e,t.targetFactory,t,a,false)).node;await StateSetValue.setReference(e,t,r)}else if("sql"===t.targetFactory.storage&&"string"==typeof a)await this.setNonVitalReferenceValue(e,t,t.targetFactory.parseNodeId(a));else if(t.provides&&t.provides.length>0){const r=(await state_new_1.StateNew.newReferenceThunk(e,t.targetFactory,t,{_id:a},false)).node;await StateSetValue.setReference(e,t,r)}else if(await StateSetValue.setRawValue(e,t,a),Number(a)>0)e.context.prefetcher.visitSysId(t.targetFactory,false,String(a))}else{if("external"!==e.factory.storage&&null!==a)throw e.propertyDataInputError(t,{message:"invalid reference value: {{type}}, {{value}}",key:"@sage/xtrem-core/invalid-reference-value",data:{type:typeof a,value:a}});await StateSetValue.setReference(e,t,null)}}static async setReferenceArrayPropertyValue(e,t,a){if(a){if(!Array.isArray(a))throw e.propertyDataInputError(t,{message:"invalid reference array value: {{type}}, {{value}}",key:"@sage/xtrem-core/invalid-reference-array-value",data:{type:typeof a,value:a}});const checkReferenceExists=a=>{if("number"==typeof a._id&&a._id<0||Number.isNaN(a._id))throw e.propertyDataInputError(t,{message:"invalid value supplied. Record in array does not exist",key:"@sage/xtrem-core/record-does-not-exist"})};if(a.every(e=>e instanceof ts_api_1.Node)){const r=a.map(e=>(checkReferenceExists(e),StateSetValue.resolveReference(e.$.state)));await StateSetValue.setReferenceArray(e,t,r)}else if(a.every(e=>(0,utils_1.isCompound)(e))){const r=await(0,xtrem_async_helper_1.asyncArray)(a).map(async a=>{if("string"==typeof a._id&&"sql"===t.targetFactory.storage)a._id=parseInt(a._id,10);return checkReferenceExists(a),(await state_new_1.StateNew.newReferenceThunk(e,t.targetFactory,t,a,false)).node}).toArray();await StateSetValue.setReferenceArray(e,t,r)}else{const r=a.map(e=>{const a="sql"===t.targetFactory.storage&&"string"==typeof e?parseInt(e,10):e;return checkReferenceExists({_id:a}),a});await StateSetValue.setRawValue(e,t,r)}}else await StateSetValue.setReferenceArray(e,t,null)}static async setReferencePropertyValue(e,t,a,r){if(t.isMutable)if(r instanceof ts_api_1.Node)await StateSetValue.setVitalNodeReferenceValue(e,t,r);else await StateSetValue.setVitalReferenceValue(e,t,a,r);else await StateSetValue.setNonVitalReferenceValue(e,t,r)}static async updateCollectionItems(e,t,a,r){const s=await e.getPropertyValue(t);if(!(s instanceof collections_1.MutableCollection))throw e.propertyDataInputError(t,{message:"cannot update immutable collection",key:"@sage/xtrem-core/cannot-update-immutable-collection"});await s.update(a,r)}static unwrapNodes(e){if(e[0]instanceof ts_api_1.Node)return e.map(e=>({...e.$.state.values,_id:void 0}));return e}static async setCollectionPropertyValue(e,t,a,r){if(!Array.isArray(r))throw e.propertyDataInputError(t,{message:"invalid collection value: not an array",key:"@sage/xtrem-core/invalid-collection-value-not-array"});if(t.setValue)await t.executeRule(e,"setValue",r);else await StateSetValue.updateCollectionItems(e,t,a,StateSetValue.unwrapNodes(r))}static setLocalizedValue(e,t,a){let r=a;if(e.context.processLocalizedTextAsJson&&a&&e.values[t.name]){const s=e.values[t.name],i=a;if(s.startsWith("{")&&i.startsWith("{"))try{const e=JSON.parse(s),t=JSON.parse(i);r=JSON.stringify({...e,...t})}catch{throw e.propertyDataInputError(t,{message:"cannot parse the localized text {{value}}",key:"@sage/xtrem-core/cannot-parse-localized-text",data:{value:`${i}`}})}}return r}static async getValueOfNotWritableProperty(e,t,a){if(null!==a&&!await state_utils_1.StateUtils.isEnabledByServiceOptions(e,t))return loggers_1.loggers.core.verbose(()=>`Setting value of inactive property ${t.factory.name}.${t.name} depending on service options [${t.serviceOptions.map(e=>e.name)}]. Value has not been changed`),e.values[t.name];if(state_utils_1.StateUtils.isPropertyGetterOnly(t))throw e.propertyDataInputError(t,{message:"cannot set value on computed property",key:"@sage/xtrem-core/cannot-set-value-on-computed-property"});return a}static areReferencePropertyValuesEqual(e,t,a){if(e.join&&!(a instanceof ts_api_1.Node)){const r=Object.keys(e.join).find(t=>e.join?.[t]===e.name);if(r)return 0===(0,array_utils_1.valueComparator)(t[r],a)}return 0===(0,array_utils_1.valueComparator)(t,a)}static areLocalizedStringValueUnchanged(e,t,a){if(e.processLocalizedTextAsJson){if(!(a.startsWith("{")&&a.endsWith("}")))return false;if(t.startsWith("{")&&t.endsWith("}")){const e=a,r=t,s=JSON.parse(e),i=JSON.parse(r),n=JSON.stringify({...s,...i});return _.isEqual(n,e)}const r=[...e.locales,"base"],s=JSON.parse(a),i=r.find(e=>s[e]?.length);return i?t===s[i]:""===t}return 0===(0,array_utils_1.valueComparator)(a,t,e.locales)}static async areContentAddressableValuesEqual(e,t,a,r){const getValues=async a=>{if(a instanceof ts_api_1.Node)return await state_load_1.StateLoad.resolveLazyLoadedValues(a.$.state),a.$.state.values;if("number"==typeof a){const r=await e.read(t.targetFactory.nodeConstructor,{_id:a});return await state_load_1.StateLoad.resolveLazyLoadedValues(r.$.state),r.$.state.values}if("object"!=typeof a)throw t.logicError(`invalid value: ${typeof a}, ${a}`);return a},s=await getValues(r),i=await getValues(a);return t.targetFactory.getValuesHash(s)===t.targetFactory.getValuesHash({...s,...i})}static arePropertyValuesEqual(e,t,a,r){if(null==a||null==r)return Promise.resolve(a===r);if(t.isJsonProperty())return Promise.resolve((0,lodash_1.isEqual)(a,r));if(t.isReferenceProperty()&&t.targetFactory.isContentAddressable)return this.areContentAddressableValuesEqual(e,t,a,r);if(t.isReferenceProperty()&&a instanceof ts_api_1.Node)return Promise.resolve(StateSetValue.areReferencePropertyValuesEqual(t,a,r));if(t.isLocalized)return Promise.resolve(StateSetValue.areLocalizedStringValueUnchanged(e,a,r));if(t.isRangeProperty()&&a.toString&&r.toString)return Promise.resolve(a.toString()===r.toString());return Promise.resolve(0===(0,array_utils_1.valueComparator)(r,a))}static async isPropertyReadyToBeSet(e,t,a){let r=a;if(void 0===r||"_etag"===t.name||!await state_utils_1.StateUtils.isEnabledByServiceOptions(e,t))return{isPropertyReadyToBeSet:false,value:r};if(null!=r&&!t.isValueTypeValid(r)){if(!t.needsTypeConversion(r))throw e.propertyDataInputError(t,{message:"invalid value: {{type}}, {{value}}",key:"@sage/xtrem-core/invalid-value",data:{type:typeof r,value:r}});r=t.mapInputValue(r)}if(state_utils_1.StateUtils.checkNotStale(e),t.isReferenceProperty()&&"string"==typeof r&&"#"===r[0]){r=(await e.context.read(t.targetFactory.nodeConstructor,t.targetFactory.parseNodeId(r))).$.id}else r=await StateSetValue.getValueOfNotWritableProperty(e,t,r);if(e.status!==node_state_1.StateStatus.constructed&&"collection"!==t.type){let a=e.values[t.name];if(void 0!==r&&a===lazy_loaded_marker_1.lazyLoadedMarker)a=await state_load_1.StateLoad.resolveLazyLoadedValue(e,t);if(await StateSetValue.arePropertyValuesEqual(e.context,t,r,a))return{isPropertyReadyToBeSet:false,value:r}}return{isPropertyReadyToBeSet:true,value:r}}static async withChange(e,t,a){if(e.status===node_state_1.StateStatus.updatable)await state_old_1.StateOld.keepOldState(e);if(await a(),e.status===node_state_1.StateStatus.updatable)e.status=node_state_1.StateStatus.modified,e.skipSave=false;if(state_invalidate_1.StateInvalidate.clearInvalidated(e,t),e.status!==node_state_1.StateStatus.constructed||e.collection?.sourceNode.$.state.status===node_state_1.StateStatus.updatable||e.collection?.sourceNode.$.state.status===node_state_1.StateStatus.modified)await state_invalidate_1.StateInvalidate.invalidateDependantProperties(e,t)}static async adaptPropertyValue(e,t,a){if(null==a)return;let r=a;if("decimal"===t.type&&"number"==typeof r)r=xtrem_decimal_1.Decimal.make(r);const s=t.dataType;if(s&&!t.isForeignNodeProperty())r=await state_dependency_1.StateDependency.withDependenciesRestriction(e,t,()=>s.adaptValue(e.node,r)),await StateSetValue.setRawValue(e,t,r);if(t.adaptValue)r=await state_dependency_1.StateDependency.withDependenciesRestriction(e,t,()=>t.executeRule(e,"adaptValue",r)),await StateSetValue.setRawValue(e,t,r);if(t.isStringProperty()&&t.isStoredEncrypted)await StateSetValue.setRawValue(e,t,e.context.vault.recordValue(await e.context.vault.encrypt(r)))}static async isProtectedByVendor(e,t){if(t.isOwnedByCustomer||xtrem_config_1.ConfigManager.current.ignoreVendorProtection||!e.factory.hasVendorProperty)return false;return!!await e.vendor}static async ensurePropertyIsWritable(e,t,a){if(e.isEffectivelyReadonly&&!e.isTransient)throw e.dataInputError({message:"node is readonly",key:"@sage/xtrem-core/node-is-readonly"});if(e.status!==node_state_1.StateStatus.constructed&&e.status!==node_state_1.StateStatus.created&&!e.isOnlyForLookup&&!e.isOnlyForDefaultValues&&!e.isOnlyForDuplicate){if(await e.isNodeFrozen())throw e.dataInputError({message:"node is frozen",key:"@sage/xtrem-core/node-is-frozen"});if(await e.isPropertyFrozen(t)&&a!==e.values[t.name])throw e.propertyDataInputError(t,{message:"cannot set value on frozen property",key:"@sage/xtrem-core/cannot-set-value-on-frozen-property"});if(await StateSetValue.isProtectedByVendor(e,t))if(!t.isCollectionProperty())throw e.propertyDataInputError(t,{message:"cannot set value protected by a vendor",key:"@sage/xtrem-core/cannot-set-value-protected-by-a-vendor"})}}static async setPropertyValue(e,t,a,r){await state_utils_1.StateUtils.withValidationErrorRethrow(e,t,a,async()=>{let{isPropertyReadyToBeSet:s,value:i}=await StateSetValue.isPropertyReadyToBeSet(e,t,r);if(!s)return;if(t.columnName)e.dirtyColumnNames[t.columnName]=true;await StateSetValue.ensurePropertyIsWritable(e,t,i),await StateSetValue.withChange(e,t,async()=>{if(t.setValue)return void await t.executeRule(e,"setValue",i);if(t.isCollectionProperty())await StateSetValue.setCollectionPropertyValue(e,t,a,i);else if(t.isReferenceProperty())await StateSetValue.setReferencePropertyValue(e,t,a,i);else if(t.isReferenceArrayProperty())await StateSetValue.setReferenceArrayPropertyValue(e,t,i);else if(t.isLocalized)i=StateSetValue.setLocalizedValue(e,t,i);else await StateSetValue.setRawValue(e,t,i);await StateSetValue.adaptPropertyValue(e,t,i),state_intern_1.StateIntern.updatePropertyInterningKeys(e,t)})})}static async setState(e,t,a=[]){if(e.factory.isContentAddressable&&!e.isOnlyForLookup)throw e.logicError("Content-addressable node instances are immutable. You cannot modify them directly with node.$.set().");const r=state_utils_1.StateUtils.restructureDelegatedInputValues(e.factory,t),s=Object.keys(r).map(t=>e.factory.findProperty(t)),i=await(0,xtrem_async_helper_1.asyncArray)(s.filter(e=>{const t=r[e.name];return e.isReferenceProperty()&&"number"==typeof t&&t<0&&e.isNullable})).map(async t=>(await StateSetValue.setPropertyValue(e,t,[...a,t.name],null),t.name)).reduce((e,t)=>({...e,[t]:r[t]}),{}),n=s.filter(e=>!(e.name in i)),o=StateSetValue.sortPropertiesForSetState(e,n,r);await(0,xtrem_async_helper_1.asyncArray)(o).forEach(async t=>{const s=r[t.name];await StateSetValue.setPropertyValue(e,t,[...a,t.name],s)}),Object.keys(i).forEach(t=>{e.values[t]=i[t]})}static sortPropertiesForSetState(e,t,a){const r={};t.forEach(t=>{t.dependsOn?.forEach(a=>{if("string"!=typeof a)return;if(null==e.factory.propertiesByName[a])return;if(null==r[a])r[a]=[];r[a].push(t)})});const s=[];let i=false;if(t.forEach(e=>{const t=a[e.name];if(null==t)return;if(e.isCollectionProperty())if(Array.isArray(t)&&t.some(e=>"delete"===e._action)){const t=r[e.name];if(t)return s.push({name:e.name,dependsOn:t.map(e=>e.name),object:e}),void(i=true)}s.push({name:e.name,dependsOn:[],object:e})}),!i)return t;return(0,xtrem_toposort_1.topoSort)(s).map(e=>e.object)}}exports.StateSetValue=StateSetValue;
//# sourceMappingURL=state-set-value.js.map