/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.StatePrepare=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_shared_1=require("@sage/xtrem-shared"),collections_1=require("../collections"),system_exports_1=require("../system-exports"),ts_api_1=require("../ts-api"),lazy_loaded_marker_1=require("./lazy-loaded-marker"),state_invalidate_1=require("./state-invalidate"),state_utils_1=require("./state-utils");class StatePrepare{static async propertyCanBeControlled(e,t){if(state_utils_1.StateUtils.isPropertyGetterOnly(t))return false;if(!await state_utils_1.StateUtils.isEnabledByServiceOptions(e,t))return false;return true}static async skipPropertyInPrepareAndControl(e,t){if(e.isPropertyValueDeferred(t))return true;if(e.values[t.name]===lazy_loaded_marker_1.lazyLoadedMarker)return true;if(system_exports_1.SystemProperties.isUserManagementProperty(t))return true;return!await this.propertyCanBeControlled(e,t)}static async prepareReferenceProperty(e,t,r){if(t.prepare)await t.executeRule(e,"prepare",new ts_api_1.ValidationContext(e.context,r));const a=await e.getPropertyValue(t);if(null==a)return;const i=[...r,t.name];await state_utils_1.StateUtils.withValidationErrorRethrow(e,t,i,async()=>{await this.prepareState(a.$.state,i)})}static async prepareCollectionProperty(e,t,r){if(t.prepareBegin)await t.executeRule(e,"prepareBegin",new ts_api_1.ValidationContext(e.context,r));const a=await e.getPropertyValue(t);if(await a.forEach(async a=>{const i=collections_1.MutableCollection.fillPath(r,a);await state_utils_1.StateUtils.withValidationErrorRethrow(e,t,i,async()=>{await this.prepareState(a.$.state,i)})}),t.prepareEnd)await t.executeRule(e,"prepareEnd",new ts_api_1.ValidationContext(e.context,r))}static async prepareProperty(e,t,r){await state_utils_1.StateUtils.withValidationErrorRethrow(e,t,r,async()=>{if(await this.skipPropertyInPrepareAndControl(e,t))return;if(await state_invalidate_1.StateInvalidate.validatePropertyValue(e,t,r),t.isCollectionProperty()&&t.isMutable)await this.prepareCollectionProperty(e,t,r);else if(t.isReferenceProperty()&&t.isMutable)await this.prepareReferenceProperty(e,t,r);else if(t.prepare)await t.executeRule(e,"prepare",new ts_api_1.ValidationContext(e.context,r))})}static async prepareState(e,t){if(e.skipSave)return true;if(e.factory.prepareBegin)await e.factory.executeRule(e,"prepareBegin",new ts_api_1.ValidationContext(e.context,t));if(await(0,xtrem_async_helper_1.asyncArray)(e.factory.properties).forEach(r=>this.prepareProperty(e,r,[...t,r.name])),e.factory.prepareEnd)await e.factory.executeRule(e,"prepareEnd",new ts_api_1.ValidationContext(e.context,t));return!e.context.diagnoses.some(e=>e.severity>=xtrem_shared_1.ValidationSeverity.error)}}exports.StatePrepare=StatePrepare;
//# sourceMappingURL=state-prepare.js.map